/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "header.h"


struct cwdaemon *cwda;

struct cwdaemon *init_cwdaemon(){
    struct cwdaemon *cwda;
    int on;
    struct sockaddr_in sin;
    char s[8];

    cwda = g_new0(struct cwdaemon, 1);
        
    cwda->sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if (cwda->sock < 0) goto err;

    on=1;
    if (setsockopt(cwda->sock, SOL_SOCKET, SO_REUSEADDR, &on, sizeof(on))){
        dbg("Can't set SO_REUSEADDR\n");
        goto err;
    }
    
    if (fcntl(cwda->sock, F_SETFL, O_NONBLOCK)){
        dbg("Can't set O_NONBLOCK\n");
        goto err;
    }
    
    memset(&sin, 0, sizeof(struct sockaddr_in));
    sin.sin_family = AF_INET;
    sin.sin_port = htons(cfg->cwda_udp_port);
    if (!cfg->cwda_hostname) cfg->cwda_hostname = g_strdup("");
    inet_aton(cfg->cwda_hostname, &sin.sin_addr);
    
    if (connect(cwda->sock, (struct sockaddr *)&sin, sizeof(sin))){
        dbg("Can't connect\n");
        goto err;
    }
    set_handlers(cwda->sock, (void (*)(void *))cwdaemon_read_handler, NULL, NULL, (void*)cwda);

    sprintf(s,"\0330"); /* reset */
    send(cwda->sock, s, strlen(s)+1, 0);
    
    cwda->speed=cfg->cwda_speed;
    cwdaemon_send_defaults(cwda);
    return cwda;
err:;
    if (cwda->sock>=0) close(cwda->sock);
    cwda->sock = -1;
    return cwda;
}

void free_cwdaemon(struct cwdaemon *cwda){
/*    if (ctest->last_cq_timer_id){ 
        kill_timer(ctest->last_cq_timer_id);
        ctest->last_cq_timer_id = 0;
    }*/
    cq_abort(1);
    if (cwda->sock>=0) {
        cwdaemon_abort(cwda);
        close(cwda->sock);
    }
    g_free(cwda);
}

void cwdaemon_read_handler(struct cwdaemon *cwda){
    char s[1024];
    struct sockaddr_in sin;
    socklen_t socklen;
    int rcvd;

    dbg("cwdaemon_read_handler\n");
    if (!ctest) {
        /* we must clear kernel queue */
        recvfrom(cwda->sock, s, sizeof(s)-1, 0, 
            (struct sockaddr *)&sin, &socklen);
        return;
    }
    
    memset(s, 0, sizeof(s));
    socklen = sizeof(sin);
    rcvd=recvfrom(cwda->sock, s, sizeof(s)-1, 0, 
            (struct sockaddr *)&sin, &socklen);
    /*dbg("  received '%s' = %d  last_cq_timer_id=%d \n", s, rcvd, ctest->last_cq_timer_id);*/
    if (rcvd<=0) return;
    if (ctest->last_cq_timer_id){ /* CQ was abortet while playing */
        kill_timer(ctest->last_cq_timer_id);
        ctest->last_cq_timer_id = 0;
    }

    dbg("   rcvd: '%s'\n", s);
    switch(s[0]){
        case '!':  /* error */
            cq_abort(ssbd->recording); /*abort recording only if it is in progress */
            log_addf("cwdaemon: %s", s+1);
            break;
        case 'h':  /* cw text played */
	    if (!ctest || !ctest->last_cq) break; /* zdravime uW 2004 :-) */
            if (ctest->last_cq->cw_repeat) 
                cq_cw_wait(ctest->last_cq);
            else{
                ctest->last_cq->type=MOD_NONE;
                cq_abort(ssbd->recording);
            }
            peer_tx(aband, 0);
            redraw_later(term);
            break;
    }
}

/*void cq_timer_cw1(void *data){
    struct cq *cq;
    
    dbg("cq_timer_cw1\n");
    cq = (struct cq *)data;
    cq_cw_wait(cq); 
}  */

void cq_cw_wait(struct cq *cq){
    dbg("cq_cw_wait\n");
    ssbd_abort(ssbd,0);
    cwdaemon_ptt(cwda, 0);
    cwdaemon_ssbway(cwda, 0); /* microphone */
    peer_tx(aband, 0);
    ctest->last_cq_timer_id = install_timer_(cq->cw_ts*100, cq_timer_cw2, cq);
}

void cq_timer_cw2(void *data){
    struct cq *cq;
    
    dbg("cq_timer_cw2\n");
    cq = (struct cq *)data;
    cq_run_cw(cq);
}


void cwdaemon_send_defaults(struct cwdaemon *cwda){
    cwdaemon_speed(cwda, cwda->speed);
/*TODO    cwdaemon_tone(cwda, cfg->cwda_speaker?800:0);*/
}

void cwdaemon_abort(struct cwdaemon *cwda){
    char s[8];
    
    if (!cwda || cwda->sock<0) return;

    sprintf(s,"\0330");
    send(cwda->sock, s, strlen(s)+1, 0);
}

/* called from SEGV handler */
void cwdaemon_safe_abort(struct cwdaemon *cwda){
    if (!cwda || cwda->sock<0) return;
    send(cwda->sock, "\0330", 3, 0);
}


void cwdaemon_cw_string(struct cwdaemon *cwda, gchar *text){
    
    if (cwda->sock<0) return;
    
    /*dbg("cwdaemon_cw_string('%s')\n", text);*/
    send(cwda->sock, text, strlen(text), 0);
}

void cwdaemon_cw_char(struct cwdaemon *cwda, gchar c){
    char s[8];
    
    if (cwda->sock<0) return;
    cwdaemon_send_defaults(cwda);
    sprintf(s, "%c", c);
    send(cwda->sock, s, strlen(s), 0);
}

void cwdaemon_ptt(struct cwdaemon *cwda, int ptt){
    char s[16];
    
    if (cwda->sock<0) return;
    /*dbg("PTT(%d)\n", ptt);*/
    sprintf(s,"\033a%d", ptt);
    send(cwda->sock, s, strlen(s)+1, 0);
}

void cwdaemon_ssbway(struct cwdaemon *cwda, int ssbway){
    char s[16];
    
    if (cwda->sock<0) return;
    sprintf(s,"\033b%d", ssbway);
    send(cwda->sock, s, strlen(s)+1, 0);
}

void cwdaemon_speed(struct cwdaemon *cwda, int wpm){
    char s[16];
    
    if (cwda->sock<0) return;

    /*dbg("speed=%d\n", wpm);*/
    sprintf(s,"\0332%d", wpm);
    send(cwda->sock, s, strlen(s)+1, 0);
}

void cwdaemon_qrq(struct cwdaemon *cwda, int qrq){
    if (!cwda) return;

    cwda->speed+=qrq;
    if (cwda->speed>80) cwda->speed=80;
    cwdaemon_speed(cwda, cwda->speed);
}

void cwdaemon_qrs(struct cwdaemon *cwda, int qrq){
    if (!cwda) return;

    cwda->speed-=qrq;
    if (cwda->speed<10) cwda->speed=10;
    cwdaemon_speed(cwda, cwda->speed);
}

void cwdaemon_tone(struct cwdaemon *cwda, int tone){
    char s[16];
    
    if (cwda->sock<0) return;

    sprintf(s,"\0333%d", tone);
    send(cwda->sock, s, strlen(s)+1, 0);
}

void cwdaemon_weight(struct cwdaemon *cwda, int weight){
    char s[16];
    
    if (cwda->sock<0) return;

    sprintf(s,"\0337%d", weight);
    send(cwda->sock, s, strlen(s)+1, 0);
}

void cwdaemon_echo(struct cwdaemon *cwda){
    char s[16];
    
    if (cwda->sock<0) return;

    sprintf(s,"\033h%d", -1);
    send(cwda->sock, s, strlen(s)+1, 0);
}


/*************** CQ *********************/

        
struct cq *init_cq(void){
    struct cq *cq;

    cq = g_new0(struct cq, 1);
    g_ptr_array_add(cfg->cqs, cq);
    return cq;
}

struct cq *get_cq_by_number(GPtrArray *cqs, int nr){
    struct cq *cq;
    int i;

    for (i=0; i<cqs->len; i++){
        cq = (struct cq *)g_ptr_array_index(cqs, i);
        if (cq->nr==nr) return cq;
    }
    return NULL;   
}



void free_cq (struct cq *cq){
    if (cq->cw_str)   g_free(cq->cw_str);
    if (cq->ssb_file) g_free(cq->ssb_file);
    g_free(cq);        
}

/**************** CW *************************/
int cq_run_cw(struct cq *cq){
    gchar *raw;

    ssbd_abort(ssbd,1); /*aborts playing or recording */

    cq->type=MOD_CW_CW;
    redraw_later(term);
    if (!cq->cw_str) {
        cq_abort(ssbd->recording);
        return -1;
    }
    raw = convert_cq(cq);
    if (!raw) return -1;

    if (cq->cw_speed) 
        cwdaemon_speed(cwda, cq->cw_speed);
    else
        cwdaemon_speed(cwda, cwda->speed);
    
    cwdaemon_cw_string(cwda, raw);
    cwdaemon_echo(cwda);
    peer_tx(aband, 2);
    g_free(raw);

    ctest->last_cq = cq;
    ctest->last_cq_timer_id = 0;
    return 0;
}

void cq_timer_cw(void *data){
    struct cq *cq;
    
    cq = (struct cq *)data;
    cwdaemon_abort(cwda);
    cq_run_cw(cq);
}


/*************** SSB *************************/
int cq_run_ssb(struct cq *cq){
    
    cq->type=MOD_SSB_SSB;
    cwdaemon_ptt(cwda, 1);
    cwdaemon_ssbway(cwda, 1); /* soundcard */
    
    ssbd_play_file(ssbd, cq->ssb_file);
    ctest->last_cq = cq;
    ctest->last_cq_timer_id = 0;
    peer_tx(aband, 2);
    redraw_later(term);
    return 0;
}
            
void cq_timer_ssb1(void *data){
    struct cq *cq;
    
    /*dbg("cq_timer_ssb1\n");*/
    cq = (struct cq *)data;
    cq_ssb_wait(cq); 
}

void cq_ssb_wait(struct cq *cq){
    /*dbg("cq_ssb_wait\n");*/
    ssbd_abort(ssbd,0);
    cwdaemon_ptt(cwda, 0);
    cwdaemon_ssbway(cwda, 0); /* microphone */
    peer_tx(aband, 0);
    ctest->last_cq_timer_id = install_timer_(cq->ssb_ts*100, cq_timer_ssb2, cq);
}

void cq_timer_ssb2(void *data){
    struct cq *cq;
    
    /*dbg("cq_timer_ssb2\n");*/
    cq = (struct cq *)data;
    cq_run_ssb(cq);
}


/****************** common **********************/
int cq_run_by_number(int no){
    int ret;
    struct cq *cq;
    
    /*dbg("cq_run_by_number(%d)\n", no);*/
    
    if (!ctest) return -1;
    if (no<0 || no>=cfg->cqs->len) return -1;
       
    cq = (struct cq *)g_ptr_array_index(cfg->cqs, no);
    cq_abort(1);
    
    /*if (ctest->last_cq_timer_id0){
        kill_timer(ctest->last_cq_timer_id);
        ctest->last_cq_timer_id = 0;
    } */
    
    
    if (aband->mode == MOD_CW_CW){
        /*dbg(" speed=%d repeat=%d ts=%d '%s'\n", cq->cw_speed, cq->cw_repeat, cq->cw_ts, cq->cw_allowifundef, cq->cw_str);*/
        ret=cq_run_cw(cq);
    }else if (aband->mode == MOD_SSB_SSB){
        /*dbg(" repeat=%d ts=%d '%s'\n", cq->ssb_repeat, cq->ssb_ts, cq->ssb_file);*/
        ret=cq_run_ssb(cq);
    }else
        ret=-1;        

    return ret;
}


int cq_abort(int abort_rec){
    /*dbg(" cq_abort(%d)\n", abort_rec);*/
    
    if (ctest && ctest->last_cq) ctest->last_cq->type=MOD_NONE;
    if (ctest && ctest->last_cq_timer_id){
        kill_timer(ctest->last_cq_timer_id);
        ctest->last_cq_timer_id = 0;
    }
    
    cwdaemon_abort(cwda);
    redraw_later(term);
    
    if (!abort_rec && ssbd_recording(ssbd)) return 0;

    ssbd_abort(ssbd,abort_rec);
    return 0;
}

gchar *conv_nr(gchar *str){
    char *c;
    static char out[20];

    safe_strncpy0(out, str, 20);
    for (c=out; *c=='0'; c++) *c='t';
    return out;
}

gchar *conv_rst(gchar *str){
    char *c;
    static char out[20];

    safe_strncpy0(out, str, 20);
    for (c=out; *c!='\0';c++){
        if (*c=='9') *c='n';
    }
    return out;
}



/* convert $XX to string */

gchar *convert_esc(gchar *format, int *undef){ 
    GString *gs;
    char *c, *ret;
    int dummyint;
    
    if (!undef) undef=&dummyint;
    *undef=0;
    gs = g_string_new("");

    for (c=format; *c!='\0'; c++){
        if (*c=='~' && c==format){
            g_string_append(gs, getenv("HOME"));
            continue;
        }
        if (*c!='$') {
            g_string_append_c(gs, *c);
            continue;
        }
        c++;
        switch (tolower(*c)){
            case '\0':
                goto brk2;
                break;
            case '$':
                g_string_append_c(gs, '$');
                break;
            case 'c':
                if (TMPQ.callsign) g_string_append(gs, TMPQ.callsign);
                else *undef=1;
                break;    
            case 'd':
                g_string_append (gs, ctest->cdate);
                break;
            case 'n':
                if (TMPQ.qsonrr)   g_string_append(gs, conv_nr(TMPQ.qsonrr));
                else *undef=1;
                break;    
            case 'o':
                if (aband->operator) g_string_append(gs, aband->operator);
                else *undef=1;
                break;   
            case 'r':
                if (TMPQ.rstr)     g_string_append(gs, conv_rst(TMPQ.rstr));
                else *undef=1;
                break; 
            case 's': /* must go to ssbd */ 
                g_string_append(gs, "$s");
                break;
            case 't':
                g_string_append(gs, ctest->directory);
                break;
            case 'v':
                g_string_append(gs, "$v");
                break;
                if (TMPQ.callsign) {
                    gchar *c, *d;

                    c=g_strdup(TMPQ.callsign);
                    for (d=c; *d!='\0'; d++) if (*d=='/') *d='_';
                    g_string_append(gs, c);
                    g_free(c);
                }
                else *undef=1;
                break;    
            case 'w':
                if (TMPQ.locator)  g_string_append(gs, TMPQ.locator);
                else *undef=1;
                break;
            case 'x':
                if (TMPQ.exc)      g_string_append(gs, TMPQ.exc);
                else *undef=1;
                break;    
            case 'm':
                c++;
                switch(tolower(*c)){
                    case '\0':
                        goto brk2;
                        break;
                    case 'c':
                        if (ctest->pcall) g_string_append(gs, ctest->pcall);
                        else *undef=1;
                        break;    
                    case 'n':
                        if (TMPQ.qsonrs)  g_string_append(gs, conv_nr(TMPQ.qsonrs));
                        else *undef=1;
                        break;    
                    case 'r':
                        if (TMPQ.rsts)    g_string_append(gs, conv_rst(TMPQ.rsts));
                        else *undef=1;
                        break;    
                    case 'w':
                        if (ctest->pwwlo) g_string_append(gs, ctest->pwwlo);
                        else *undef=1;
                        break;
                    case 'x':
                        if (ctest->pexch) g_string_append(gs, ctest->pexch);
                        else *undef=1;
                        break;    
                }
                break;
        }        
            
brk2:;        
    }
    
    ret = gs->str;
    g_string_free(gs, FALSE);
    
    return ret;
}
        
gchar *convert_cq(struct cq *cq){
    gchar *ret;
    int undef;

    ret=convert_esc(cq->cw_str, &undef);
    
    if (!cq->cw_allowifundef && undef){
        g_free(ret);
        return NULL;
    }
    return(ret);
}
    

