/* procxfer.c -- Eat .Admin/xferstats and update the systems tables.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua_4_hdb.h"
#include "../pcdl.h"

#if HDB_UUCP

int
DEFUN_VOID (read_xferstats_log)
{
  struct xferentry xfe;
  int xfer_status;
  char FileName[LPNMAX];
  FILE * fp;
  BOOLEAN first_line = TRUE;
  
#ifdef DEBUG
  if (be_verbose)
    fputs ("\nProcessing xferstats:\n", stderr);
#endif

  xfe.System = xfe.User = xfe.PortName = 0;
  debug_filename (FileName);
  
  sprintf (FileName, "%s/%s", logs_prefix_path_opt, XFER_NAME);
  if ((fp = fopen (FileName, "r")) == (FILE *) NULL)
    {
      LOG ("cannot open %s", FileName);
      return (ERROR);
    }

  while ((xfer_status = GetXferEntry (fp, &xfe)) == OK)
    {
      Date_t date;
      Time_t time;
      system_rec_t *sr;
      day_rec_t *dr;
      port_rec_t *pa;

      debug_newline ();
      
      if (just_some_system_opt)
	{
	  if ((sr = search_system (xfe.System)) == (system_rec_t *) NULL)
	    continue;
	}
      else
	sr = insert_system (xfe.System);

      if (first_line && (xfe.TimeStamp < StatStartingTime || StatStartingTime == 0.0))
	{
	  StatStartingTime = xfe.TimeStamp;
	  first_line = FALSE;
	}
      
      julian_to_dt (xfe.TimeStamp, &date, &time);
      
      dr = insert_day (date);
      pa = insert_port (xfe.PortName);

      pa->Activity[time.Hour * 3 + (time.Min / 20)] += xfe.Bytes;

      if (!sr->Killed)
	{
	  if (pcd_names_count)
	    {
	      int phone_tb = get_phone_timeband (date.DayOfWeek, time.Hour, time.Min);
	      
	      if (sr->PhoneCost == 0)
		system_alloc_phone_costs (sr);
	      
	      sr->PhoneCost[phone_tb] += xfe.Time;
	    }
	  
	  if (date.Month == sr->History.LastMonthProcessed)
	    sr->History.MonthlyActivity[date.Month - 1] += xfe.Bytes;
	  else
	    {
	      sr->History.MonthlyActivity[date.Month - 1] = xfe.Bytes;
	      sr->History.LastMonthProcessed = date.Month;
	    }
	  if (xfe.Direction == SENT)
	    {
	      user_rec_t *ur = insert_user (xfe.User);

	      sr->Out.Time += xfe.Time;
	      sr->Out.Bytes += xfe.Bytes;
	      sr->Out.Files++;
	      dr->Out.Bytes += xfe.Bytes;
	      dr->Out.Time += xfe.Time;
	      dr->Out.Files++;
	      if (!ur->Killed)
		{
		  ur->Out.Files++;
		  ur->Out.Bytes += xfe.Bytes;
		  ur->Out.Time += xfe.Time;
		}
	    }
	  else
	    {
	      sr->In.Time += xfe.Time;
	      sr->In.Bytes += xfe.Bytes;
	      sr->In.Files++;
	      dr->In.Time += xfe.Time;
	      dr->In.Bytes += xfe.Bytes;
	      dr->In.Files++;
	    }
	}
    }
  if (StatEndingTime < xfe.TimeStamp)
    StatEndingTime = xfe.TimeStamp;
  
  fclose (fp);
  debug_end();

  xfree (xfe.System);
  xfree (xfe.User);
  xfree (xfe.PortName);
  
  return (xfer_status == EOF ? OK : ERROR);
}

#endif /* HDB_UUCP */
