/*
 * class EnvAST (derived from InfoAST, but not intended to
 * be a node of a syntax tree of a TTCN-3 document!):
 *
 * A data structure describing environments of identifiers and
 * types which belong to the same scope. EnvASTs are NOT nodes 
 * of the AST, they are some sort of parallel data structure
 * which may nevertheless be referenced from inside an AST.
 *
 * This data structure stores the symbol table in a tree
 * resembling the nested scope structure of an TTNC-3 document.
 * Since we use ANTLRs facilities to maintain this data structure, 
 * we can easily traverse such a symbol table tree by e.g. using 
 * ANTLRs tree parsing mechanisms.
 *
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef INC_EnvAST_hpp__
#define INC_EnvAST_hpp__

#include <map>
#ifndef INC_InfoAST_hpp__
#include "InfoAST.hpp"
#endif

#ifndef INC_ASTFactory_hpp__
#include "antlr/ASTFactory.hpp"
#endif

ANTLR_BEGIN_NAMESPACE(antlr)

typedef RefCount< ANTLR_USE_NAMESPACE(std)string > RefString;

class EnvAST;

typedef ASTRefCount< EnvAST >   RefEnvAST;

class EnvAST : public InfoAST
{
  private:
  
    RefEnvAST  parentEnv;
    
  public:
  
    EnvAST();
    EnvAST( RefToken t );
    
    void setParentEnv(RefEnvAST parent);
    RefEnvAST getParentEnv() const;
    
    void addASTList(int length, ASTFactory *factory, ...); // Add AST nodes to Env node (using a variable number of parameters): length specifies number of AST nodes which are passed, factory is used for copying the AST nodes into the Env tree.

    static void addASTList(RefAST ast, int length, ASTFactory *factory, ...); // Add AST nodes to an Env node (using a variable number of parameters): ast specifies the Env node, length specifies number of AST nodes which are passed, factory is used for copying the AST nodes into the Env tree.


    static RefAST factory(); // required for ANTLRs factory design pattern

};



ANTLR_END_NAMESPACE

#endif // INC_EnvAST_hpp__
