/*****************************************************************************
    TRAVIS - Trajectory Analyzer and Visualizer
    Copyright (C) 2009-2012 Martin Brehm

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/

#ifndef MICROHET_H
#define MICROHET_H

#include "xobject.h"
#include "xobarray.h"
#include "timestep.h"
#include "atomgroup.h"
#include "df.h"
#include "xintarray.h"
#include "2df.h"

#define MH_BIN_TYPE unsigned short

class CMicroHet;

class CMicroHetObservation : public CxObject
{
public:
	void BuildSlices(char *s);
	void BuildZeroPlot(const char *s, bool absolute);
	void BuildName();
	char *m_sName;
	bool m_bUniform;
	bool m_bEdgeUniform;
	bool m_bCDF;
	int m_iCDFRes;
	float m_fRangeFac;
	void BuildCDF();
	void Create();
	void Parse();
	CMicroHetObservation();
	~CMicroHetObservation();
	CxObArray m_oaAtomGroups;
	bool m_bMass;
	bool m_bDensity;
	float m_fMaxVal;
	int m_iHistoRes;
	CDF **m_pHistogram;
	C2DF *m_pCDF;
	CMicroHet *m_pParent;
	int m_iCDFOffset;
};

class CMicroHet : public CxObject
{
public:
	void ProcessAtom(int px, int py, int pz, int mass, int cl);
	void Process(CTimeStep *ts);
	void Bin(CMicroHetObservation *o, int zi);
	void Zero();
	void Create();
	void Parse();
	CMicroHet();
	~CMicroHet();

	CxObArray m_oaObservations;

	bool m_bSphere;
	int m_iRes;
	int m_iResSqr;
	int m_iResTri;
	double m_fBinVolume;
	CxIntArray m_iaCuboidLength;
	CxDoubleArray m_faCuboidVolume;
//	bool m_bIntBin;

//	float *m_pBin;
	MH_BIN_TYPE *m_pIBin;
};

#endif
