import os
import logging

from os import path
from shutil import rmtree
from tempfile import mkdtemp

from trac import config
from bzrlib import bzrdir, tests

from tracbzr import backend


class DummyComponent(object):

    def __init__(self):
        self.log = logging.getLogger('tracbzr.tests')
        self.log.setLevel(logging.ERROR)
        self.config = config.Configuration(None)


class AbstractTracTestCase(tests.TestCase):

    def setUp(self):
        super(AbstractTracTestCase, self).setUp()
        self.root = mkdtemp(prefix='trac+bzr-')
        self.old_cwd = os.getcwd()
        os.chdir(self.root)

    def trac_repo(self, location):
        param = { 'name': location, 'id': 'trac_bzr_selftest' }
        return backend.BzrRepository(self.root, param, DummyComponent())

    def tearDown(self):
        super(MultiBranchTracTestCase, self).tearDown()
        os.chdir(self.old_cwd)
        rmtree(self.root)


class MultiBranchTracTestCase(AbstractTracTestCase):

    def setUp(self):
        super(MultiBranchTracTestCase, self).setUp()
        dir = bzrdir.BzrDir.create(self.root)
        self.repo = dir.create_repository()
        self.treedir = path.join(self.root, 'tree')
        self.branch = bzrdir.BzrDir.create_branch_convenience(self.treedir,
            force_new_tree=True)
        self.tree = self.branch.bzrdir.open_workingtree()


class SingleBranchTracTestCase(AbstractTracTestCase):

    def setUp(self):
        super(SingleBranchTracTestCase, self).setUp()
        branch = bzrdir.BzrDir.create_branch_convenience(self.root, 
                        force_new_tree=True)
        self.tree = branch.bzrdir.open_workingtree()
        self.repo = branch.repository
        self.treedir = self.root
