/* sci.c -- System Configuration Interface
 *
 * Copyright (c) 1998/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
 *
 *   This code is covered by the GNU GPL and you are free to make any
 *   changes you wish to it under the terms of the license. However the
 *   code has the potential to render your computer and/or someone else's
 *   unuseable. Unless you truely understand what is going on, I urge you
 *   not to make any modifications and use it as it stands.
 *   
 * $Log: sci.c,v $
 * Revision 1.7  2004/02/28 16:21:05  schwitrs
 * removed unused code
 *
 * Revision 1.6  2002/11/24 19:46:25  schwitrs
 * added optional support for kernel hardware interface
 * required some rearrangement of sci use of SMMRegisters.
 *
 * Revision 1.5  2002/05/18 23:47:59  schwitrs
 * fixes for asm code: now compiles under gcc-3.0
 *
 * Revision 1.4  2002/01/30 18:31:37  schwitrs
 * cleanup
 * added extra element to stack, as done in hciFunction
 * added memory to asm protected area
 *
 * Revision 1.3  2002/01/19 23:00:56  schwitrs
 * work to try to get password stuff working
 *
 * Revision 1.2  2001/05/14 16:39:51  schwitrs
 * copied Jonathan's new code for SciSet. Motivated by passwd stuff.
 *
 * Revision 1.1  2000/02/03 02:49:03  schwitrs
 * Initial revision
 *
 * Revision 1.12  1999/11/17 16:00:42  jab
 * changed assembler to manually save registers, hopefully this should
 * make the programs more stable
 *
 * Revision 1.11  1999/07/25 14:39:49  jab
 * fixed bugs in SciOpenInterface and SciSetPassword
 * updated email address
 *
 * Revision 1.10  1999/03/11 20:22:14  jab
 * changed get and set routines to use SciRegisters
 *
 * Revision 1.9  1999/03/06 16:46:30  jab
 * moved the BiosVersion and MachineID functions to hci.c
 *
 * Revision 1.8  1998/09/07 18:23:36  jab
 * removed SciGetMachineID2 as no longer required
 * added a routine to extract the model string from the BIOS
 *
 * Revision 1.7  1998/09/04 18:14:31  jab
 * fixed the compile warning about rcsid
 *
 * Revision 1.6  1998/08/24 18:05:04  jab
 * implemented the SciGetBiosVersion function
 *
 * Revision 1.5  1998/08/23 12:16:45  jab
 * fixed the SciACPower function so it now works
 *
 * Revision 1.4  1998/08/19 08:45:10  jab
 * changed GetMachineId to return SCI_SUCCESS/SCI_FAILURE
 *
 * Revision 1.3  1998/08/18 16:54:54  jab
 * fixes to SciGetMachineId curtesy of Patrick Reyonlds <patrick@cs.virgina.edu>
 *
 * Revision 1.2  1998/08/06 08:27:14  jab
 * prepended all functions with Sci
 *
 * Revision 1.1  1998/05/23 08:08:53  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 */

static const char rcsid[]="$Id: sci.c,v 1.7 2004/02/28 16:21:05 schwitrs Exp $";

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/mman.h>

#include"sci.h"
#include "kernelInterface.h"


/*
 * Is this a supported Machine? (ie. is it a Toshiba)
 */
int 
SciSupportCheck(int *version)
{
 unsigned short dx;
 unsigned char ah;
 {
   SMMRegisters regs;

   regs.eax = 0xf0f0;
   regs.ebx = 0x0000;
   regs.ecx = 0x0000;
   regs.edx = 0x0000;

   if ( smmAccess(&regs) != 1 ) {
     *version = (int) regs.edx;
     return (int) (regs.eax & 0xff00)>>8;
   }
 }
 asm ("pushl %%eax\n\t" \
      "pushl %%ebx\n\t" \
      "pushl %%ecx\n\t" \
      "pushl %%edx\n\t" \
      "movw $0xf0f0,%%ax\n\t" \
      "movw $0x0000,%%bx\n\t" \
      "movw $0x0000,%%cx\n\t" \
      "inb $0xb2,%%al\n\t" \
      "popl %%ecx\n\t" \
      "popl %%ebx\n\t" \
      "popl %%eax\n" \
      :"=d" (dx), "=a" (ah) : : "memory" );

 *version = (int) dx;

 return (int) (ah & 0xff);
} /* SciSupportCheck */


/*
 * Open an interface to the Toshiba hardware.
 *
 *   Note: Set and Get will not work unless an interface has been opened.
 */
int SciOpenInterface(void)
{
 unsigned char ah;
 {
   SMMRegisters regs;
   regs.eax = 0xf1f1;
   regs.ebx = 0x0000;
   regs.ecx = 0x0000;

   if ( smmAccess(&regs) != 1 ) {
     return (int) (regs.eax & 0xff00)>>8;
   }
 }


 asm ("pushl %%eax\n\t" \
      "pushl %%ebx\n\t" \
      "pushl %%ecx\n\t" \
      "movw $0xf1f1,%%ax\n\t" \
      "movw $0x0000,%%bx\n\t" \
      "movw $0x0000,%%cx\n\t" \
      "inb $0xb2,%%al\n\t" \
      "movb %%ah,%0\n\t" \
      "popl %%ecx\n\t" \
      "popl %%ebx\n\t" \
      "popl %%eax\n" \
      :"=m" (ah) : : "memory" );

 return (int) ah;
} /* SciOpenInterface */


/*
 * Close any open interface to the hardware
 */
int SciCloseInterface(void)
{
 unsigned char ah;

 {
   SMMRegisters regs;
   regs.eax = 0xf2f2;
   regs.ebx = 0x0000;
   regs.ecx = 0x0000;

   if ( smmAccess(&regs) != 1 ) {
     return (int) (regs.eax & 0xff00)>>8;
   }
 }

 asm ("pushl %%eax\n\t" \
      "pushl %%ebx\n\t" \
      "pushl %%ecx\n\t" \
      "movw $0xf2f2,%%ax\n\t" \
      "movw $0x0000,%%bx\n\t" \
      "movw $0x0000,%%cx\n\t" \
      "inb $0xb2,%%al\n\t" \
      "popl %%ecx\n\t" \
      "popl %%ebx\n\t" \
      "popl %%eax\n" \
      :"=a" (ah) : : "memory" );
 
 return (int) (ah & 0xff);
}


/*
 * Get the setting of a given mode of the laptop
 */

int SciGet(SMMRegisters *reg)
{
 unsigned short ax,bx,cx,dx;

 {
   reg->eax = 0xf3f3;

   if ( smmAccess(reg) != 1 ) {
     reg->ebx  &= 0xffff;
     reg->ecx  &= 0xffff;
     reg->edx  &= 0xffff;
     return (int) (reg->eax & 0xff00)>>8;
   }
 }
 // note confusing mapping
 //ax = 0;
 bx = reg->ebx;
 cx = reg->ecx;
 dx = reg->edx;

 asm ("pushl %%esi\n\t" \
      "pushl %%edi\n\t" \
      "movw $0xf3f3,%%ax\n\t" \
      "inb $0xb2,%%al\n\t" \
      "popl %%edi\n\t" \
      "popl %%esi\n" \
      :"=a" (ax), "=b" (bx), "=c" (cx), "=d" (dx) \
      :"b" (bx), "c" (cx), "d" (dx) \
      : "memory" );

 reg->esi = (ax & 0xff);
 reg->ebx = bx;
 reg->ecx = cx;
 reg->edx = dx;

 return (int) (ax & 0xff00)>>8;
}



/*
 * Set the setting of a given mode of the laptop
 */
int SciSet(SMMRegisters *reg)
{
 int eax;

 reg->eax = 0xf4f4;

 {
   if ( smmAccess(reg) != 1 ) {
     return (int) (reg->eax & 0xff00)>>8;
   }
 }

 asm ("# load the values into the registers\n\t" \
      "pushl %%eax\n\t" \
      "pushl %%eax\n\t" \
      "movl 0(%%eax),%%edx\n\t" \
      "push %%edx\n\t" \
      "movl 4(%%eax),%%ebx\n\t" \
      "movl 8(%%eax),%%ecx\n\t" \
      "movl 12(%%eax),%%edx\n\t" \
      "movl 16(%%eax),%%esi\n\t" \
      "movl 20(%%eax),%%edi\n\t" \
      "popl %%eax\n\t" \
      "# call the System Management mode\n\t" \
      "inb $0xb2,%%al\n\t"
      "# fill out the memory with the values in the registers\n\t" \
      "xchgl %%eax,(%%esp)\n\t" \
      "popl %%eax\n\t" \
      "xchgl %%eax,(%%esp)\n\t"
      "movl %%ebx,4(%%eax)\n\t" \
      "movl %%ecx,8(%%eax)\n\t" \
      "movl %%edx,12(%%eax)\n\t" \
      "movl %%esi,16(%%eax)\n\t" \
      "movl %%edi,20(%%eax)\n\t" \
      "popl %%edx\n\t" \
      "movl %%edx,0(%%eax)\n\t" \
      "# setup the return value to the carry flag\n\t" \
      "lahf\n\t" \
      "shrl $8,%%eax\n\t" \
      "andl $1,%%eax\n" \
      : "=a" (eax)
      : "a" (reg)
      : "%ebx", "%ecx", "%edx", "%esi", "%edi", "memory");

 return eax;
} /* SciSet */


