// Copyright (C) 2003 Ronan Collobert (collober@idiap.ch)
//                
// This file is part of Torch 3.
//
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include "QCMachine.h"

namespace Torch {

QCMachine::QCMachine()
{
  Cup = NULL;
  Cdown = NULL;
  n_alpha = 0;
  alpha = NULL;
  grad = NULL;
  y = NULL;
  cache = NULL;

#ifdef USE_DOUBLE
  addROption("eps bounds", &bound_eps, 1E-12, "bounds accuracy");
#else
  addROption("eps bounds", &bound_eps, 1E-4, "bounds accuracy");
#endif
}

void QCMachine::reInit(int n_alpha_)
{
  n_alpha = n_alpha_;

  Cup = (real *)allocator->realloc(Cup, sizeof(real)*n_alpha);
  Cdown = (real *)allocator->realloc(Cdown, sizeof(real)*n_alpha);
  alpha = (real *)allocator->realloc(alpha, sizeof(real)*n_alpha);
  grad = (real *)allocator->realloc(grad, sizeof(real)*n_alpha);
  y = (real *)allocator->realloc(y, sizeof(real)*n_alpha);
}

QCMachine::~QCMachine()
{
}

}
