// Copyright (C) 2003 Samy Bengio (bengio@idiap.ch)
//                
// This file is part of Torch 3.
//
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include "WordSegMeasurer.h"

namespace Torch {

WordSegMeasurer::WordSegMeasurer(SimpleDecoderSpeechHMM *shmm_, DataSet *data_, XFile *file_) : Measurer(data_, file_)
{
  shmm = shmm_;
  addBOption("print targets", &print_targets, true, "print targets");
  addBOption("print timing", &print_timing, false, "print timing");
  addIOption("n per frame", &n_per_frame, 1, "n per frame");
}

void WordSegMeasurer::measureExample()
{
  file->printf("obtained: ");
  for (int j=0;j<shmm->word_sequence_size;j++) {
    file->printf("%s ",shmm->lexicon->vocabulary->words[shmm->word_sequence[j]]);
  }
  file->printf("\n");

  if (print_targets) {
    file->printf("desired: ");
    for (int j=0;j<shmm->target_word_sequence_size;j++)
      file->printf("%s ",shmm->lexicon->vocabulary->words[shmm->target_word_sequence[j]]);
    file->printf("\n");
  }
  if (print_timing) {
    for (int j=0;j<shmm->word_sequence_size-1;j++) {
      file->printf("%d %d %s\n",shmm->word_sequence_time[j]*n_per_frame,shmm->word_sequence_time[j+1]*n_per_frame,shmm->lexicon->vocabulary->words[shmm->word_sequence[j]]);
    }
    file->printf("%d %d %s\n",shmm->word_sequence_time[shmm->word_sequence_size-1]*n_per_frame,shmm->data->inputs->n_frames*n_per_frame,shmm->lexicon->vocabulary->words[shmm->word_sequence[shmm->word_sequence_size-1]]);
  }
  file->flush();
}

void WordSegMeasurer::measureIteration()
{
  file->flush();
}

void WordSegMeasurer::reset()
{
}

WordSegMeasurer::~WordSegMeasurer()
{
}


}

