// Copyright (C) 2002 Ronan Collobert (collober@iro.umontreal.ca)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "TimeMeasurer.h"

namespace Torch {

TimeMeasurer::TimeMeasurer(DataSet *data_, FILE *file_) : Measurer(data_, file_)
{
  measure = xalloc(sizeof(double));
  the_time = (double *)measure;

  reset();
}

TimeMeasurer::TimeMeasurer(DataSet *data_, const char *filename) : Measurer(data_, filename)
{
  measure = xalloc(sizeof(double));
  the_time = (double *)measure;

  reset();
}


void TimeMeasurer::init()
{
  Measurer::init();
  time_start = getRuntime();
}

void TimeMeasurer::reset()
{
  time_start = getRuntime();
  *the_time = 0;
}

void TimeMeasurer::measureIter()
{
  long current_time = getRuntime();
  double the_time_ = (double)(current_time - time_start)/((double)CLOCKS_PER_SEC);
  *the_time = the_time_;
  fprintf(file, "%g\n", the_time_);
  fflush(file);
}

void TimeMeasurer::measureEnd()
{
  long current_time = getRuntime();
  double the_time_ = (double)(current_time - time_start)/((double)CLOCKS_PER_SEC);
  *the_time = the_time_;
  fprintf(file, "%g\n", the_time_);
  fflush(file);
}

TimeMeasurer::~TimeMeasurer()
{
  free(measure);
}


}

