// Copyright (C) 2002 Samy Bengio (bengio@idiap.ch)
//                
//
// This file is part of Torch. Release II.
// [The Ultimate Machine Learning Library]
//
// Torch is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// Torch is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Torch; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "OutputMeasurer.h"

namespace Torch {

OutputMeasurer::OutputMeasurer(List *inputs_, DataSet *data_, FILE *file_, bool print_inputs_,bool print_targets_) : Measurer(data_, file_)
{
  inputs = inputs_;
  print_inputs = print_inputs_;
  print_targets = print_targets_;
  int n = inputs_->n;
  if (print_inputs)
    n += data->n_inputs;
  if (print_targets)
    n += data->n_targets;
  fprintf(file, "%d %d\n", data->n_examples,n);
}

OutputMeasurer::OutputMeasurer(List *inputs_, DataSet *data_, const char *filename, bool print_inputs_,bool print_targets_) : Measurer(data_, filename)
{
  inputs = inputs_;
  print_inputs = print_inputs_;
  print_targets = print_targets_;
  int n = inputs_->n;
  if (print_inputs)
    n += data->n_inputs;
  if (print_targets)
    n += data->n_targets;
  fprintf(file, "%d %d\n", data->n_examples,n);
}

void OutputMeasurer::measureEx()
{
  real *tab_inputs;
  real *des = (real *)data->targets;

  List *inputs_ = inputs;

  while(inputs_)
  {
    if (print_inputs) {
      real *in = (real *)data->inputs->ptr;
      for (int i = 0; i < data->n_inputs; i++)
        fprintf(file, "%f ", in[i]);
    }

    tab_inputs = (real *)(inputs_->ptr);
    for (int i = 0; i < (inputs_->n); i++)
      fprintf(file, "%f ", tab_inputs[i]);

    if (print_targets) {
      for (int i = 0; i < data->n_targets; i++)
        fprintf(file, "%f ", des[i]);
    }
    fprintf(file, "\n");
    inputs_ = inputs_->next;
  }
}

void OutputMeasurer::measureIter()
{
  fflush(file);
}

void OutputMeasurer::init()
{
  Measurer::init();
  reset();
}

void OutputMeasurer::reset()
{
}

OutputMeasurer::~OutputMeasurer()
{
}


}

