#
# This script is part of TkKasse. You may use, modify and distribute it under the terms
# of the GNU General Public License, Version 2.
# See details at http://www.fsf.org/licenses/gpl.txt
# (C) by Jan Kandziora <tkkasse@users.sf.net> 
#


## Create the main window.
toplevel .main -class Tkkasse
wm protocol .main WM_DELETE_WINDOW exit
wm geometry .main 1008x694+0+0
wm minsize .main 600 450
wm title .main "TkKasse"
wm transient . .main


## Create the desktop inside the main window, the users, articles and bills view.
frame .main.desktop
.main.desktop configure \
	-background [ option get .main.desktop backPageColor BackPageColor ]
UsersView .main.desktop.users \
	-command { .main.desktop.bills select "%n" }
ArticlesView .main.desktop.articles \
	-newcommand addArticleItemToBill \
	-newagaincommand addArticleItemToBillAgain
SelectFrame .main.desktop.bills



## Helper procedure for creating menu entries.
proc menuImage { WINDOW_ARG IMAGE_ARG LABEL_ARG } \
{
	set IMAGE [ image create compound -window $WINDOW_ARG ]
	$IMAGE add line
	$IMAGE add image -image $IMAGE_ARG
	$IMAGE add space -width 8
	$IMAGE add text -text $LABEL_ARG

	return $IMAGE
}


## Create the menu structure.
menu .main.menubar -type menubar -tearoff false


## Program submenu:
.main.menubar add cascade \
	-label [ msgcat::mc <menubar.program.label> ] \
	-underline [ msgcat::mc <menubar.program.underline> ] \
	-menu .main.menubar.program
menu .main.menubar.program -tearoff false
.main.menubar.program add cascade \
	-image [ menuImage .main.menubar.program images::Network [ msgcat::mc <menubar.program.connection.label> ] ] \
	-menu .main.menubar.program.connection
menu .main.menubar.program.connection -tearoff false
.main.menubar.program.connection add command \
	-image [ menuImage .main.menubar.program.connection images::Connect [ msgcat::mc <menubar.program.connection.connect.label> ] ] \
	-command queryServer
.main.menubar.program.connection add command \
	-image [ menuImage .main.menubar.program.connection images::Disconnect [ msgcat::mc <menubar.program.connection.disconnect.label> ] ] \
	-command disconnectServer
.main.menubar.program add separator
.main.menubar.program add command \
	-image [ menuImage .main.menubar.program images::Exit [ msgcat::mc <menubar.program.exit.label> ] ] \
	-accelerator [ msgcat::mc <menubar.program.exit.accelerator.label> ] \
	-command exit
bind all [ msgcat::mc <menubar.program.exit.accelerator.keystroke> ] exit

## Cash register submenu:
.main.menubar add cascade \
	-label [ msgcat::mc <menubar.cashRegister.label> ] \
	-underline [ msgcat::mc <menubar.cashRegister.underline> ] \
	-menu .main.menubar.cashregister
menu .main.menubar.cashregister -tearoff false
.main.menubar.cashregister add command \
	-image [ menuImage .main.menubar.cashregister images::Receipt [ msgcat::mc <menubar.cashRegister.printReceipt.label> ] ] \
	-command printCashRegisterReceipt
.main.menubar.cashregister add command \
	-image [ menuImage .main.menubar.cashregister images::Cleanup [ msgcat::mc <menubar.cashRegister.cleanup.label> ] ] \
	-command { .cleanup activate }

## User submenu:
.main.menubar add cascade \
	-label [ msgcat::mc <menubar.user.label> ] \
	-underline [ msgcat::mc <menubar.user.underline> ] \
	-menu .main.menubar.user
menu .main.menubar.user -tearoff false
.main.menubar.user add command \
	-image [ menuImage .main.menubar.user images::Change [ msgcat::mc <menubar.user.change.label> ] ] \
	-accelerator [ msgcat::mc <menubar.user.change.accelerator.label> ] \
	-command { focus [ .main.desktop.users component list ] }
bind all [ msgcat::mc <menubar.user.change.accelerator.keystroke> ] { focus [ .main.desktop.users component list ] }
.main.menubar.user add separator
.main.menubar.user add command \
	-image [ menuImage .main.menubar.user images::Login [ msgcat::mc <menubar.user.login.label> ] ] \
	-accelerator [ msgcat::mc <menubar.user.login.accelerator.label> ] \
	-command { .login activate }
bind all [ msgcat::mc <menubar.user.login.accelerator.keystroke> ] { .login activate }
.main.menubar.user add command \
	-image [ menuImage .main.menubar.user images::Close [ msgcat::mc <menubar.user.logout.label> ] ] \
	-accelerator [ msgcat::mc <menubar.user.logout.accelerator.label> ] \
	-command logoutUser
bind all [ msgcat::mc <menubar.user.logout.accelerator.keystroke> ] logoutUser
.main.menubar.user add separator
.main.menubar.user add command \
	-image [ menuImage .main.menubar.user images::Receipt [ msgcat::mc <menubar.user.printReceipt.label> ] ] \
	-accelerator [ msgcat::mc <menubar.user.printReceipt.accelerator.label> ] \
	-command printWaiterReceipt
bind all [ msgcat::mc <menubar.user.printReceipt.accelerator.keystroke> ] printWaiterReceipt

## Bills submenu:
.main.menubar add cascade \
	-label [ msgcat::mc <menubar.bill.label> ] \
	-underline [ msgcat::mc <menubar.bill.underline> ] \
	-menu .main.menubar.bill
menu .main.menubar.bill -tearoff false
.main.menubar.bill add command \
	-image [ menuImage .main.menubar.bill images::Change [ msgcat::mc <menubar.bill.change.label> ] ] \
	-accelerator [ msgcat::mc <menubar.bill.change.accelerator.label> ] \
	-command { catch { focus [ [ .main.desktop.bills childsite [ .main.desktop.bills get ] ].frame component bills ].tabset } }
bind all [ msgcat::mc <menubar.bill.change.accelerator.keystroke> ] \
	{ catch { focus [ [ .main.desktop.bills childsite [ .main.desktop.bills get ] ].frame component bills ].tabset } }
.main.menubar.bill add separator
.main.menubar.bill add command \
	-image [ menuImage .main.menubar.bill images::New [ msgcat::mc <menubar.bill.new.label> ] ] \
	-accelerator [ msgcat::mc <menubar.bill.new.accelerator.label> ] \
	-command { .newbill activate }
bind all [ msgcat::mc <menubar.bill.new.accelerator.keystroke> ] { .newbill activate }
.main.menubar.bill add cascade \
	-image [ menuImage .main.menubar.bill images::Print [ msgcat::mc <menubar.bill.printReceipt.label> ] ] \
	-menu .main.menubar.bill.printreceipt
menu .main.menubar.bill.printreceipt -tearoff false
.main.menubar.bill.printreceipt add command \
	-image [ menuImage .main.menubar.bill.printreceipt images::Print [ msgcat::mc <menubar.bill.printReceipt.plain.label> ] ] \
	-accelerator [ msgcat::mc <menubar.bill.printReceipt.plain.accelerator.label> ] \
	-command { printGuestReceipt plain }
bind all [ msgcat::mc <menubar.bill.printReceipt.plain.accelerator.keystroke> ] { printGuestReceipt plain } 
.main.menubar.bill.printreceipt add command \
	-image [ menuImage .main.menubar.bill.printreceipt images::Print [ msgcat::mc <menubar.bill.printReceipt.room.label> ] ] \
	-command { printGuestReceipt room }
.main.menubar.bill.printreceipt add command \
	-image [ menuImage .main.menubar.bill.printreceipt images::Print [ msgcat::mc <menubar.bill.printReceipt.spending.label> ] ] \
	-command { printGuestReceipt spending }
.main.menubar.bill add command \
	-image [ menuImage .main.menubar.bill images::Close [ msgcat::mc <menubar.bill.close.label> ] ] \
	-accelerator [ msgcat::mc <menubar.bill.close.accelerator.label> ] \
	-command { .closebill activate }
bind all [ msgcat::mc <menubar.bill.close.accelerator.keystroke> ] { .closebill activate }

## Article submenu:
.main.menubar add cascade \
	-label [ msgcat::mc <menubar.article.label> ] \
	-underline [ msgcat::mc <menubar.article.underline> ] \
	-menu .main.menubar.article
menu .main.menubar.article -tearoff false
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Change [ msgcat::mc <menubar.article.change.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.change.accelerator.label> ] \
	-command { focus [ .main.desktop.articles component list ] }
bind all [ msgcat::mc <menubar.article.change.accelerator.keystroke> ] { focus [ .main.desktop.articles component list ] }
.main.menubar.article add separator
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::AddArticle [ msgcat::mc <menubar.article.add.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.add.accelerator.label> ] \
	-command addArticleItemToBill
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::AddArticle [ msgcat::mc <menubar.article.addmultiple.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.addmultiple.accelerator.label> ] \
	-command addArticleItemToBillAgain
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::CancelArticle [ msgcat::mc <menubar.article.cancel.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.cancel.accelerator.label> ] \
	-command { throwBillViewEvent subtract }
.main.menubar.article add separator
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Extra [ msgcat::mc <menubar.article.extra.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.extra.accelerator.label> ] \
	-command { .extraArticle activate }
bind all [ msgcat::mc <menubar.article.extra.accelerator.keystroke> ] { .extraArticle activate }
.main.menubar.article add separator
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Mark [ msgcat::mc <menubar.article.changeOrder.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.changeOrder.accelerator.label> ] \
	-command { throwBillViewEvent changeOrder }
bind all [ msgcat::mc <menubar.article.changeOrder.accelerator.keystroke> ] { throwBillViewEvent changeOrder }
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Print [ msgcat::mc <menubar.article.changeService.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.changeService.accelerator.label> ] \
	-command { throwBillViewEvent changeService }
bind all [ msgcat::mc <menubar.article.changeService.accelerator.keystroke> ] { throwBillViewEvent changeService }
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Change [ msgcat::mc <menubar.article.changeTax.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.changeTax.accelerator.label> ] \
	-command { throwBillViewEvent changeTax }
bind all [ msgcat::mc <menubar.article.changeTax.accelerator.keystroke> ] { throwBillViewEvent changeTax }
.main.menubar.article add separator
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Run [ msgcat::mc <menubar.article.order.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.order.accelerator.label> ] \
	-command { throwBillViewEvent order }
bind all [ msgcat::mc <menubar.article.order.accelerator.keystroke> ] { throwBillViewEvent order }
.main.menubar.article add command \
	-image [ menuImage .main.menubar.article images::Run [ msgcat::mc <menubar.article.deliver.label> ] ] \
	-accelerator [ msgcat::mc <menubar.article.deliver.accelerator.label> ] \
	-command { throwBillViewEvent deliver }
bind all [ msgcat::mc <menubar.article.deliver.accelerator.keystroke> ] { throwBillViewEvent deliver }

## Help submenu:
.main.menubar add cascade \
	-label [ msgcat::mc <menubar.help.label> ] \
	-underline [ msgcat::mc <menubar.help.underline> ] \
	-menu .main.menubar.help
menu .main.menubar.help -tearoff false
.main.menubar.help add command \
	-image [ menuImage .main.menubar.help images::HelpContents [ msgcat::mc <menubar.help.contents.label> ] ] \
	-accelerator [ msgcat::mc <menubar.help.contents.accelerator.label> ] \
	-command { catch { help index.html } }
bind all [ msgcat::mc <menubar.help.contents.accelerator.keystroke> ] { catch { help index.html } }
.main.menubar.help add separator
.main.menubar.help add command \
	-image [ menuImage .main.menubar.help images::Support [ msgcat::mc <menubar.help.support.label> ] ] \
	-command support
.main.menubar.help add separator
.main.menubar.help add command \
	-image [ menuImage .main.menubar.help images::About [ msgcat::mc <menubar.help.about.label> ] ] \
	-command { wm deiconify . }


## Pack the desktop widgets.
grid .main.desktop.users -sticky nsew -padx 10 -pady 10 -row 0 -column 0
grid .main.desktop.articles -sticky nsew -padx 10 -pady 10 -row 1 -column 0
grid .main.desktop.bills -sticky nsew -padx 10 -pady 10 -row 0 -column 1 -rowspan 2

grid columnconfigure .main.desktop 0 -minsize 400 -weight 1
grid columnconfigure .main.desktop 1 -minsize 400 -weight 1
grid rowconfigure .main.desktop 1 -weight 1
		
pack .main.menubar -side top -fill x    
pack .main.desktop -side top -fill both -expand 1



## Error dialog class:
option add *OopsDialog.errorCodeLabel [ msgcat::mc <OopsDialog.errorCodeLabel> ] startupFile
option add *OopsDialog.errorInfoLabel [ msgcat::mc <OopsDialog.errorInfoLabel> ] startupFile
option add *OopsDialog.hideDetailsLabel [ msgcat::mc <OopsDialog.hideDetailsLabel> ] startupFile
option add *OopsDialog.okLabel [ msgcat::mc <OopsDialog.okLabel> ] startupFile
option add *OopsDialog.showDetailsLabel [ msgcat::mc <OopsDialog.showDetailsLabel> ] startupFile
option add *OopsDialog.supportLabel [ msgcat::mc <OopsDialog.supportLabel> ] startupFile

option add *OopsDialog.master .main widgetDefault
option add *OopsDialog.modality application widgetDefault 
option add *OopsDialog.supportCommand support widgetDefault 
option add *OopsDialog.textPadX 20 widgetDefault
option add *OopsDialog.textPadY 20 widgetDefault

itk::usual OopsDialog \
{
	keep -background -cursor -font -foreground -modality
	keep -wraplength -justify
}

itcl::class OopsDialog \
{
	inherit ::iwidgets::Messagedialog

	constructor {args} {}

	itk_option define -imagepos imagePos Position  w
	itk_option define -details details Boolean 0
	itk_option define -errorcodelabel errorCodeLabel Text ""
	itk_option define -errorinfolabel errorInfoLabel Text ""
	itk_option define -hidedetailslabel hideDetailsLabel Text ""
	itk_option define -oklabel okLabel Text ""
	itk_option define -showdetailslabel showDetailsLabel Text ""
	itk_option define -supportlabel supportLabel Text ""
	itk_option define -supportcommand supportCommand Text ""

	protected method _reconfigure {}

	public method activate {}
}

## Error dialog class constructor:
itcl::body OopsDialog::constructor {args} \
{
	itk_component add details \
	{
		frame $itk_interior.details
	}

	itk_component add details_panes \
	{
		iwidgets::panedwindow $itk_interior.details.panes
	}
	pack $itk_interior.details.panes -side top -fill both -expand yes

	$itk_component(details_panes) add errorcode    -minimum 30
	$itk_component(details_panes) add errorinfo    -minimum 30

	## Add error code pane.
	itk_component add errorcode \
	{
		iwidgets::scrolledtext [ $itk_component(details_panes) childsite errorcode ].errorcode \
			-labelpos w \
			-disabledforeground black \
			-wrap word -vscrollmode dynamic -hscrollmode none 
	}
	grid $itk_component(errorcode) -sticky nsew
	grid rowconfigure    [ $itk_component(details_panes) childsite errorcode ] 0 -weight 1
	grid columnconfigure [ $itk_component(details_panes) childsite errorcode ] 0 -weight 1
	
	## Add stack trace pane.
	itk_component add errorinfo \
	{
		iwidgets::scrolledtext [ $itk_component(details_panes) childsite errorinfo ].errorinfo \
			-labelpos w \
			-disabledforeground black \
			-wrap word -vscrollmode dynamic -hscrollmode none 
	}
	grid $itk_component(errorinfo) -sticky nsew
	grid rowconfigure    [ $itk_component(details_panes) childsite errorinfo ] 0 -weight 1
	grid columnconfigure [ $itk_component(details_panes) childsite errorinfo ] 0 -weight 1

	## Configure panes.
	$itk_component(details_panes) fraction 30 70

	## Add support button.
	itk_component add supportbutton \
	{
		iwidgets::pushbutton $itk_interior.details.button
	}
	pack $itk_interior.details.button -side right
	
	## Configure button bar. 
	buttonconfigure OK
	hide Cancel
	add ShowDetails -command [ namespace code "$this configure -details 1" ]
	add HideDetails -command [ namespace code "$this configure -details 0" ]
	hide HideDetails

	## Initialize dialog.
	eval itk_initialize $args

	## Align panes.
	iwidgets::Labeledwidget::alignlabels \
		$itk_component(errorcode) \
		$itk_component(errorinfo)
}

## Configure dialog by option.
itcl::configbody OopsDialog::details \
{
	_reconfigure
}
itcl::configbody OopsDialog::errorcodelabel \
{
	$itk_component(errorcode) configure -labeltext $itk_option(-errorcodelabel)
}
itcl::configbody OopsDialog::errorinfolabel \
{
	$itk_component(errorinfo) configure -labeltext $itk_option(-errorinfolabel)
}
itcl::configbody OopsDialog::imagepos \
{
	_reconfigure
}
itcl::configbody OopsDialog::hidedetailslabel \
{
	buttonconfigure HideDetails -text $itk_option(-hidedetailslabel)
}
itcl::configbody OopsDialog::oklabel \
{
	buttonconfigure OK -text $itk_option(-oklabel)
}
itcl::configbody OopsDialog::showdetailslabel \
{
	buttonconfigure ShowDetails -text $itk_option(-showdetailslabel)
}
itcl::configbody OopsDialog::supportcommand \
{
	$itk_component(supportbutton) configure -command "$itk_option(-supportcommand) \$errorCode \$errorInfo"
}
itcl::configbody OopsDialog::supportlabel \
{
	$itk_component(supportbutton) configure -text $itk_option(-supportlabel)
}

## Reconfigure the dialog.
itcl::body OopsDialog::_reconfigure {} \
{
	## Reconfigure layout.
	switch $itk_option(-imagepos) \
	{
		n \
		{
			grid $itk_component(image)   -row 0 -column 0
			grid $itk_component(message) -row 1 -column 0
			grid rowconfigure [ $this childsite ] 0 -weight 0
			grid rowconfigure [ $this childsite ] 1 -weight 0

			set DETAILROW 2
		}
		s \
		{
			grid $itk_component(message) -row 0 -column 0
			grid $itk_component(image)   -row 1 -column 0
			grid rowconfigure [ $this childsite ] 0 -weight 0
			grid rowconfigure [ $this childsite ] 1 -weight 0

			set DETAILROW 2
		}
		e \
		{
			grid $itk_component(message) -row 0 -column 0
			grid $itk_component(image)   -row 0 -column 1
			grid rowconfigure [ $this childsite ] 0 -weight 0

			set DETAILROW 1
		}
		w \
		{
			grid $itk_component(image)   -row 0 -column 0
			grid $itk_component(message) -row 0 -column 1
			grid rowconfigure [ $this childsite ] 0 -weight 0

			set DETAILROW 1
		}
		default \
		{
			error "bad imagepos option \"$itk_option(-imagepos)\":should be n, e, s, or w"
		}
	}
	
	grid columnconfigure [ $this childsite ] 1 -weight 1

	## Reconfigure button bar.
	if $itk_option(-details) \
	{
		hide ShowDetails
		show HideDetails

		grid $itk_component(details) -row $DETAILROW -column 0 -columnspan 2 -sticky nsew
		grid rowconfigure [ $this childsite ] $DETAILROW -weight 1 -minsize 400
	} \
	{
		show ShowDetails
		hide HideDetails
		grid remove $itk_component(details)
		grid rowconfigure [ $this childsite ] $DETAILROW -weight 0 -minsize 0
	}
}

## Activate the dialog.
itcl::body OopsDialog::activate {} \
{
	## Put the actual error code and stack trace into the widget.
	global errorCode errorInfo
	
	$itk_component(errorcode) configure -state normal
	$itk_component(errorcode) clear
	$itk_component(errorcode) insert end $errorCode
	$itk_component(errorcode) configure -state disabled
	$itk_component(errorinfo) configure -state normal
	$itk_component(errorinfo) clear
	$itk_component(errorinfo) insert end $errorInfo
	$itk_component(errorinfo) configure -state disabled

	## Call Iwidgets' activate function.
	chain
}



## Extras dialog class.
option add *ExtraArticleDialog.cancelLabel [ msgcat::mc <ExtraArticleDialog.cancelLabel> ] startupFile
option add *ExtraArticleDialog.nameLabel [ msgcat::mc <ExtraArticleDialog.nameLabel> ] startupFile
option add *ExtraArticleDialog.okLabel [ msgcat::mc <ExtraArticleDialog.okLabel> ] startupFile
option add *ExtraArticleDialog.priceLabel [ msgcat::mc <ExtraArticleDialog.priceLabel> ] startupFile
option add *ExtraArticleDialog.title [ msgcat::mc <ExtraArticleDialog.title> ] startupFile
option add *ExtraArticleDialog.master .main widgetDefault
option add *ExtraArticleDialog.modality application widgetDefault 

itk::usual ExtraArticleDialog \
{
	keep -background -cursor -foreground -modality
}

itcl::class ExtraArticleDialog \
{
	inherit ::iwidgets::Dialog

	constructor {args} {}
	
	itk_option define -cancellabel cancelLabel Text ""
	itk_option define -namelabel nameLabel Text ""
	itk_option define -oklabel okLabel Text ""
	itk_option define -pricelabel priceLabel Text ""

	public method activate
	public method get
}

## Extras dialog class constructor.
itcl::body ExtraArticleDialog::constructor {args} \
{
	## Compose the widget.
	itk_component add name \
	{
		iwidgets::entryfield $itk_interior.name \
			-labelpos nw \
			-width 30
	}

	itk_component add price \
	{
		iwidgets::entryfield $itk_interior.price \
			-labelpos nw \
			-width 8 \
			-justify right 
	}

	## Pack it.
	pack $itk_interior.name  -side left  -fill both -expand yes
	pack $itk_interior.price -side right -fill x

	## Hide all unneccesary buttons.
	hide Apply
	hide Help

	## Now initialize the widget.
	eval itk_initialize $args

	## More reasonable key bindings.
	bind $itk_component(hull) <KeyPress-Return> {}
	bind $itk_component(hull) <KeyPress-Escape> [ itcl::code $this deactivate ]
	bind $itk_component(name).lwchildsite.entry <KeyPress-Return> [ itcl::code focus $itk_component(price).lwchildsite.entry ]
	bind $itk_component(price).lwchildsite.entry <KeyPress-Return> [ itcl::code $this invoke ]
	bind [ $itk_component(hull).shellchildsite.bbox component OK ] <KeyPress-space> [ itcl::code $this invoke ] 
}

## Configure dialog by option.
itcl::configbody ExtraArticleDialog::cancellabel \
{
	buttonconfigure Cancel -text $itk_option(-cancellabel)
}
itcl::configbody ExtraArticleDialog::namelabel \
{
	$itk_component(name) configure -labeltext $itk_option(-namelabel)
}
itcl::configbody ExtraArticleDialog::oklabel \
{
	buttonconfigure OK -text $itk_option(-oklabel)
}
itcl::configbody ExtraArticleDialog::pricelabel \
{
	$itk_component(price) configure -labeltext $itk_option(-pricelabel)
}

## Activate the dialog.
itcl::body ExtraArticleDialog::activate {} \
{
	## Focus the name entry field.
	focus $itk_component(name).lwchildsite.entry

	## Call Iwidgets' activate function.
	chain
}

## Get the name and price of the article extra.
itcl::body ExtraArticleDialog::get {} \
{
	return [ list [ $itk_component(name) get ] [ $itk_component(price) get ] ]
}



## Close bill dialog class:
option add *CloseBillDialog.cancelLabel [ msgcat::mc <CloseBillDialog.cancelLabel> ] startupFile
option add *CloseBillDialog.detailsLabel [ msgcat::mc <CloseBillDialog.detailsLabel> ] startupFile
option add *CloseBillDialog.payedbyLabel [ msgcat::mc <CloseBillDialog.payedbyLabel> ] startupFile
option add *CloseBillDialog.payedbyRoomLabel [ msgcat::mc <CloseBillDialog.payedbyRoomLabel> ] startupFile
option add *CloseBillDialog.payedbyCashLabel [ msgcat::mc <CloseBillDialog.payedbyCashLabel> ] startupFile
option add *CloseBillDialog.payedbyECCardLabel [ msgcat::mc <CloseBillDialog.payedbyECCardLabel> ] startupFile
option add *CloseBillDialog.payedbyCreditCardLabel [ msgcat::mc <CloseBillDialog.payedbyCreditCardLabel> ] startupFile
option add *CloseBillDialog.okLabel [ msgcat::mc <CloseBillDialog.okLabel> ] startupFile
option add *CloseBillDialog.title [ msgcat::mc <CloseBillDialog.title> ] startupFile

option add *CloseBillDialog.master .main widgetDefault
option add *CloseBillDialog.modality application widgetDefault 

itcl::class CloseBillDialog \
{
	inherit ::iwidgets::Dialog

	constructor {args} {}
	
	itk_option define -cancellabel cancelLabel Text ""
	itk_option define -detailslabel detailsLabel Text ""
	itk_option define -payedbylabel payedbyLabel Text ""
	itk_option define -payedbyroomlabel payedbyRoomLabel Text ""
	itk_option define -payedbycashlabel payedbyCashLabel Text ""
	itk_option define -payedbyeccardlabel payedbyECCardLabel Text ""
	itk_option define -payedbycreditcardlabel payedbyCreditCardLabel Text ""
	itk_option define -oklabel okLabel Text ""

	public method activate
	public method getpayedby
	public method getdetail
}

## Close bill dialog class constructor:
itcl::body CloseBillDialog::constructor {args} \
{
	## Compose the widget.
	itk_component add payedby \
	{
		iwidgets::radiobox $itk_interior.payedby \
			-labelpos nw \
			-labelmargin 5
	}
	$itk_component(payedby) add room -takefocus 1 -highlightthickness 3
	$itk_component(payedby) add cash -takefocus 1 -highlightthickness 3
	$itk_component(payedby) add eccard -takefocus 1 -highlightthickness 3
	$itk_component(payedby) add creditcard -takefocus 1 -highlightthickness 3

	itk_component add detail \
	{
		iwidgets::entryfield $itk_interior.detail \
			-labelpos nw
	}

	## Pack it.
	pack $itk_interior.payedby
	pack $itk_interior.detail -fill x -expand yes

	## Hide all unneccesary buttons.
	hide Apply
	hide Help

	## Select payment by room bill as default.
	$itk_component(payedby) select room

	## Now initialize the widget.
	eval itk_initialize $args

	## More reasonable key bindings.
	bind $itk_component(hull) <KeyPress-Return> {}
	bind $itk_component(hull) <KeyPress-Escape> [ itcl::code $this deactivate ]
	bind [ $itk_component(payedby) component room ] <KeyPress-Return> [ itcl::code focus [ $itk_component(payedby) component cash ] ]
	bind [ $itk_component(payedby) component cash ] <KeyPress-Return> [ itcl::code focus [ $itk_component(payedby) component eccard ] ]
	bind [ $itk_component(payedby) component eccard ] <KeyPress-Return> [ itcl::code focus [ $itk_component(payedby) component creditcard ] ]
	bind [ $itk_component(payedby) component creditcard ] <KeyPress-Return> [ itcl::code focus $itk_component(detail).lwchildsite.entry ]
	bind $itk_component(detail).lwchildsite.entry <KeyPress-Return> [ itcl::code $this invoke ]
	bind [ $itk_component(hull).shellchildsite.bbox component OK ] <KeyPress-space> [ itcl::code $this invoke ] 
}

## Configure dialog by option.
itcl::configbody CloseBillDialog::cancellabel \
{
	buttonconfigure Cancel -text $itk_option(-cancellabel)
}
itcl::configbody CloseBillDialog::detailslabel \
{
	$itk_component(detail) configure -labeltext $itk_option(-detailslabel)
}
itcl::configbody CloseBillDialog::payedbylabel \
{
	$itk_component(payedby) configure -labeltext $itk_option(-payedbylabel)
}
itcl::configbody CloseBillDialog::payedbyroomlabel \
{
	$itk_component(payedby) buttonconfigure room -text $itk_option(-payedbyroomlabel)
}
itcl::configbody CloseBillDialog::payedbycashlabel \
{
	$itk_component(payedby) buttonconfigure cash -text $itk_option(-payedbycashlabel)
}
itcl::configbody CloseBillDialog::payedbyeccardlabel \
{
	$itk_component(payedby) buttonconfigure eccard -text $itk_option(-payedbyeccardlabel)
}
itcl::configbody CloseBillDialog::payedbycreditcardlabel \
{
	$itk_component(payedby) buttonconfigure creditcard -text $itk_option(-payedbycreditcardlabel)
}
itcl::configbody CloseBillDialog::oklabel \
{
	buttonconfigure OK -text $itk_option(-oklabel)
}

## Activate the dialog.
itcl::body CloseBillDialog::activate {} \
{
	## Focus the entry field.
	focus  [ $itk_component(payedby) component room ]

	## Call Iwidgets' activate function.
	chain
}

## Get the payment method.
itcl::body CloseBillDialog::getpayedby {} \
{
	return [ $itk_component(payedby) get ]
}

## Get the "detail" field for the bill to close.
itcl::body CloseBillDialog::getdetail {} \
{
	return [ $itk_component(detail) get ]
}


## Login dialog class
option add *LoginDialog.labelText Selection widgetDefault
option add *LoginDialog.labelPos nw widgetDefault
option add *LoginDialog.title "Login Dialog" widgetDefault
option add *LoginDialog.master "." widgetDefault

itcl::class LoginDialog \
{
	inherit ::iwidgets::Promptdialog

	constructor {args} {}

	public method activate
}

## Login dialog class constructor.
itcl::body LoginDialog::constructor {args} \
{
	## Bind additional keys.
	bind $itk_component(hull) <KeyPress-Escape> "$itk_component(hull) deactivate"
	
	## Now initialize the widget.
	eval itk_initialize $args

	## More reasonable key bindings.
	bind $itk_component(hull) <KeyPress-Return> {}
	bind $itk_component(hull) <KeyPress-Escape> [ itcl::code $this deactivate ]
	bind $itk_component(prompt).lwchildsite.entry <KeyPress-Return> [ itcl::code $this invoke ]
	bind [ $itk_component(hull).shellchildsite.bbox component OK ] <KeyPress-space> [ itcl::code $this invoke ] 
}

## Activate the dialog.
itcl::body LoginDialog::activate {} \
{
	## Clear the password field.
	$this clear
	
	## Focus the entry field.
	focus $itk_component(prompt).lwchildsite.entry

	## Call Iwidgets' activate function.
	chain
}


## NewBill dialog class
option add *NewBillDialog.labelText Selection widgetDefault
option add *NewBillDialog.labelPos nw widgetDefault
option add *NewBillDialog.title "NewBill Dialog" widgetDefault
option add *NewBillDialog.master "." widgetDefault

itcl::class NewBillDialog \
{
	inherit ::iwidgets::Promptdialog

	constructor {args} {}

	public method activate
}

## Login dialog class constructor.
itcl::body NewBillDialog::constructor {args} \
{
	## Bind additional keys.
	bind $itk_component(hull) <KeyPress-Escape> "$itk_component(hull) deactivate"
	
	## Now initialize the widget.
	eval itk_initialize $args

	## More reasonable key bindings.
	bind $itk_component(hull) <KeyPress-Return> {}
	bind $itk_component(hull) <KeyPress-Escape> [ itcl::code $this deactivate ]
	bind $itk_component(prompt).lwchildsite.entry <KeyPress-Return> [ itcl::code $this invoke ]
	bind [ $itk_component(hull).shellchildsite.bbox component OK ] <KeyPress-space> [ itcl::code $this invoke ] 
}

## Activate the dialog.
itcl::body NewBillDialog::activate {} \
{
	## Clear the table number field.
	$this clear
	
	## Focus the entry field.
	focus $itk_component(prompt).lwchildsite.entry

	## Call Iwidgets' activate function.
	chain
}


## Actual dialogues.


## Create an error dialog for fatal errors.
option add *oops.text [ msgcat::mc <oops.text> ] startupFile 
option add *oops.title [ msgcat::mc <oops.title> ] startupFile 
OopsDialog .oops \
	-image images::Oops 
wm transient .oops .main
.oops center
center_toplevel .oops



## Create a dialog for normal errors.
option add *error.helpLabel [ msgcat::mc <error.helpLabel> ] startupFile 
option add *error.okLabel [ msgcat::mc <error.okLabel> ] startupFile 
option add *error.title [ msgcat::mc <error.title> ] startupFile 

option add *error.master .main widgetDefault
option add *error.helpCommand { catch { help index.html#error } } widgetDefault

iwidgets::messagedialog .error \
	-image images::Error \
	-modality application
.error buttonconfigure OK \
	-text [ option get .error okLabel Text ]
.error buttonconfigure Help \
	-text [ option get .error helpLabel Text ] \
	-command [ option get .error helpCommand Text ]
.error hide Cancel
.error show Help
wm transient .error .main
wm resizable .error 0 0
.error center
center_toplevel .error



## Create a dialog for article extras.
option add *extraArticle.okCommand { addExtraToBillItem; .extraArticle deactivate } widgetDefault

ExtraArticleDialog .extraArticle
.extraArticle buttonconfigure OK \
	-command [ option get .extraArticle okCommand Text ]
wm transient .extraArticle .main
.extraArticle center
center_toplevel .extraArticle


## Create a dialog for exit.
option add *exit.noLabel [ msgcat::mc <exit.noLabel> ] startupFile 
option add *exit.yesLabel [ msgcat::mc <exit.yesLabel> ] startupFile 
option add *exit.title [ msgcat::mc <exit.title> ] startupFile 
option add *exit.text [ msgcat::mc <exit.text> ] startupFile 

option add *exit.exitCommand realExit widgetDefault

iwidgets::messagedialog .exit \
	-image images::Question \
	-modality application
.exit configure \
	-text [ option get .exit text Text ]
.exit buttonconfigure Cancel \
	-text [ option get .exit noLabel Text ] 
.exit buttonconfigure OK \
	-text [ option get .exit yesLabel Text ] \
	-command [ option get .exit exitCommand Text ]
.exit.shellchildsite.bbox default Cancel
wm transient .exit .main
wm resizable .exit 0 0
.exit center
center_toplevel .exit



## Create a dialog for waiter login.
option add *login.cancelLabel [ msgcat::mc <login.cancelLabel> ] startupFile 
option add *login.labelText [ msgcat::mc <login.labelText> ] startupFile 
option add *login.okLabel [ msgcat::mc <login.okLabel> ] startupFile 
option add *login.title [ msgcat::mc <login.title> ] startupFile 

option add *login.loginCommand { loginUser; .login deactivate } widgetDefault

LoginDialog .login \
	-modality application \
	-show "*"
.login configure \
	-labeltext [ option get .login labelText Text ]
.login buttonconfigure Cancel \
	-text [ option get .login cancelLabel Text ] 
.login buttonconfigure OK \
	-text [ option get .login okLabel Text ] \
	-command [ option get .login loginCommand Text ]
.login hide Apply
wm transient .login .main
wm resizable .login 1 0 
.login center
center_toplevel .login



## Create a dialog for a new bill.
option add *newbill.cancelLabel [ msgcat::mc <newbill.cancelLabel> ] startupFile 
option add *newbill.labelText [ msgcat::mc <newbill.labelText> ] startupFile 
option add *newbill.okLabel [ msgcat::mc <newbill.okLabel> ] startupFile 
option add *newbill.title [ msgcat::mc <newbill.title> ] startupFile 

option add *newbill.newCommand { createBill; .newbill deactivate } widgetDefault

NewBillDialog .newbill \
	-modality application
.newbill configure \
	-labeltext [ option get .newbill labelText Text ]
.newbill buttonconfigure Cancel \
	-text [ option get .newbill cancelLabel Text ] 
.newbill buttonconfigure OK \
	-text [ option get .newbill okLabel Text ] \
	-command [ option get .newbill newCommand Text ]
.newbill hide Apply
wm transient .newbill .main
wm resizable .newbill 1 0
.newbill center
center_toplevel .newbill



## Create a dialog for closing a bill.
option add *closebill.closeCommand { closeBill; .closebill deactivate } widgetDefault

CloseBillDialog .closebill
.closebill buttonconfigure OK \
	-command [ option get .closebill closeCommand Text ]
wm transient .closebill .main
wm resizable .closebill 1 0
.closebill center
center_toplevel .closebill



## Create a dialog for cleaning the cash register.
option add *cleanup.background OrangeRed startupFile 
option add *cleanup.cancelLabel [ msgcat::mc <cleanup.cancelLabel> ] startupFile 
option add *cleanup.foreground Yellow 61 
option add *cleanup.okLabel [ msgcat::mc <cleanup.okLabel> ] startupFile 
option add *cleanup.text [ msgcat::mc <cleanup.text> ] startupFile 
option add *cleanup.title [ msgcat::mc <cleanup.title> ] startupFile 

option add *cleanup.cleanupCommand { cleanupCashRegister; .cleanup deactivate } widgetDefault

iwidgets::messagedialog .cleanup \
	-image images::Question \
	-modality application
.cleanup buttonconfigure Cancel \
	-text [ option get .cleanup cancelLabel Text ] 
.cleanup buttonconfigure OK \
	-text [ option get .cleanup okLabel Text ] \
	-command [ option get .cleanup cleanupCommand Text ]
.cleanup.shellchildsite.bbox default Cancel
wm transient .cleanup .main
wm resizable .cleanup 0 0
.cleanup center
center_toplevel .cleanup

