#
# This script is part of TkKasse. You may use, modify and distribute it under the terms
# of the GNU General Public License, Version 2.
# See details at http://www.fsf.org/licenses/gpl.txt
# (C) by Jan Kandziora <tkkasse@users.sf.net> 
#


## This is merely for color palette setting, but has other influences too.
## It's a good idea to set it.
set tk_strictMotif 1

## Set the color palette.
option add *Foreground          #000000 21 
option add *Background          #00c0c0 21 
option add *textForeground      #000000 21
option add *textBackground      #00c0c0 21
option add *selectForeground    #00ffff 21
option add *selectBackground    #008080 21
option add *activeforeground    #00ffff 21
option add *activebackground    #00e0e0 21
option add *HighlightColor      #000000 81 
option add *highlightbackground #00e0e0 21
option add *handleBg            #00c0c0 21
option add *handleActiveBg      #00ffff 21
option add *separatorBg         #00c0c0 21
option add *separatorActiveBg   #00ffff 21
option add *backPageColor       #006060 21
option add *inactiveBackground  #008080 21

## Set thicker keyboard focus border, so it is easy to see.
option add *Button.HighlightThickness      4 21
option add *Checkbutton.HighlightThickness 4 21
option add *Pushbutton.HighlightThickness  4 21
option add *Radiobutton.HighlightThickness 4 21
option add *Entry.HighlightThickness       4 21
option add *Entryfield.HighlightThickness  4 21
option add *TixHList.HighlightThickness    4 21 
option add *Listbox.HighlightThickness     4 21
option add *Scrollbar.HighlightThickness   4 21

## Set thinner scrollbar than Tix default.
option add *Scrollbar.Width 12 99
option add *sbWidth         12 21


## Old stuff.
option add *main.desktop.articles*foreground          #ff8000 61
option add *main.desktop.articles*background          #802000 61
option add *main.desktop.articles*selectBackground    #c04000 61
option add *main.desktop.articles*selectForeground    #ffc000 61
option add *main.desktop.articles*highlightBackground #802000 61
option add *main.desktop.articles*troughColor         #802000 61
option add *main.desktop.articles*font                "-adobe-helvetica-bold-r-normal--14" 21

option add *main.desktop.users*foreground          #400000 61
option add *main.desktop.users*background          #c0d080 61
option add *main.desktop.users*selectForeground    #d0c080 61
option add *main.desktop.users*selectBackground    #a08000 61
option add *main.desktop.users*highlightBackground #c0d080 61
option add *main.desktop.users*troughColor         #c0d080 61
option add *main.desktop.users*font                "-adobe-helvetica-bold-r-normal--14" 21

option add *main.desktop.bills*foreground          #400000 61
option add *main.desktop.bills*background          #006060 21
option add *main.desktop.bills*selectForeground    #000000 61
option add *main.desktop.bills*selectBackground    #c0d080 21
option add *main.desktop.bills*highlightBackground #006060 61
option add *main.desktop.bills*troughColor         #c0d080 61
option add *main.desktop.bills*BillView.background #c0d080 21
option add *main.desktop.bills*labelBackground     #c0d080 21
option add *main.desktop.bills*itemsForeground     #000000 21
option add *main.desktop.bills*frame.bills.tabset*list*foreground #000000 99 
option add *main.desktop.bills*itemsBackground     #e0e0b0 21
option add *main.desktop.bills*frame.bills.tabset*list*background #e0e0b0 21
option add *main.desktop.bills*itemsHighlightBackground #c0d080 21
option add *main.desktop.bills*frame.bills.tabset*list*highlightBackground #c0d080 21
option add *main.desktop.bills*itemsSelectBackground    #a08000 21
option add *main.desktop.bills*frame.bills.tabset*list*selectBackground #a08000 21
option add *main.desktop.bills*infoForeground      #000000 21
option add *main.desktop.bills*infoBackground      #c0d080 21
option add *main.desktop.bills*labelFont           "-b&h-lucida-bold-r-normal-sans-20" 21
option add *main.desktop.bills*infoFont            "-b&h-lucida-bold-r-normal-sans-20" 21
option add *main.desktop.bills*itemsFont           "-b&h-lucidatypewriter-bold-r-normal-sans-14" 21
option add *main.desktop.bills*frame.bills.tabset*list*font "-b&h-lucidatypewriter-bold-r-normal-sans-14" 99 



## Font selection.
option add *Font       "-b&h-lucida-medium-r-normal-sans-18" 21 
option add *Label.font "-adobe-helvetica-bold-r-normal-sans-18" 21
option add *Menu.font  "-b&h-lucida-normal-r-normal-sans-18" 21
option add *LabelFont  "-b&h-lucida-bold-r-normal-sans-18" 21
option add *textFont   "-b&h-lucidatypewriter-bold-r-normal-sans-24" 21



## Define some images used later.
image create photo images::About -data "\
	R0lGODlhIAAgAMYAALC3sM/Pz3B3cKC38GB/sHCPwH+PwJCn4K+vr7+/v+Dn
	4O/v79DX0E9fkEBXj19voG9vb5CXkGBnYCAnL3+Pzz9XjwAXTw8XL1BXUEBH
	Tx8nLzA3P29/sHCHvw8nX4CXvy9Hfz9PgBAvYI+Pj2Bnbx8nPxAXIJ+foAAf
	UF93rwAPQC83UB83b4CX0MDP31Bnny8/cA8fUH9/f293jxAnXwAAAHAPD0AA
	ADBHbyA3X89nYF9vkF9fX6CnsAAHH3+Hn19nfwAPP293n9CHgAAPMH8fHzBH
	f09fj4+f0CA3by8/YDBHcP//////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4SFhgABAQKGjI0DBAUGBQcICQoLDACNm4INDg8P
	BZ4QEQEKEhOcjRSiFRYXGAEJEhkSGhsGHKqEDZAdBB4XEAkMsxgTGh8Eu50E
	ICEcHSISAAIjmSQlniHMDRwcBSG9FxcRABIYECYVzgTLnA0PrAQPvQ3BFycX
	KB4gFfUPdG3yliIFKHoNGpBTsUIECxEgWKBw945RC3oFRCVMGFHExgYsGLgg
	8OJBRV4FIBVw8NFBCBAoUJQUIYIBAoOgDDUAkbCCA5YJf4aoAANEDA8JEcgA
	KJCQzwY+HcCAEbSC1YggeL6YgcCTSUP0QDh81sCCBQcVhv4M9Q9oyQ7+hT41
	QHCCRoysFWq4fPYTktwGJTk0IJTiRSUbNxgEwJHjatYQLAmI8xSPwOBB4kAk
	0HHjhAIGDHasePl4Mgignx6AGFRhbgLEDBTwkP2ZAQ4aj3c2gAx0dSeaPRjc
	AKBAgIIIxxV83hEDhocHLH9yJMTCrAgHoCXQhlD8VAKap11K9z2IhQofMX8A
	YKAdufsEQFiwcHBa3EtDFlQE2Y8ihhCbAkgwxHB8GQCDeDsx4oEKRBCxnwUs
	NKDYEEUgMIM/LYTDG3mFwJBffg0SAaEDPfQgVQMUhPCSEapxIqJZ+jUYw3VH
	FGUAEiDgAMN9qqCggllAmoUCC+yoBkMSPO4+osKPQVoQhAUpGQGDEktwyEyT
	QIpwZBL0MVMIChbEFCQLSeCAg5VeDgJmDGYlMRWaaQ4SZAhVxqmKWV2mGQgA
	Ow==
	===="
image create photo images::AddArticle -data "\
	R0lGODlhIAAgAOcAAAAAADnMOwG+Az/AOzzFOwK8AwICBEavO0S2OwyoAwiv
	AwW2AwK9A9iNS9/BndadfEylOxWTAxKaAw+hAwuoA/5+BP66hPeYT/7i1E6h
	OxiNAxWUAxKbAw6iAwupAwiwAwS3A/6CBf7erPNvB8xuLLWDaVOWOx9/AxuG
	AxGcAw6jAwuqAwexAwS4A/6GEeJ6BI5CBFWROyJ5Ax6AAxuHAxiOAxSVAwqq
	A4Y+BFqGOyhrAyVzAyF6Ax6BAxuIAxePAxSWAxGdAw2kA+Z+BFyBOytlAyhs
	AyRzAxqIAxeQAxSXAxCeA2J3OzFYAy5fAytmAydtAyR0AyF7Ax2CAxqJA/p2
	BOp6BHo2BGRyOzRRAypnAyduAyR1AyB8A8DAwGouBPq+hPZ2FOJyBJJGBGho
	OztEAzdLAzRSAzFZAy1gA////8KahPrOtOZuBIpCBD09AzpFAzdMAzRTAwAA
	gLduUPbOtP7exOqOVNJ2PII6BD0+A/bezOaujLp2XIZSPFImHAAA/39PSO7K
	vOq2lLJqTHZCLHZGPEZCPHJeTIJKPFhYWL6+vN7e3ICAgNLS1ABAQAJ+BABA
	AACAAP//////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHEiw4EAA
	CA0qXGgQYYAAABhKbAjgoQABESdOdBjgIkaNEjl6vJgRZEGEAwgUGPlRoYGX
	DAEcQJBAwQIGI0sSNNDAwQMDCgFAiCBhAgWbHnUONFDBwgUMPxtm0LCBQwcP
	H0CQNGgghAURI0iUAEoQgIkTKKimULGCRQul/7p+dfECBtmyMWTMoFHDxtob
	LJTKFUEXx92DOXTs4NHDxw8gQYQIbiqiwhDDQYkUMXKEMZIkSpboHBxiiN2g
	TJo4eQIlipQpVJIgzMj0axUrVw6XxZJFtZYtXLog9EIcwBevYMKIGaP7IJky
	Zs6gSaNlOHE12NewAVOljZvmzt/qwIkjx/qc62ro1LFzB08e8AIBkHnzRo91
	L3PyY1ezZg+fPn78kVBQ891H3HlzqAFIIIIMQkghhmDnxYDOGXgggoAAcggi
	iUS4n4QUWkgcfsRlqIYBh3yoohoTRoSQIoqMeKEXHy7CyIoSwpgRAIo00giM
	I55HI3aMLOLIjR96AWSL/7zY448xokfkIkYiqWSUOsYHwCOPwOgjkPsx4giV
	Xhy5JIyQQBLill0+CSORYy5yZSNXpklhWWx6eeWYc0JpJ1wn5Ymll1BGEsmd
	G20JCaGFHgqoRgilCaMihiJqEp5pSmLppRQ9qlBAADs=
	===="
image create photo images::CancelArticle -data "\
	R0lGODlhIAAgAMYAAAAAADnMOwG+Az/AOzzFOwK8A0avO0S2OwyoAwivAwW2
	AwK9A0ylOxWTAxKaAw+hAwuoAwICBE6hOxiNAxWUAxKbAw6iAwupAwiwAwS3
	A0dW5VOWOx9/AxuGAxGcAw6jAwuqAwexAwS4A1WROyJ5Ax6AAxuHAxiOAxSV
	AwqqA1qGOyhrAyVzAyF6Ax6BAxuIAxePAxSWAxGdAw2kA1yBOytlAyhsAyRz
	AxqIAxeQAxSXAxCeA+BKSmJ3OzFYAy5fAytmAydtAyR0AyF7Ax2CAxqJA2Ry
	OzRRAypnAyduAyR1AyB8A8DAwGhoOztEAzdLAzRSAzFZAy1gA////z09AzpF
	AzdMAzRTAwAAgD0+AwAA/1hYWICAgN7e3L6+vNLS1ABAQAJ+BABAAACAAP//
	////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4SFgwCIhoqLhogBAQCMko0AjwICkZOTjgGXmJqS
	nJ6XmaCFiAMEBaOfpqcGBwgJCgujpa5/AAwNDg8Qs563gxHEoRITFBUWFxgZ
	pIYRGtIRiwAbHB3IHh8gISLCf9HS04oAIyQlJico2ykhwuLjGtSnKissLS4v
	MDEyM/DyyDWiUcPGjXw4cujYcSsCDx7y6J3q4eMHkCBChhApkgNRJocPIc6r
	ZuRIRSRJlCxBxKQlAJAheUg81cTJEyhRpCBh2XLKFJghZ9KkUsXKFZ5YegJ9
	KJQQgCZUqGThyQSL1Z8xmSYqB5Vqy6RYlsr0yWTroSZev4LNOtYnWbOPaVtW
	balFS8wIbvNOKRsJ0ZYtctUyyRtSL9m/mQBs4cLlr9ykg3128fKli14mjvnm
	Ury4MeCebidTtrw3M2JBiMCA+cvYcegvXrwwqWx6S5gwcAGoZu1ZMmzZrDHb
	xg1u8+7FwmELbz3cbDXdqz//7fxXjBjnm3SH4e3ZOnZTiG5P914cV/gwY77j
	OqV+USAAOw==
	===="
image create photo images::Change -data "\
	R0lGODlhIAAgAOcAAAdEHQY9GAUyFAQtFAQpEAQnEliRbJ/Yssjl0d/u45fU
	q1K/dhKjQi1YPAAAABKlRg16MwxrLgpfKAQnEFKNZZ3KqqHitmrXjkytbAQl
	EE2IYJTFoSOgTwMjDy6lWAMgDVGKZSmmVRaHO6HKrxKnR0t6XMLjzFSLZxuo
	TRSnSBBjLRynTQ5hKwQtFQUwFQY5GQY/GgdCHBGeQwtrLTMzMwUuE5DFo8Xk
	z4XImRyzThKpR3qri0lJSQEBARCXQBKqSBOsSWHEgXfal0hISKmpqUpKShGc
	Qi7LaTy9YETPYURERMbGxpWVlXd3d1nUc9XV1ZGRkVxcXF5eXouLi0ZGRtLS
	0lhYWD09PUxMTNDQ0CIiIiYmJktLS1tbWzw8PCgoKIKCgjU1NTc3Ny4uLmFh
	YXl5eW1tbVVVVR4eHgMDAwkJCZCQkHZ2dqWlpYSEhF1dXaysrH9/fzo6OmJi
	Ymtra7a2tmZmZr+/vz4+Pm9vbx8fH7i4uJubm2dnZ2RkZC0tLb29vaOjoyQk
	JFpaWicnJ66urpycnDExMXJycmNjY5+fnykpKUBAQFNTU3BwcGhoaHV1df//
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHEhwIICD
	AQQMIFCgoMOHBA8aOIAggYIFDBo4cACx4z+JFS8+gBBBwsEJGz0WBEChQgIL
	FzBAMLmx5oQMHFV+1LDh5QIOEQCkJLixQ06PAFxaeOAh6FGHDj48dQgAhM8Q
	IoSqHAoRwIgEF0iIiDC1Y1mBAEqYsLAghFOdKgGcAIsihYqzcCPOXbAiBQu8
	Klu4eAEjhlwTC1LImOHgxcEXLQjSwOugho0bCRKYwJFDh4wdlxPY0CqQBg8a
	PSA6AOBjwYULC34AIRFEyAUfpP/RGEKkCGrVACIYOZIDCBAkSXy8La1kCZMm
	vlM/XB3Bx5HjTpTn3v0EShQpU6LpA6+OXPtRGlSqQLFyBYsUJqelQw3uw/xA
	01nWX9Gyhcv705QFt5xuPCwBRRdeaKHgF+6BASBw2/FAxHo88BDGF1uIMUYR
	ZDTx4HRP1VRTGWaIscUZaKQhImAeqbEGG0poEUWKeXlEQxtuxPgGjTVCRAMc
	cXghxxxoUJYXDXTUYYYWcyjBIlc+2nEHE1jgkYceT6rY0W578NGHFn78waJA
	Dqg4FQ1IAhKIGYL4MQghY5IZRhgboUlDH4XcYYgZhyDyZpwDbRRGImBAoUgh
	fJyxiB+IwAloQXUy0ogUjjwCySBQ9kjmiplCFBAAOw==
	===="
image create photo images::Cleanup -data "\
	R0lGODlhIAAgAOcAAAAAAN3d3fT09Dg4OLOzs7+/v8zMzDAwMCwsLAQEBMjI
	yLq6up6enqurq7e3t8TExNDQ0FhYWKCgoBISEjU1Ndzc3AwMDJubm4qKioeH
	h5KSkpWVlZaWlqKioq+vr7u7u9TU1OHh4e3t7U9PT5ycnICAgAoKCqmpqXx8
	fIKCgpCQkJSUlI6OjqamptjY2OXl5fHx8bGxsZeXl52dnX5+fpOTk////+np
	6fb29s/Pz7y8vFRUVIGBgYSEhKioqKOjo66urs3NzaWlpZqamouLi7CwsGtr
	a0NDQ7S0tMPDw9XV1fLy8uvr697e3tLS0svLy8XFxb6+vl5eXlNTU01NTVVV
	VYODg3t7e3Nzc2RkZFtbW29vb1BQUDIyMkREROPj4+7u7uTk5FJSUkxMTEpK
	SkdHR0JCQj8/Pzw8PDk5OUlJSbW1tf7+/vj4+N/f35iYmI2NjXp6end3d2Bg
	YIaGhvr6+ri4uGlpaWVlZTc3N4+Pj7m5uYiIiH9/f3FxcTs7O4yMjGNjY3Z2
	dllZWVdXV4mJiVxcXEBAQEZGRrKysmFhYXR0dGZmZj09PU5OTn19fXBwcFFR
	UWxsbHl5eTo6OsDAwJGRkXJycra2tnh4eGdnZ0hISMLCwjY2Nvn5+WhoaDQ0
	NNvb2/v7+0VFRUFBQff3962trQICAnV1df//////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHEiwIAAA
	BRMqVHiwYQABAxounPivIYECBg4EQHBAQAIFCxoipFgRAIMGDh5ACBBBwgQK
	CCpYuIAhg4YNBycC4NDBwwcFIEKIGIBgBIkSBEycQJFCBYkVLEYmBNDiogEX
	L2CIcBFDxowSB1OgoFHjggYNUg3asLHyBo4bAXLoONFgwIEdPHqokKDBx4+0
	BAEACbLWxgsXBgoQEDKEBYchMoh4cFDEyBHAAwE0QPIhiZK1S5i8aOLCyRMo
	UXT0kDKFymWdVToHSfKBQIMfF2oQsXIFi5EsWqYcwBy4QJUqWGjbxq2bN5Yt
	XLoc8EI88xcwYRyI2SFmxBgyZbz+mDmDJs32HWqqCwTwZY0DNm2W3HDj5AGS
	H2/gxJFjZE6a9BSxRwcdcNRhhxX0PXAHfnBwgYcRZ+RBgXoVfUGHHnvUwUcf
	fQTgBx5zEFAFFWRA+AeAOn0BiAwZ8pGBEB4a0YeIYgRixHgoLsQeIBJkyIIe
	MArix4yDEGKjGWbkyNAXhZzg4xtBykGkITYegoiSU33RQyIZEiFBkCjMSIgi
	Np5BBpYGfcHDBxlm4AOMi6Qw4xSM2NiII2gG9sUjOmSYQgwwQrIhAZFIYuMf
	eFLI3iQFZIgUjJKwMCMVkNhISaIBfiFIJRlesQaMd1gyIxmL2JgGpilekgQm
	dWTiAIyqmqww4yaZ2JgHqjp+sQUnDdSxyAISBJCFDDMi8sgcd3SC65KBKHCB
	J358MEMAc1wQBwGI8GDIJ6A40oiioSiQSQGiZJEEEQFIwYAcBIyiBxc3kpJn
	Zh+IUAobNpjyyRsVVHECIwQQcoQimsyxwyEUVsTJvZ6IwEkFTrSwAyAcEBHH
	Jf2RkrBAgQBwygoKzOdEEkh0kJ9vpwAQCEkJ8WGESCJRgQrLNNc8UEAAOw==
	===="
image create photo images::Close -data "\
	R0lGODlhIAAgAMYAADU1NTMzMy8vLysrKyYmJiAgIBkZGT8/P2FhYV1dXVhY
	WFJSUklJSTQ0NBQUFEREREdHR3BwcHFxcW9vb2tra2ZmZl5eXlZWVkxMTEBA
	QBAQEHZ2dnt7e35+fn9/f319fXl5eXNzc0tLSz4+PjExMSEhIRwcHA8PD4OD
	g4mJiYyMjI2NjYqKioaGhmxsbGBgYFRUVEZGRjc3NykpKR4eHhoaGg0NDYWF
	hY6OjpSUlJmZmZeXl5GRkYCAgHV1dWlpaVxcXE5OThsbGxYWFgsLC5iYmKCg
	oJWVlaOjo5ycnGJiYkpKSj09PSMjIxcXF////6WlpZubm4KCgicnJxISEggI
	CEhISJOTkyQkJBMTE6amppKSkgUFBa6urqSkpEFBQTo6Ojw8PKysrE1NTTY2
	NhEREQwMDAQEBDg4OKKioo+Pj1FRUUJCQjIyMhUVFQMDA09PTywsLBgYGAoK
	Cjs7OyUlJQICAigoKFtbWwYGBgEBAQkJCQAAAB0dHQ4ODv///yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4SFhoeIiYqLjI2OhAABAgMEBQaPiAcHCAkKCwwH
	DQYOmIMPEBESExQVFhcYGQEEDhqYEBscHR4fICEUCBciIyQlJieODBwoKSor
	LC0eGy4vMDEyMzQ1NowQHDc4OTo6OzwsPT4/QEEjAgVCQ0SLGCg4RUY5R0hJ
	OSkfEUpLmABoYsJJvETdUuQwouPJkyRQouCQ4gOIQxJTClKpkshKBxU6cjh0
	GMXIlRsURj7BUjALx0MHJHhYoUOLEZVbcoBQ2WCGRhtcDo2Y8IHFDiRdvKhE
	ofILmIxOqAA9FIYCiBY8IIpJonLkGAhkCLwrY+bMITQVQnhgkaNkGjX+XS+s
	YdOmRA03Goi8OQTAAoUNPVLguJKDqUo4IsLEMSEny4k5ew0JuIDAhY8PUm7s
	7PqEToM6NYZIrWLn0B0MF178iOAj5Ug8KgkwdnCCSB49h0rMEAEDiBKLIy8o
	gKDSyZAyNvac4YOoxIgYQZaoHLNGBF2VZWrfTiSHhIwRDzI4/AKBTZgGA/o4
	zG6mynJFbmYIACCjQQMwZNrEqWOihoMyGrTHBXOKUEFDAU1MMcMMUxBQTA1y
	DOGYGXtwoQeBimgghAkccigEhEP8d4KAdmC4iB9OpJjiEG5kQcUJNhBRhYUm
	MkIEES5SASCMROyRx3I1OlJFFTaYQcQcVfwVeGEphnBxxhtv2LEkk1RWaeWV
	hwQCADs=
	===="
image create photo images::Connect -data "\
	R0lGODlhIAAgAMYAAPn5AMLCAMnJAM3NAMTEAKOjAHh4APT0APf3AMPDAMDA
	AL6+AL29ALu7AMHBAKioAAAAAMXFAP///8TBxAAADfDwAKWlAN7e3ry8AH19
	AAAAAZKSAHt7ANzc3N3d3XBwAHx8AH5+AIOBg727wN/f397f3uTi5BERAFpZ
	WuHh4eDg4Obj5uDd4Nzc3bGvsWJhYltaW4uJi+Dh4N3c3QEBAYB9gN3b3Wlp
	ad/e36mmqYF/gb+9v8jGyKWipcrIymNiY5uYm4aEhggICAoKCmpnakRERGhn
	aF1cXdXT1QQEBAUFBc7LzgwLDA4ODgsKC9va2xQTFAYGBtnX2QcGB///////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4SFhoYAiQCHjI1/igECAwQFjpaKBJmZBQUGlocH
	AAiapJ2en4WZCQkECgQJAZynqIUGBQsBDK6UBrO0tQUNCbu+v4a2rQrKxo62
	wwoBDsyNtsrW04wGD9bLqBAQjAfcCREEEZ8QEhMUhQAV1q/KBRYWjukXFxPg
	ggDcChicTGVodA9fPgiJuAXsVcxQQYP5NGxQYIETh17eJFzo0MEDxAkaPoAI
	wcEYBBEjSJDAV8IEvgknsEFAgdJDigseVJhYcXDaTJojLqzEx+Llvl8/gaoY
	iq/FBRdHac18ASNG0JsyZjwVEZUWjRo2bqDEkUJrDh1cfe6QwAMovh5RIkSg
	6IpurY8cP2CgBBJErhBmQ9baIFLEyBEUNOXStQRhLRIiSZTQQExzLrPGEpYQ
	YTKoCWUnzJKsfUIESqFvix1FWSuFSOrLa3cQmYKt9rRAADs=
	===="
image create photo images::Disconnect -data "\
	R0lGODlhIAAgAMYAAP39ANLSAP//AOLiAKOjAOTkAEZGAAAAAP///8TBxAAA
	DeXlAN7e3gAAAdzc3N3d3YOBg727wN/f397f3uTi5BERAFpZWuHh4eDg4Obj
	5uDd4Nzc3bGvsWJhYltaW4uJi+Dh4N3c3QEBAYB9gN3b3Wlpad/e36mmqYF/
	gb+9v8jGyKWipcrIymNiY5uYm4aEhggICAoKCmpnakRERGhnaF1cXdXT1QQE
	BAUFBc7LzgwLDA4ODgsKC9va2xQTFAYGBtnX2QcGB///////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf7gH+Cg4SFhoeIiYqLjI2Oj5CRkpOUlZaVAAGXhgIDBJuE
	AgUEBpcHB4KipKYICQoCC6uWBwgMDAkHsoQAA4+0tra4nJ6Ov8DBDaGepYy/
	Dg4PxwnJf526iwcQERISthMUwRXWzI0HFtoPFwwPGBQZt7nk5RbnEQzdthrB
	qJDm9NoY8NnawIADP18WOnj4YE8diBAFIRx8JGIEiRLaTFyAeAKFREkHUiBQ
	Uc/WCggQLEwsJ5LFiRYetLl4kRJGpBgiSciYQaPGv5Qrm4m0IeMGDhH0zqmM
	FBJBDhk6Bu1IyiPSDZE9ZPgodCrooh8igcjwClJkChlBQKk1FAgAOw==
	===="
image create photo images::Error -data "\
	R0lGODlhIAAgAKEAAP8AAJmZmf///////yH5BAEKAAMALAAAAAAgACAAAAKQ
	nI8Dy5sPUZssWkWzu1J7bngiEFzjWELnmXaTIMJUG76CTN04Q+f6vvgBSYeM
	sHGc1Yy/YFNTigmfUIxnekMFTlPWdtTVgrHiKzbrCXyZOmcbGvW93eiJeslI
	Iqm8llwz1+eXE5Nx57ICR4OX2KC2aLDWuPBoIZlYeXGpBQmh5nUIErlJ+dgJ
	YpoaKuqpClIAADs=
	===="
image create photo images::Exit -data "\
	R0lGODlhIAAgAKEAAAAAAHV1df///////yH5BAEKAAIALAAAAAAgACAAAAJ1
	lI+py+0Po1SgTlnBjXnT1CHaFBqlcDqZZbLoCgVrcJRyRqtw7b4puOONhD1g
	0Uf5GW7H32wRFB19Q+lUGSVCr9huVZvkfltT5tiJY2R1U3Lb+KaO4XOEuS7P
	sZ/LlXLrF7jmcCcIoHdh+Ddxh+jxCBkpiVAAADs=
	===="
image create photo images::Extra -data "\
	R0lGODlhIAAgAOcAAAICAtLGBnJyAiomFkZGRt7iCqGiptJuBm4GBuaKBmZm
	ZqI6OtLCDtLW1u7qDpqaNr66JuLm5mo6FFIGAurOQm5CFfKyCsaOFnZiTn5y
	Yuq6UnZaQvLyavK6uk4aAuamIu7u7k4CAoJ2ZoqKis7OzrJGQu6mpsKunrJm
	Zraehn5WKPZycrq6ul5eXvb29lIuEnJOTpKSkjYSEo4mJrmii4SGhsp2dnlS
	Kp6enpJuS75OTvqenoomCtri2qCGapoSEsrKy7iyqhYWFlwyEI5+bl5CKs7C
	tsJmZo5KBnpiTvr6+iICAnpuXq6urm5OLoZyXqqOdo6Ojubazq46NlJSUkYm
	Do5+aqKSgtre3ooGBrKillpGLoZOToI+OpJ+Asi6rKpiYtpSUjoiCp6OepNy
	UKKaknZKGmE6E4ZqTt5iYpI6DtKamo5uTJp6Wv7KysIuLg4ODlIyEP7+/pqe
	omJKKnJWPr6+vuaCgsa+toZiOtrOxurm3paGhqyqqLKahGpqZmY2EpJmZoJa
	Lk0uD3Z2dt7Wzo52Yubi2ryqmm5GHH1WOu7y8s5WVpx+YHpSMlU2FrqKhtba
	2si2sJZ2UoJeMqyelJqamnlOJtLS0oomInRKLO7m4mIyEq6SfIdiRW4ODIpm
	Pra2turi3l4CAlpKQqKmpvqmps5mYpJOTms+FGJOOsrGxr7CwkYyHsrOCsa2
	pvp6esJWVkIqDsY2NopqSgYGBlY6ImY6FNLKxkEmC6aKceXe1+rq6mZCJnp6
	el02EWZKMuLi4pRyWIlmSI5uVHJGIqamp5p6ZrqmkLKyspJ6en5SJr6yqtbC
	wpZ2Xvby7m5ubn5WL/r29HJCHlo2GnJGGqaOemY+Ht7a2paWlt7e3oZeOO7q
	6EcqDcrCtmlONnJCFoFaNY5qS356etrSyrKehmI2Eubm59LOznZKIXZSOpd2
	V+Li5oJeOJJuUkImEuLe3tbW1VYyEubi3sbCvlYKCsaynrJqZtLGvrKmno5+
	evLy8nJGHtra2cLCwv///yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHEiwoMGD
	CBMOdKWwYUIHDBxKLMhBw4OJEwtQ+AABo0QGCQ5YEODR4QUkXko2DKPGAw+V
	ChnpAPNpAkyEJqbYALPk5kE3azItGOXTIKwdRxCEKFqwwxsd92TAtBRjhDE7
	QDBhcnMqywwuJEI1qdGibEIcfVgEc6FEiYu3claYKlEv0D4QIHhFCIYJGgEF
	BZvE4+UWxN23SuTcmWUDFYxzeM+dYxeMXT8D0AbG0OYChAs5oEPLUZLmx6cu
	+lZhihevXz8s2rRF8gdAYIy1+9iKHs2rGSRDfHAkYwGEhFZMDbSSqP3PFx62
	IJ5JC61kEV9WYg0YSxaKxSp0mEj+aDuHibmvFMH8hbry5bMSXqKwodMWD5M/
	O3iARGKHLV8GO+eUwRwhuvTDhCobrENYPEE80Usl8CgBQh/foKELJsHgUYQs
	ImBCinm64PMNLeJMQg4IlWDQywbh+LGPNqrYckYqyMwzhiyDFMFMK8z9IYwh
	0bBBRhs07JHEN5pEE80yu2iRyxDVVOOMhlUMEYcVuTAHTTvtiENGDsLQQE4R
	6jgSjgrF7PLEL6lUA0gOPshDTRyPDCIGcy1cAsowZKzjQxto1AEKlzekE80l
	5khQDSfV3PDLLy880s2dArUQTh7DiNNGI+KA4skw4SxziaipcHJLKrdUcMYZ
	8rwwSC6suQxQKRa6sDGMMJOQIY4n4oTTTjHTTCMBIBVIYEY1ifxyRhyD2KKM
	EAIpEAEv9rSxjjA5iDNMDuGEc0MiiVQATjXpnFrBNU5QU8crm9QyEDR2TMeN
	JDQ4QwYt2zhy6CU3XFINP9WEQ4s1iEjhAj2+FEQIFVGAANoehejxCiJ+lNNJ
	JzScIMkJuOzyDBBRQDNOQkIAUMsfNWhnjAGltGzAHKVkAw0AAMDBFEYBAQA7
	===="
image create photo images::HelpContents -data "\
	R0lGODlhIAAgAOcAAAICAgpeXjKCgjqKhnauqtrKpuraulqemkZGRvbu1gIq
	MmamooK2sjaGgraqkmqmoh52dvr26pqKao66um5mVm6mpoZ6Xsa2kgIODp6W
	cmZeRuLazkJCPgpqavr68ubOpm5qVsq6mqqegubezg6Khv7++trCnubi4kKO
	iu7euoJ2WgIiKq6igu7u6paGai6Cfr6qjvLq1kaSjqqiiurSqtLKsvby4u7i
	xsKqfnZqWtbClp6SapKCYv768kqWkhISEt7Oqs6+ouLWxs7CqvLmzvLu6vLm
	yqKWfs6yhs62hn5yWtbOtvr29p6SbiZ+eurm3mZeTlKals7Grvr27v769vLq
	2sqygta+kpaKduLi2vru3vby7n5uVop+YrKihqaWft7SvrKmkm5iSp6SeubW
	su7WrvbiwmKent7e2trOtv76+mpiUoJ2Zvbu2v7+/urm5vbq0nJmTvry6vry
	4tLGsurWrnJmVnpyZp6Obl6inq6egvr69squgt7Gmp6Oeo5+Zqqagsaugram
	gt7Stvbu4npuVurq6m5iVoZ2WuLSrq6mgvLiyvb28qaagvbq1s7CrurWsvbm
	ypKGctrGmvry5vbmzlaalvr28qqeivLq3oZ+au7avtK2ioJyWqKSfuLe1ubS
	roJ2Xq6eht7Kos66lpqKdt7OsmKinvbu3s7Gsvru4mpiVu7iyvLm0vby8nJm
	Wlaamq6ihvby5s7CsurWtqqehu7evtLKtpKCZs62imZeUsqyht7Swt7SuoZ2
	XuLe2v//////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8B+EewoMGD
	CBMSVEAAwECFECMqYABB1MOIGA1OhODFzcWMBB0m3CjKjUeQAgGc+FhQQQWO
	Jk9GdPhpyhSWCx9AiBVTZkIAG/bsoXIJ5z8Fpyr29FnQ4RuhVPZ4MIoU5tKP
	QIWqKbFHDaMfCMIi4LDwgNKlMgGkQbWnhJs9b4toCJNqCpUAAxWYLYnWkENS
	RlQJjbnHlZgwdKbsCdABg4IoEESgdfNGQpI6i1Cp2epmc4s4YaS0KcHYMeRG
	kw254FTGCNuhJbhuKRTmURUPpRX4gPBl8hsXSDBr2cNE6FBGSuhWId1YAQoI
	R1LjQlKGiJaoQ6UyshB6ee7nfib+Z+ERPPOUS+fPy7LggM7t3AMgjDFZQg2T
	S3t+deFTh4iqKT140EMPU2yBSGiZMOdYAxBgQdQlHkwRASWfhGJFGYvYMIUc
	ckgoIXei4dbcCw1KSMmElMiygS+BYKiFTRxGEIEcKtSWYG5OQCAJJXPIggoh
	WiSwgQqB1GHEHCdGsOGJ3KXyXnM5SgJkkAnA0UovSgRCQ4Y9yiLHFjbMUaMU
	NzYGQAcEsAEIHGwS0Yotg3CBQ2taEDKHjJTYooQKDkjxJAYCdTABBY1UUkkk
	NxgwChdaLqKFDYRUYQQeoWBSG5kKhoSmHY2YYQsNtKSRJYY/tmGBBJZKIUUq
	t/zZVAe0Z1AgAhkfmDIJoxiOQIcKMzgwxBCsptFLmYC+esYqgIDygQmFFFkG
	DxLEckEQt9iySAyZoOKqQWcey0IfOhSCAw0WZMDCBWQYYAAr11bRxhNblIbQ
	mZbIekUOOCCygxeTFAADDF6IIooejYhwRAbyztsBLFAAsucOa6wBRcQUrGKx
	Ha/YkUMOCStcLxcW3CGAAC+M/EIDAqBM8skjF/uTAB3ETMIKDtVs881GGYTB
	zjujVFBAADs=
	===="
image create photo images::Login -data "\
	R0lGODlhIAAgAOcAALZwDrJnAMF/AM6bobx7RfDUAP/8fvXdB5xHALJoANmr
	AP/8nP/7P+7SANKcAG8SALx3MLx2APfhDv/94d2xALx3AHwgAI01BtOjwNCe
	Xteqj8CAW61eAOS/AP/9wP3tIuO+AMaIAKZTAIkuAE8AAMGEIsqPAOK6AOO8
	ANmwu7JoAdOgAP/8Q/DTAJlEAJg/AJ1HAGoRALp2JdemAPzrIP/9///3Nt+2
	AM6WFbx7P7ZsAP////vnF+G5AMSCAKVRAKBKAK1dALlxALx7V//8XujGANKg
	V8CAat61AP/xKufEAL56AJQ7AI41ALRoAMB8AMWHAM2SAM6WAIwvAJY+ANqs
	APHVAP/zMP/uJb57ALJrDv/wJ9OeAJc+AHQYAGoQAGgOANCbAK1hJd6yAPbf
	DNShAPbeCf/6Pf/1M8WIAL9/W7BjAPzpHLFmAHQaAIkvAIcsAH8iAOvLAKFM
	AGcNAKhXAMB/AL9/HHwhAPrmFfjkFbdtAP/4Oe3OAIMnAHofAJlDDOvKALVr
	AMSHJ4crAMmMAOnIAK1hAJE4B1QAAPPcBm8TAJdAF6NTFfPaBpE4AMaMPZxH
	DMqNAMuRAL9/LqBNInIWAPjkE/jjEebAAHkcAIMpALBmIsOAALdxRcqUZqBM
	FY0zAPHXANmqAIwwAJlEIrx7SciPFaFNAM6XANinAKZWDtCZAOzNAI42CVkE
	AKdXAKJRAKhbAKdWBp5JAKBMAEcAAMaKAKFPAcmRW6pbADsAAJY/AMSEAKdW
	ALZwQzkAAHsfALdwAK9iALt2ANytAIouAEgAAGULAKZXF2MMACcAAH4hAKxc
	AIgsAKdYLnccAEMAAJM7AFwGAG0RAJdDCf//////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHEiwoMGD
	CBMqXMiwocOHECNKjAgggIABEw8SCFDAwAEEGQsmULCAQQMHD0IKhBBBwgQJ
	FCpYuFAQQwYNDTdw6ODhA4gQIkaQKFjCxAkUIVIoVLGCBYsWKwK4eAEjBkEZ
	M2iwqGHjBo6DOXQc2MGjh48fQILoEGJh4BAhBT4QMeBhQhEjBI8EQLIgiZIl
	TJo4eQIlipQpA6lUsXLFxlwWWLIM1CJliwErXLp4+QImDBcFPph0ESiGwxgy
	PsuYOYMmzT81awrsYIOijZs3/+DEuXFDzhw6dQQ2sXNCApI7eB7kSaJnD5cz
	fPpA8fNnIKA5gXQUEfRnkEBChYryGDr0D1EiLkl4YPGgSAGQRYwINnLi6FEY
	SAMjdZFUZBKlf5VY4sMlmOSRSQSabGIQJ52s4MknBL0BQxSZBCEQKKEUIsoB
	o5CySCkHmRLEKQa5gUoqqsAg0Co/sNKKEnG4ItErIkjRCSwCxeKDAh3IklEi
	c0QhxCwC0YLEGDPUkpEtXdwSAC7/5DJJA1V0oktGu4zwxBq8/NPLBwWw4ssv
	GQETjBDCDEMMCxMUY4cxIR2DTBs6rDHKDn+hkkxIythCSxttBBCBDoLEodI/
	yzDTjC5BBLGGM88cCk00friACirOSHPoQNDQMQ011Wwq6qgNBQQAOw==
	===="
image create photo images::Mark -data "\
	R0lGODlhIAAgAMYAAAAAABMTE1FRURgYGF9fX1NTUw8PD2dnZ2BgYA4ODmlp
	aWpqamxsbGRkZCEhIWtra21tbW9vb3BwcC4uLm5ubnFxcXNzc3R0dFxcXBkZ
	GbGxsZOTk1JSUlRUVHd3d3l5eSsrK7Kysp+fn6GhoaOjo3x8fH19fbOzs3V1
	dVVVVVZWVlhYWFlZWVpaWltbW4GBgR8fH7S0tKSkpKWlpaenp6ioqKmpqaqq
	qoWFhXt7e7W1tV1dXYmJiX9/f0JCQra2tp2dnYCAgKysrK6urq+vr42NjSgo
	KLe3t2FhYWJiYmNjY5GRkbi4uJSUlIiIiLm5uY6OjmZmZmhoaJeXl4qKijEx
	Mbq6upKSkpmZmYuLixYWFru7u6urq5ycnJubm4yMjDs7O729vZ6enry8vL6+
	vqCgoKKiohcXF7+/v6ampjMzM8DAwMHBwcfHxxsbG0dHR8LCwioqKsPDwxAQ
	EEZGRsTExCUlJcXFxRQUFMbGxiYmJiwsLP///////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg38AhIeIiYoBAoaKj5ADAgQFjpCXgwaTBwiVmJgJ
	kwoLDA2en4oOog8QERIKp6iEE5OkFBIVFhcMGJayGRobthIcBR0eHxK9soMg
	IRsUuSIjIyQlJhfLzIUnGxYoKSorLC0uLx7azDAxGx4kMjM0NTY3ODnpsjA6
	GyXlGDsECCDg0eOBL1Q+fgAJQk+IkCFDiBR5YXDbHyNHgOAQiCSJkgYNluCo
	uC0DEyA8iGjQcOJEDB1NnJBkBuAJECgNohyQIkWBgilUZsqqYgXIFR1HmDB5
	whRLFqGotGzhMgULAwYQKEDo4uXLhYOfwITh4kXMmDBkwogQ0/WrRQBmZLiU
	MfOOhJkybKm43XYGDRcZaWgEpkEYi16wmNSs0UDPhoYtkCPTQHwJABsNQ25o
	aOMmRYo3oEFbdAOH8eYAFhXFkbOyzZzUiujU2fwadiI7d9rgsa0IQB49vBXZ
	2RNcdfHjxQMBADs=
	===="
image create photo images::Network -data "\
	R0lGODlhIAAgAMYAAC4uLoCAgAAAAPPz89vb2tXV1c/Pz8jIyMPDw729vbW1
	taysrKWlpaCgoNnZ2WFhYf////z8/Pv7+/n5+ff39/X19fPx8e/v7+3t7enp
	6XBwcOTk5N3d3c3NzcjHyFVydWJ1d2h2d0ZwczdtcSdqcBdnbwdkbevq68fH
	x1lzddvr7bnY25bFyXSyuFKfpi+MlAxwecXFxfb19c3j5bHU15LCx3Gwtk6d
	pCyKkwlvd/Hx8UxxdJzIzIK6v2Spr0WYnyWGjwVqcz9vcmytszWPlxZ+hwVk
	bOfn5zFscTuTmiGDiwVxewNZYeHh4SNpcEiRl0yTmUCMkzGEix56gQhpcQJd
	ZQJPV4eHh9HR0MvLy6mpqU5OTreiWIh1H2NjY15eXtfIlGteGOXl5aqqqrKe
	Ub2+vpeXl2NeKENCHIyMjFxcXGhoaGxsbF1dXVJSUr2+vb69vf//////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4MAhoeIiYR/AQKLhAADBAUGBwgJCgsMDZwOD46D
	jY+CABCmphESExQVFhcYGRqfhKKjpacSFBawGxwFHR6yoIK1j7cfICEgHyIj
	JCUmJyjCtMOLpREpKhAqKywtLi8wGTHUodaQETIfMyozNDU2Nzg5GQjmxOiF
	Ejo7NCs0ePTw8QNIEHv4GOkjNQGDkBosavQY4oJIESNH7s06N+oPABlHkNho
	YcOHiyRKljDJmLDYtQFNnDyB8iSKlClUqlhhuTFfRwA6HFx4deJEhgxHkiK4
	d8XBMJeQMGAx0CHLARQxlmpFoCXDFlBcuogtlKjsIQ1evmypoGFLgLf+XSCA
	CUNKEiVLmDRxauBJgJi/Y9oKGNwFDBm6t06lWtXqVaxPW7aUMSNYUJcwZ9B4
	PAUh164MvX4F++TAQYMAGqzVOpZsWbNn0aZ9SkM79aLVELJt6/Yt3Lhynw7p
	W62OnTt48ugh7DlqNT9/AAUSNLh8IUePDR9GnFjxIk/rPj2CFEnSJEqV3zuG
	jxRzZs2bOXdqBK+QVNChGIoeTZqRqQMA6q0mFVVWYbXVUgF4Zd1bjgBQwVtb
	qLEGGxSysUYbbkTG1ldvdeghKABc8NeIJJYY2FeDpahiIRskkMAbb7gIRwJl
	RBbZZJWpR4ppe/XIV2mmoUZfIVjQZuSRSNoKpiMkZjW5JCGBAAA7
	===="
image create photo images::New -data "\
	R0lGODlhIAAgAOcAAFVVVVFRUQAAAEtLS0hISEVFRUJCQj8/Pzw8PDk5OTY2
	NjMzMy8vL8nJyf//AMHBwbq6uqysrJ2dnUZGRv////X19ePj49jY2ImJiVNT
	U///Kk1NTVJSUtHPBv//Vf//B///eP//f1RUVP//Gv//QMzKGcjGM///n///
	qlxcXODg4P//T///wv//1GFhYcbGxsjGLWlpaVBQUExMTERERD4+Pjo6Ovr6
	+tzb2dHRzLy6s6Shl4eDfnl2dFxZV+Tk5MjHxbizq3x4dfLy8efl4t7c2dPN
	wJaPhfz8+/v59vXy7u/r5OTf2dvXztLMwaehlAICBL67APr28fTv6fPt5O3m
	3uHb0t/azrKom/z6+fn07vjx6fDr4erj2enh1uDYybarl0NDQ/v49vn28Pj0
	7ffx6PXv5vDo3e7m2+jg0efdzLWolPv6+Pr49fn18PTt4fPr3O3k1uzh0ebb
	ybyul0FBQf7+/vjz6/fy6PXu5PLo2evfzOXaxLyrk/v5+Pr48/Pq3PLo1/Hm
	1PDiz+reyenbxLuqkPr38/bx5/Ts3/Djz+/hyujYv7+rkD09Pfz7+/n17vj0
	6/Tr3/Hk0u7ex+3awubWu7+pjDs7O/Xu4vPp2u7gye3exuzbwerZv+XUtr6p
	ifjy6fbw5/Lm1/Dl0e/izunWuujVtb2nhPXt4vPr3vHn1vDj0e3cxOzcwerZ
	vejUtefSsrykgTc3N/Xw5vPq3u/hzOfQsObPrb6kgezav+nXuOXNqL+jfDU1
	NenVuObPq+TJo76iee/izOrYu+jTs+PIor6edTIyMu3bwuXOquTMp7yfcTEx
	McjBt8e/tMa7q8a5qca4o8W3oMS0ncSymcOylsOuksStj8Kri8GqhsClg7yc
	bf//////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JFAgAQAAB
	AwgUMHAAQQIFCxgIGEixYkUADQQ4ENCgY8cHECJImDDRokmCGTdSWMmygoUL
	EzCUPFkxQ0YNAljqdLmhgUyaAgVM5CCgg4cOOSkIbbmBgs+ZFjV+ECoARAgQ
	VD+oXCli5VOaAkaQKGHiBIoTJkqQGJF0ZQoVXn+eFLACxAkWLVicALGi7UoX
	L+A6lWtSAAwULSi0QAHD78oYMmYQoFHDxgKoFA0jVszYMYUbOHLo2MGjhw/M
	Qevezbu3r86VN37gABJkhxDUAj6MLXs2LYmpr28MIVLESJAjmDVuFLrCQ1+h
	DrZSQJJEyRImTZw8QQ1lIskoGqL+JF26krqUKVSqWLmCBfXAAtA9U8iSRIqW
	LVy6ePkCxr3AMCl5loUYY5BRhhlnoJGGGmv4948BAb7GRhtuGGjGG3DEIccc
	dDhYRwNK6WTHhG7cgUceGOohxx589OHgASCK6McfY9xRBoqABCLIIIQUYoiD
	NcRYHhuH1IhIHonkKIgiixTCSCMOOiLkI0RCEsmRkuQ4CZOUVGLJJQ5iEiN1
	f0ByByKZSKJJIJMMsgknnXjyCSgO2gAidYdAEoooaWoyCimlvBmnKaeg4mAC
	INanxZ6pqKLHKqwE2oorr5gCSyyyODhLA1nYtwUtb9TyKCu2bNJKJ5XCcgsu
	uTioQAOBYlgYqh6CkFJqK7q8souquPDSi4O+NODGgSnWagsluL7yi6rA8BKM
	MA4u0MAdKMJB6yDDIKsLMb8Uc0uzxhhzjIPINFDGG0oOcmwy23Z7izLLhGsM
	Mw4248wz0EQjzTTUVGPNNdhko802ufQizDHMcMONgxJR5fDDEFMF1MQUDxQQ
	ADs=
	===="
image create photo images::Oops -data "\
	R0lGODlhHwAiAMIAAP///4CAgAAAAICAAP//AP///////////yH5BAEKAAcA
	LAAAAAAfACIAAAOweLrc/jDK2YBdITdNjwXBl3GZNUYfGJbjKJ4PqKquKa+B
	AJlsS9MjHUNkwxmBwWGxxWwyhQpeCOlsQqNFqrQHuh4EwB9OLPUKBMwlEulV
	nNFVnxWSi9vbjHrubc9NBnw6cEFnSREDFgR+boWLbxKIAIoDlJQLZx0KlZQE
	kouZh554oAuIiqOkB6afqQ2rqKSvrQ+rAZuzmpsEu7CpAwS9scC4tMPErsbH
	DIDKrsHNxAkAOw==
	===="
image create photo images::Print -data "\
	R0lGODlhIAAgAOcAAAICAgoKBgKCAqqmWsrGhgL+AhISEtbW1ubm5iIaEnp6
	en5yHuK2eoKCgtq2ivby6p6enta+mraabtayioqKikpGLqKiomZmZs7Oztra
	2r6+vpaWlqampubWuv7+/t7e3lJSUqqqqt7Gpubawurq6mpqaq6uro6OjmJi
	Yu7iysbGxuLKpm5ubra2tu7m1vby7vLq2pKSku7u7uLOsvb27l5eXnJycpqa
	mt6+kt66jureyvLu4gYGAoaGhu66frKysvbu6n5+fubOquLi4nZ2dtLS0ura
	wg4OBsrKyvb28urKosLCwlpaWvbu4rq6uuLSsuK6ivLizubWwu7exubCmvLm
	0u7avu7izvLq3ubGnvLm2tq6klZWVu7ezta2kurWut7CnubKptrCota2iura
	xvby8vb29u7awgYCAg4KCubOsu7i0vLq4uLGphIOCurWwg4ODvbu5ubSugoK
	CvLu5gYGBu7eyhYSDubStuLCmubWvvLi0vLm1ubOrurezubKquK2furWvura
	yu7axuLGqtq2jta+nuLKqt66kg4OCtq6lubOtv//////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHEiwIICD
	BRMqXDgQgA4dBwEwnJgQgBAzGM1ciUiRIoAyHjJmnMKxI8EKAESqfEGHjZ2S
	HQEcEhkSY5kXQHbAWHNlSp2OKDHWFJqEZRwsWPZcCRMg5kyVZsrcBMJGy541
	duYABZCEppmiDx7swHLFjp0VEhdGlAnkxQupbl88oDOWzyAjZNZWNHFjAw82
	dOjEmTs3MBY+awSdOaMEwAACaRvyhQBghYs1MHaw2axFy5qrKYwEMgJgwYDI
	AgH8uMG6jp0uggTpcOHCsxYXSo18+RLGMWSCAExs6AsgTB4pUkYgl6Ljip8u
	V87gmTEjjWnUqmPE2LChhgEJUPL+bKFOXY4cPR3wtGlDhcfjyMG1c+dugQuP
	ORIAFZpgyJAYEStkQYgSc5gGR0M/nKCdfAtCEAIXcwCQ334TeIEDGDjc8R5C
	AHjgoYILhnjCCRBwAUAi+VW4RQJpHGRDCUQcJMOMHnqgIIgjUhCDjhBcUEcd
	EviQBgo1XHABERTUAQACTM5IQo0jnkCBlD1M2cNwTByEAgos2ECBiQB8MISY
	QwxBApM1UqBmlT1U2QARNsRJRBAncAEmBkhgkEEGB3zwQQZlDlFjmz000EAQ
	QSgAJxEnMGHnQS388AMSKixRBAZ6HtCnnzUaeqgCip4AAgiPHqSdCSGEsIQG
	TlBqKaZye2ZQI6IKxECqnSamdpCUIXBggRORrtqqCipoWkSNuOKK2j8RFQrB
	sz+YYIITwFZqaRFFJJurWgch2tcGHPgarQAFOLFEsstyC4CiMYz47A2pcqCs
	ScC5aIObw23wKL0KRcQCC55uy6+6JZSQ7sD9HhwQADs=
	===="
image create photo images::Question -data "\
	R0lGODlhIAAgAKUJAAAAAB4eHmlpaaWlpdHR0e7u7v39/UZGRra2tv///w4O
	DqmpqSAgIOTk5B8fH7+/vx0dHVhYWLKysuvr6wQEBP7+/vf39729vdfX1yQk
	JO/v7y0tLfz8/NnZ2efn5w0NDRwcHMbGxo2NjcjIyFVVVeLi4qqqqhUVFTg4
	OHFxcf//////////////////////////////////////////////////////
	/////////////////////////////////yH5BAEKAD8ALAAAAAAgACAAAAbV
	wJ9wSCwaj8ikcslsOgHQqBTgLEIDggGhYDAUCANBAFoFHBCJtHqdRhyoTMWC
	TWcvFEtGoz6lNxxJAA98UBBRdA9wVhF1CVBqj3QRikMAEo1skWwSlEIAE5iQ
	mmsTnT8AoWmHjaafoRQAFJilRpaho3SctYx1FRapCZNHgnUWFwAYmIlJGXUa
	q36ASht0HB0AHnULH00gwG1vVSAhqQhkVacimCOmTyDqdSTt7iIldCDzTwAk
	JmslJ/n0AUCRot+/gGWigCCBAiG6KegiSpxIsaLFH0EAADs=
	===="
image create photo images::Receipt -data "\
	R0lGODlhIAAgAOcAAAICAhJWghpWemaevpK6zgIGCvb29oqKisa+tEZGRgYu
	Wh5umt7Wxo6eonp2djIyMqKel1ZWVg5Oeuru8sra4uLKor6ecCZynr6mgwo6
	Xi56ou7m1wIKEg5qmqTC0tLa4i4uLubWuL7S3qqimQYOFq6urObezlqGnrLO
	2kaCouLi4t7SwZ6aksK6qg5ejgIaKhBKfIaCfj5abipSdoamuvr6+VaSrtLG
	tnKmwq7CzhpmlCYmJvLq3wpGcB5SgcCulOTaympqai5ulgYeQsbGxDY2NrKq
	nU5OTlqWtrqyopeWkYCuxs7S0uLe1g5mmOLWxubSsgYmSZqywgZCbh5ikCZK
	XuTq7GqKmjpylsaymmJiYsG6rzqGrtna2hpCahYySurave7iy462ysKyniJ2
	osLCwvLu5Kail8rOzr6qkj4+PnqethpSfu7m3kyGpgo2Wwo6Yg5ilP7+/g5a
	isaujjZmhrq6upaOhp6enl5eXubOqb6ifPry6u7u7qSioiZWctzi5h5Kdp66
	yiZmjhJCXsrKyrq2soiuxO7exgo+ZhNqmhZejuzq6L7O2urm3kR2lO7avr6q
	jA5ekgYqSLayqNLi6qrK2lJSUm6SqvLizkpKSl5aVreqld7a2vbu6qqmpura
	yubm5Ly2rOrezgpSguraxt7a0PLq2Ori0gY+bgYqUhJGbube2oKerhZmltLO
	wsK2qLq+wBRunkGGrQ5CaureygYyXmKattLSzg4+aubaxurWtgYyVwY2YtLK
	umaOpiJafqainvLm1+rSshpags7e4lWWtgYiQEJCQr6eduLa0rqyqQ5SgRpy
	osKyljo6OjqKrsK2oPLy8Kamot7e2vby7uri2ICisg5WiPbu5QoqStbKuubO
	rurWutrWzr66tvr28g5GcMKqiBJekgo+ah5Wgg5ajmaivn56dsLW4lqKoq7G
	1pq2yiJ6op6+0qaemubKoqKalO7eyu7awsKmggpCbd7Wy+7i0t7SxsrS2gYq
	TgYiRgpCcrbO2MrGxv///yH5BAEKAP8ALAAAAAAgACAAAAj+AP8JHDgwQoRL
	RzRpSoBMjZpnRR6AAECwokWBEQppLERkI5EydkrgSUDxoslLROSoXLnSgApv
	CQ6UNFkxI8ubclxqKhRjJk2BlwrhvGngiJxCMn8KJEcuUb2nE4bKuaSSp8+K
	5OrFQuMtn5RWTg3gzEOtalKLiQpRq1SMgoh1gmj8qseoBkstRABV7VmxHpMJ
	lVC4W2LMGJdZbh6lUiFWZZAjRxIwfPZgZqJYViisW2JDpawOigZdGFSPscoa
	1HDZgRDDwaaS9Rp8SEfgHBeWkiS5GLdIwCrTcmqEokaEkh8HJWnlSOdhAJdm
	HVTGcWHO3Jw5zGiVUQEuuDQV1F7+UbpD8c2VRiiWcGnXwcl0c9Rzu8DWYwYa
	RuBqVGPEyturdxQlck0/YiBBRgdx6KYbfC7klh05dnQhDR/VZOOICaYYEWAr
	7uAwiyxO3OSKgpJgQw4cJRDhSIU8WIMKA5xQlAomgtxChitxJLjSdLlJIgEc
	cHxiBzXZVMPDBibUouE/iZxwiA1kONGgJCuZ06MLErzxRjCGmMKDGadsgIou
	P1AEwCNrpLAAdS64UCV8JfagwBdnGGLPKafwIE8tusT4DwB/qJOCDpJUZ85K
	2CSKDTOJKFDFO5R4I4wwG2RSSyl+/lkHFotchw0VK5FCCjMS1NPLC/GcsQwD
	G0waRin+YIhTEgCEABMAKdgMxUY9b2gjgxJnbPFEGGEggsg8IWAwEwAZ9BAO
	DOVEW44PPrDhxSTHkMBCPEbcoMs98iBSSjdQROITALxklcq6qcDRiwKqDAEA
	HvGM8A0D8hSLCBghJHsVAPsowEsvvNhiSxTHHMNBPMAm4W0tkNTSTQjk7nHV
	nwAAMEkUHGdcwB0QjJDENiEUCwkY5HIDhcUmZezyJCwoEXISvugSxjxggLHL
	LsMMUwHLJu1wQDAQFH2GEdH4EsI8iJwcAhTc6KHHzxcPBAIehixDCSVb3LAC
	KIhcSu4wUEAxNTwWVC3QA0Pag88KDABRSy3znDxx1BXAU0EsBWnTBEIZLbQA
	SzTRjJFFFj+Io/ge9OyRTDIWRK72PxO5bPnlmLus1OY0BQQAOw==
	===="
image create photo images::Run -data "\
	R0lGODlhIAAgAMYAAAAAANnZ2fX19ZWVlenp6eXl5bq6un5+frW1tXp6eoqK
	iq2traWlpVJSUrKysnV1dUJCQqKiooWFhUVFRe3t7d3d3Z2dnZqamuLi4sXF
	xUpKSgICAvLy8tXV1eHh4YKCgoaGhjIyMtLS0s3NzcrKysHBwXJyciUlJZ6e
	ntra2r29vW5ubiIiIg4ODsbGxr6+vioqKqqqqsnJyZKSknl5eVFRUVpaWn19
	fcLCwgoKCk5OTg0NDQYGBjo6OhISEk1NTba2tqmpqY2NjR0dHV1dXbm5uWpq
	amVlZUZGRj4+PhoaGjY2NhUVFXZ2djU1NRYWFmJiYh4eHpGRkVVVVf//////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4SEAIcAhYqLjH8AAQIBA4mNlYoABAUGB5SWno6Z
	m52fgoijmAUICaeIjQAKCwgMlAANmQ4PELQRERITo4YLFAQVFocDFwUYGQwK
	CocWAQEOGhuMAA7EFQIWCwIcFR0dFR4VHxEBGRkgIdaLAAwVGPIcFBUVAR0i
	+yPhIyQlTJxw9w4FOHL3UogTMeJfQxIqVrBoYQmABQ4YFC7k98+FixcWYAB7
	t0BbihEOIqCIgeCFCxkZVFiYcKLiDAEpcqKkUUODjRsOXuAYamAGjByXEOm4
	IKCCQgc0NOzYwKNHBANDVSCwEGKHj6+JANwgQDZTOHERfuygFcJAiRf+BoDE
	AKHgQpAgCw4JKVDArEYREWoQ/DNkREwDCBzcXcDYGIAPBuICyZCCHwMiPAid
	SCFDRREECy4I+XDgwINDRkrTeBChMkMEN3pQgrACA4m4Di4cQQKhd5KwiCAo
	8PDwxYIIIYbAMBFJqwMGCYZsmL5h5KsKDzOUMKCCRAcPKTwjkGVDychCj7GT
	yIBDaIaXWhNHiH4efYwO69njUMEfSGIHz32wBBMVxbAMeyWUoAJckckXwwIM
	NOHEE644gIELMT1YBGKfLRADdCDE4EAMRsAwmCEWZmDACkhAMcNKoF3QBBFD
	TKAAAyMaceIgAAyAgAQm/AKABj/QEIEFRwxGYZ4SEEjAAAM6XnMEFDroUsoQ
	DzAgRDWURLGEBBKs4korPEoRgwJIjEJdfZVg44AUU7BJCo8AwinnnI6o0EsD
	d+JpCimBAAA7
	===="
image create photo images::Support -data "\
	R0lGODlhIAAgAMYAAAAAAFpaXP////769f716f7w3f7r0f7mxf7hub6+vMDA
	wP706f7y4f7t1v7oyv7jvv7esv7Zpv7o1P7lzf7qzv7lwv7gt/7bq/7XpPf3
	9/7u3/7iu/7dr/7buf7aqFhYWP7NoP7Ah/69gP66ev6zbf6oWoAAAP/cqP6m
	U/6hSv6dQv6ZOv6VMv6RKkwCAv6jTf6fRf6bPf6XNf6TLf6PJf+AAP6gSP6c
	QP6YOP6UL/6QJ/6MH/6NIv6JGv5+BNjY2Orq6v//////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////yH5BAEKAH8A
	LAAAAAAgACAAAAf+gH+Cg4MAhIIAiYqGh42HAAGJhQIDBAUGBwiMjo6QCQqS
	AAsCDA0ODxARm5yFCgEJAgKgABITAhQVFhcYGKusABmvsbGzGgIbHLy8vo0A
	CsGww8QAHQIeysusf8DQ0sMKHwAC2Nmdz93eH+EgIePkzNsZ8sLfHwqgISIj
	7ti+zvLoBKiLBUAfCRIlvBEkxG0eLHAKppEwUaLiCRQpVKxg0WLTP4CvBg5z
	4aKECYolTryAEUPGDBoeATqM+A1ASRM1KJ6wcQNHDh07GH0EGW2YTYs1cp7Q
	yJFHD6EyHUoDVRJpzpMnJW07J5MeQRcorSZNGjNqMJqyjlZce8KH27emhiAF
	mEv3QwC0icKuTXmir99ECQILHjwNQNiwFzNu7Ljth2PHd38Y3bb3pMWVLV/G
	VQCkM5C7NSmvxamTp0+gQj1/xoto74mkJpYudiqUc2fQaVu7ho3VhFZEnnGv
	ArA35dix/myDBvWoeNu3bv3djgiPuGu/fxlyvsu8k2uMTBkzXA2vEFvMLmE+
	ctX9l0XTP4M2i6TNvOymT+eXb7ZIEaf99RESCAA7
	===="

## Additional mouse bindings to make the wheel work.
bind all <ButtonPress-4> { event generate %W <MouseWheel> -delta 120 }
bind all <ButtonPress-5> { event generate %W <MouseWheel> -delta -120 }

