##############################################################################
#
# Copyright (c) 2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: wizard_group.py 3184 2006-05-17 15:01:56Z ged $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import time

import wizard
import netsvc
from osv.osv import osv_pools

merge_form = """<?xml version="1.0"?>
<form string="Merge orders">
	<separator string="Are you sure you want to merge these orders ?" />
</form>
"""

merge_fields = {
}

ack_form = """<?xml version="1.0"?>
<form string="Merge orders">
	<separator string="Orders merged"/>
</form>"""

ack_fields = {}

def _mergeOrders(self, cr, uid, data, context):
	order_obj = osv_pools.get('purchase.order')

	# compute what the new orders should contain
	new_orders = {}
	for porder in [order for order in order_obj.browse(cr, uid, data['ids']) if order.state == 'draft']:
		new_order = new_orders.setdefault(porder.partner_id.id, ({}, []))
		new_order[1].append(porder.id)
		order_infos = new_order[0]
		if not order_infos:
			order_infos['name'] = 'Merge: %s' % porder.name
			
			order_infos['origin'] = porder.origin
			
			order_infos['date_order'] = time.strftime('%Y-%m-%d')
			order_infos['partner_id'] = porder.partner_id.id
			order_infos['partner_address_id'] = porder.partner_address_id.id

			order_infos['dest_address_id'] = porder.dest_address_id.id
			order_infos['warehouse_id'] = porder.warehouse_id.id
			order_infos['location_id'] = porder.location_id.id
			
			order_infos['project_id'] = porder.project_id.id
			order_infos['pricelist_id'] = porder.pricelist_id.id

			order_infos['state'] = 'draft'
			order_infos['order_line'] = {}
			order_infos['notes'] = '%s\n%s\n\n%s' % (porder.name, '-' * len(porder.name), porder.notes)
		else:
			order_infos['name'] += ', %s' % porder.name
			order_infos['notes'] += '\n\n%s\n%s\n\n%s' % (porder.name, '-' * len(porder.name), porder.notes)

		nbr_line_wo_product = 0
		for order_line in porder.order_line:
			if order_line.product_id:
				key = order_line.product_id.id
			else:
				key = -nbr_line_wo_product
				nbr_line_wo_product += 1
				
			new_oline = order_infos['order_line'].setdefault(key, {})
			if not new_oline:
				new_oline['name'] = order_line.name
				new_oline['product_qty'] = order_line.product_qty
				new_oline['date_planned'] = order_line.date_planned
				new_oline['taxes_id'] = order_line.taxes_id
				new_oline['product_uom'] = order_line.product_uom.id
				new_oline['uom_factor'] = order_line.product_uom.factor
				if order_line.product_id:
					new_oline['product_id'] = order_line.product_id.id
				new_oline['price_unit'] = order_line.price_unit
				new_oline['notes'] = order_line.notes
			else:
				new_oline['product_qty'] += order_line.product_qty * order_line.product_uom.factor / new_oline['uom_factor']

	wf_service = netsvc.LocalService("workflow")

	for partner_id, (order_data, old_ids) in new_orders.iteritems():
		# cleanup order data
		for line in order_data['order_line'].itervalues():
			del line['uom_factor']
		order_data['order_line'] = [(0, 0, val) for val in order_data['order_line'].itervalues()]
		
		# create the new order
		neworder_id = order_obj.create(cr, uid, order_data)

		# cancel the old orders (and move their triggers to the new order they are in)
		for old_id in old_ids:
			wf_service.trg_validate(uid, 'purchase.order', old_id, 'purchase_cancel', cr)
			wf_service.trg_merge(uid, 'purchase.order', old_id, neworder_id, cr)

	return {}

class merge_orders(wizard.interface):
	states = {
		'init' : {
			'actions' : [],
			'result' : {'type' : 'form', 'arch' : merge_form, 'fields' : merge_fields, 'state' : [('end', 'Cancel'),('merge', 'Merge orders') ]}
		},
		'merge' : {
			'actions' : [_mergeOrders],
			'result' : {'type' : 'form', 'arch' : ack_form, 'fields' : ack_fields, 'state' : [('end', 'Done')]}
		},
	}
merge_orders("purchase.order.merge")
