##############################################################################
#
# Copyright (c) 2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import ir
import time
import os
import netsvc
import xmlrpclib
import netsvc

import wizard
from osv import osv

_export_form = '''<?xml version="1.0"?>
<form title="Initial import" />
'''

_export_fields = {}

_export_done_form = '''<?xml version="1.0"?>
<form title="Initial import">
<separator string="Products succesfully exported" colspan="4" />
</form>'''

_export_done_fields = {}

def _do_export(self, cr, uid, data, context):
	website=osv.osv_pools.get('oscommerce.web').browse(cr, uid, [data['id']])[0]
	pricelist=ir.ir_get(cr,uid, 'meta','product.pricelist',[('res.partner',website.partner_anonymous_id.id)])[0][2]
	print "%s/tinyerp-syncro.php" % website.url
	server = xmlrpclib.ServerProxy("%s/tinyerp-syncro.php" % website.url)

	for osc_product in website.product_ids:
		print "sending product %s" % osc_product.name
		service = netsvc.LocalService("object_proxy")
		attachs = service.execute(uid, 'ir.attachment', 'search', [('res_model','=','product.product'), ('res_id', '=',osc_product.product_id.id)])
		data = service.execute(uid, 'ir.attachment', 'read', attachs)
			
		webproduct={	'oscommerce_id'	: osc_product.oscommerce_id,
						'quantity'		: osv.osv_pools.get('product.product')._product_virtual_available(cr, uid, [osc_product.product_id.id], '', False, {'shop':website.shop_id.id})[osc_product.product_id.id],
						'model'			: osc_product.product_id.code,
						'price'			: osv.osv_pools.get('product.pricelist').price_get(cr, uid, [pricelist], osc_product.product_id.id, 1, 'list')[pricelist],
						'weight'		: float(osc_product.product_id.weight),
						'tax_class_id'	: osc_product.oscommerce_tax_id.oscommerce_id,
#						'tax_class_id'	: 1,
						'category_id'	: osc_product.oscommerce_category_id.oscommerce_id,
					}
			
		if len(data):
			webproduct['haspic'] = 1
			webproduct['picture'] = data[0]['datas']
			webproduct['fname'] = data[0]['datas_fname']
		else:
			webproduct['haspic'] =0
		
		langs={}
		products_pool=osv.osv_pools.get('product.product')
		for lang in website.language_ids:
			if lang.language_id and lang.language_id.translatable:
				langs[str(lang.oscommerce_id)] = {	'name'			: products_pool.read(cr, uid, [osc_product.product_id.id], ['name'], {'lang': lang.language_id.code})[0]['name'],
												'description'	: products_pool.read(cr, uid, [osc_product.product_id.id], ['description_sale'], {'lang': lang.language_id.code})[0]['description_sale']
											}

		webproduct['langs'] = langs
		webproduct['name'] = str(osc_product.product_id.name)
		webproduct['description'] = str(osc_product.product_id.description_sale)

		print str(webproduct)

		osc_id=server.set_product(webproduct)

		if osc_id!=osc_product.oscommerce_id:
			osv.osv_pools.get('oscommerce.product').write(cr, uid, [osc_product.id], {'oscommerce_id': osc_id})
			cr.commit()

	return {}

class wiz_oscommerce_products(wizard.interface):

	states = {	'init'	: {	'actions'	: [_do_export],
							'result'	: {	'type'	: 'form',
											'arch'	: _export_done_form,
											'fields': _export_done_fields,
											'state'	: [('end', 'End')]
											}
							}
				}


wiz_oscommerce_products('oscommerce.products');
