##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: sale.py 1005 2005-07-25 08:41:42Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import netsvc
from osv import fields,osv,orm
import ir

import time
from mx import DateTime

class oscommerce_web(osv.osv):
	_name = "oscommerce.web"
	_description = "eCommerce Website"
	_columns = {
		'name': fields.char('Name',size=64, required=True),
		'url': fields.char('URL', size=64, required=True),
		'shop_id': fields.many2one('sale.shop', 'Sale Shop', required=True),
		'partner_anonymous_id': fields.many2one('res.partner', 'Anonymous', required=True),
		'active': fields.boolean('Active'),
#		'product_all': fields.boolean('All product'),
		'product_ids': fields.one2many('oscommerce.product', 'web_id', 'Web Products'),
		'language_ids': fields.one2many('oscommerce.lang', 'web_id', 'Languages'),
		'tax_ids': fields.one2many('oscommerce.tax', 'web_id', 'Taxes'),
		'category_ids': fields.one2many('oscommerce.category', 'web_id', 'Categories'),
	}
	_defaults = {
#		'product_all': lambda *a: 1,
		'active': lambda *a: 1
	}
oscommerce_web()

class oscommerce_tax(osv.osv):
	_name = "oscommerce.tax"
	_description = "osCommerce Tax"
	_columns = {	'name'			: fields.char('Tax name', size=32, required=True),
					'oscommerce_id'	: fields.integer('osCommerce id'),
					'web_id'		: fields.many2one('oscommerce.web', 'Website')
				}
oscommerce_tax()

class oscommerce_category(osv.osv):
	_name = "oscommerce.category"
	_description = "osCommerce Category"
	_columns = {	'name'				: fields.char('Name', size=64, reuired=True),
					'oscommerce_id'		: fields.integer('osCommerce ID', required=True),
					'web_id'			: fields.many2one('oscommerce.web', 'Website')
				}
oscommerce_category()

class oscommerce_product(osv.osv):
	_name = "oscommerce.product"
	_description = "osCommerce Product"
	_columns = {	'web_id'			: fields.many2one('oscommerce.web', 'Web Ref'),
					'name'				: fields.char('Name', size=64, required=True),
					'product_id'		: fields.many2one('product.product', 'Product', required=True),
					'oscommerce_id'		: fields.integer('osCommerce product id'),
					'oscommerce_category_id': fields.many2one('oscommerce.category', 'osCommerce category'),
					'oscommerce_tax_id'	: fields.many2one('oscommerce.tax', 'osCommerce tax'),
				}

	def onchange_product_id(self, cr, uid, ids, product_id, web_id):
		value={}
		if (product_id):
			#and web_id):
			product=self.pool.get('product.product').browse(cr, uid, product_id)
			#web=self.pool.get('oscommerce.web').browse(cr, uid, web_id)
			value['name']=product.name
		return {'value': value}
oscommerce_product()

class oscommerce_language(osv.osv):
	_name = "oscommerce.lang"
	_description = "osCommerce Language"
	_columns = {	'name'			: fields.char('Name', size=32, required=True),
					'oscommerce_id'	: fields.integer('osCommerce ID', required=True),
					'language_id'	: fields.many2one('res.lang', 'Language'),
					'web_id'		: fields.many2one('oscommerce.web', 'Website')
				}
oscommerce_language()

class oscommerce_saleorder(osv.osv):
	_inherit='sale.order'
	_name='sale.order'
	_table='sale_order'
	_columns = {	'oscommerce_web': fields.many2one('oscommerce.web', 'Website'),
					'oscommerce_id'	: fields.integer('osCommerce Id', required=True),
				}
	_defaults = {	'oscommerce_id'	: lambda *a: 0,
				}

	def onchange_oscommerce_web(self, cr, uid, ids, oscommerce_web):
		value={}
		if oscommerce_web:
			web=self.pool.get('oscommerce.web').browse(cr, uid, oscommerce_web)
			value['shop_id']=web.shop_id.id
			value['partner_id']=web.partner_anonymous_id.id
			value.update(self.pool.get('sale.order').onchange_shop_id(cr, uid, ids, value['shop_id'])['value'])
			value.update(self.pool.get('sale.order').onchange_partner_id(cr, uid, ids, value['partner_id'])['value'])

		return {'value':value}

	def order_create(self, cr, uid, ids, context={}):
		for order in self.browse(cr, uid, ids, context):
			addr = self.pool.get('res.partner').address_get(cr, uid, [order.partner_id.id], ['delivery','invoice','contact'])
			pricelist_id=ir.ir_get(cr, uid, 'meta','product.pricelist',[('res.partner',order.partner_id.id)])[0][2]
			order_lines = []
			for line in order.order_lines:
				order_lines.append( (0,0,{
					'name': line.name,
					'product_qty': line.product_qty,
					'date_planned': line.date_planned,
					'product_id': line.product_id.id,
					'product_uom': line.product_uom.id,
					'price_unit': line.price_unit,
					'type': line.product_id.procure_method
				 }) )
			order_id = self.pool.get('sale.order').create(cr, uid, {
				'name': order.name,
				'shop_id': order.web_id.shop_id.id,
				'origin': 'WEB:'+str(order.id),
				'date_order': order.date_order,
				'user_id': uid,
				'partner_id': order.partner_id.id,
				'partner_invoice_id':addr['invoice'],
				'partner_order_id':addr['contact'],
				'partner_shipping_id':addr['delivery'],
				'pricelist_id': pricelist_id,
				'order_line': order_lines
			})
			self.write(cr, uid, [order.id], {'state':'done', 'order_id': order_id})
			wf_service = netsvc.LocalService("workflow")
			wf_service.trg_validate(uid, 'sale.order', order_id, 'order_confirm', cr)
		return True

oscommerce_saleorder()

#
# Note de Fabien; c'est bugge, cela remplace les champs pour la sale.order normal.
#	_table='oscommerce_sale_order_line'
#
class oscommerce_saleorder_line(osv.osv):
	_name='oscommerce.saleorder.line'
	_inherit='sale.order.line'
	_table='sale_order_line'
	_columns = {	'order_id'		: fields.many2one('oscommerce.saleorder', 'Order Ref', required=True),
					'oscommerce_id'	: fields.integer('osCommerce Id')
				}
oscommerce_saleorder_line()
