-------------------------------------------------------------------------
-- Pure SQL
-------------------------------------------------------------------------

CREATE TABLE perm (
    id serial NOT NULL,
    level smallint DEFAULT 4 NOT NULL,
    uid int default null,
    gid int default null,
    primary key(id)
);
insert into perm (id,uid,gid) values (1,1,1);

CREATE TABLE inherit (
    obj_type varchar(128) not null,
    obj_id int not null,
    inst_type varchar(128) not null,
    inst_id int not null
);

-------------------------------------------------------------------------
-- IR dictionary
-------------------------------------------------------------------------

create table ir_values
(
    id serial,
    perm_id int references perm on delete set null,
    name varchar(128) not null,
    key varchar(128) not null,
    key2 varchar(128) not null,
    model varchar(128) not null,
    value text,
    meta text default NULL,
    res_id integer default null,
    primary key (id)
);

-------------------------------------------------------------------------
-- Modules Description
-------------------------------------------------------------------------

CREATE TABLE ir_model (
  id serial,
  model varchar(64) DEFAULT ''::varchar NOT NULL,
  name varchar(64),
  primary key(id)
);

CREATE TABLE ir_model_fields (
  id serial,
  model varchar(64) DEFAULT ''::varchar NOT NULL,
  model_id int references ir_model,
  name varchar(64) DEFAULT ''::varchar NOT NULL,
  relation varchar(64),
  field_description varchar(256),
  ttype varchar(64),
  relate boolean default False,
  primary key(id)
);

-------------------------------------------------------------------------
-- Actions
-------------------------------------------------------------------------

CREATE TABLE ir_actions (
    id serial NOT NULL,
    perm_id int references perm on delete set null,
    name varchar(64) DEFAULT ''::varchar NOT NULL,
    "type" varchar(64) DEFAULT 'window'::varchar NOT NULL,
    usage varchar(32) DEFAULT null,
    primary key(id)
);

CREATE TABLE ir_act_window (
    view_id integer,
    res_model varchar(64),
    view_type varchar(16),
    "domain" varchar(127),
    primary key(id)
)
INHERITS (ir_actions);

CREATE TABLE ir_act_report_xml (
    model varchar(64) NOT NULL,
    report_name varchar(64) NOT NULL,
    report_xsl varchar(64),
    report_xml varchar(64),
	auto boolean default true
)
INHERITS (ir_actions);

create table ir_act_report_custom (
    report_id int
--  report_id int references ir_report_custom
)
INHERITS (ir_actions);

CREATE TABLE ir_act_group (
    exec_type varchar(64) DEFAULT 'serial'::varchar NOT NULL
)
INHERITS (ir_actions);

CREATE TABLE ir_act_group_link (
    aid integer NOT NULL,
    gid integer NOT NULL
);

CREATE TABLE ir_act_execute (
    func_name varchar(64) NOT NULL,
    func_arg varchar(64)
)
INHERITS (ir_actions);

CREATE TABLE ir_act_wizard (
    wiz_name varchar(64) NOT NULL
)
INHERITS (ir_actions);

CREATE TABLE ir_ui_view (
	id serial NOT NULL,
	perm_id int references perm on delete set null,
	name varchar(64) DEFAULT ''::varchar NOT NULL,
	model varchar(64) DEFAULT ''::varchar NOT NULL,
	"type" varchar(64) DEFAULT 'form'::varchar NOT NULL,
	arch text NOT NULL,
	field_parent varchar(64),
	priority integer DEFAULT 5 NOT NULL,
	primary key(id),
	CONSTRAINT ir_ui_view_type CHECK (((("type")::text = ('form'::varchar)::text) OR (("type")::text = ('tree'::varchar)::text)))
);

CREATE TABLE ir_ui_menu (
	id serial NOT NULL,
	perm_id int references perm on delete set null,
	parent_id int references ir_ui_menu on delete set null,
	name varchar(64) DEFAULT ''::varchar NOT NULL,
	icon varchar(64) DEFAULT ''::varchar,
	primary key (id)
);

select setval('ir_ui_menu_id_seq', 2);

---------------------------------
-- Res users
---------------------------------

-- level:
--   0  RESTRICT TO USER
--   1  RESTRICT TO GROUP
--   2  PUBLIC

CREATE TABLE res_users (
    id serial NOT NULL,
    perm_id int references perm on delete set null,
    name varchar(64) not null,
    login varchar(64) NOT NULL UNIQUE,
    password varchar(32) default null,
    perm_default int references perm on delete set null,
--  action_id int references ir_act_window on delete set null,
    action_id int,
    primary key(id)
);
insert into res_users (id,login,password,name,action_id,perm_id) values (1,'root',NULL,'Administrator',NULL,1);
select setval('res_users_id_seq', 2);


CREATE TABLE res_groups (
    id serial NOT NULL,
    perm_id int references perm on delete set null,
    name varchar(32) NOT NULL,
    primary key(id)
);

create table res_roles (
    id serial NOT NULL,
    perm_id int references perm on delete set null,
    parent_id int references res_roles on delete set null,
    name varchar(32) NOT NULL,
    primary key(id)
);

CREATE TABLE res_roles_users_rel (
	uid integer NOT NULL references res_users on delete cascade,
	rid integer NOT NULL references res_roles on delete cascade
);

CREATE TABLE res_groups_users_rel (
	uid integer NOT NULL references res_users on delete cascade,
	gid integer NOT NULL references res_groups on delete cascade
);

---------------------------------
-- Workflows
---------------------------------

create table wkf
(
    id serial,
    perm_id int references perm on delete set null,
    name varchar(64),
    osv varchar(64),
    on_create bool default False,
    primary key(id)
);

create table wkf_activity
(
    id serial,
    perm_id int references perm on delete set null,
    wkf_id int references wkf on delete cascade,
    subflow_id int references wkf on delete set null,
    split_mode varchar(3) default 'XOR',
    join_mode varchar(3) default 'XOR',
    kind varchar(16) not null default 'dummy',
    name varchar(64),
    signal_send varchar(32) default null,
    flow_start boolean default False,
    flow_stop boolean default False,
    action varchar(64) default null,
    primary key(id)
);

create table wkf_transition
(
    id serial,
    perm_id int references perm on delete set null,
    act_from int references wkf_activity on delete cascade,
    act_to int references wkf_activity on delete cascade,
    condition varchar(128) default NULL,

    trigger_type varchar(128) default NULL,
    trigger_expr_id varchar(128) default NULL,

    signal varchar(64) default null,
    role_id int references res_roles on delete set null,

    primary key(id)
);

create table wkf_instance
(
    id serial,
    wkf_id int references wkf on delete set null,
    uid int default null,
    res_id int not null,
    res_type varchar(64) not null,
    state varchar(32) not null default 'active',
    primary key(id)
);

create table wkf_workitem
(
    id serial,
    act_id int not null references wkf_activity on delete cascade,
    inst_id int not null references wkf_instance on delete cascade,
    subflow_id int references wkf_instance on delete cascade,
    state varchar(64) default 'blocked',
    primary key(id)
);

create table wkf_witm_trans
(
    trans_id int not null references wkf_transition on delete cascade,
    inst_id int not null references wkf_instance on delete cascade
);

create table wkf_logs
(
    id serial,
    res_type varchar(128) not null,
    res_id int not null,
    uid int references res_users on delete set null,
    act_id int references wkf_activity on delete set null,
    time time not null,
    info varchar(128) default NULL,
    primary key(id)
);
