#----------------------------------------------------------
# Convert 
#----------------------------------------------------------
import re
import StringIO,xml.dom.minidom
import osv,ir,sql_db

import csv

from config import config

class ConvertError(Exception):
	def __init__(self, doc, orig_excpt):
		self.d = doc
		self.orig = orig_excpt
	
	def __str__(self):
		return 'Exception:\n\t%s\nUsing file:\n%s' % (self.orig, self.d)

# csv
def convert_csv_import(model,input, default={}):
	input=StringIO.StringIO(input)
	pool=osv.osv.osv_pools
	cr=sql_db.db.cursor()
	uid=1
	reader = csv.reader(input)
	for row in reader:
		f=row
		break
	for row in reader:
		dic={}
		dic.update(default)
		for i in range(len(f)):
			if pool.get(model)._columns[f[i]]._type=='integer':
				row[i] = (row[i] and int(row[i])) or False
			elif pool.get(model)._columns[f[i]]._type=='float':
				row[i] = (row[i] and float(row[i])) or False
			elif pool.get(model)._columns[f[i]]._type=='many2one':
				res = pool.get(obj).name_search(cr, uid, row[i], [], '=')
				dic[f[i]] = False
				if len(res):
					dic[f[i]] = res[0][0]
			dic[f[i]]=row[i]
		pool.get(model).create(cr,uid,dic)
	cr.commit()
	cr.close()

def convert_csv_export(csv):
	pass

def _eval_xml(node, pool, cr, uid, idref):
	if node.nodeType == node.ELEMENT_NODE and (node.nodeName in ('field','value')):
		t = node.getAttribute('type') or 'char'
		if len(node.getAttribute('search')):
			f_search=node.getAttribute("search").encode('ascii')
			f_model=node.getAttribute("model").encode('ascii')
			f_use=node.getAttribute("use").encode('ascii')
			f_name=node.getAttribute("use").encode('ascii')
			if len(f_use)==0:
				f_use="id"
			q=eval(f_search,idref)
			ids=pool.get(f_model).search(cr,uid,q)
			if f_use<>'id':
				ids=map(lambda x: x[f_use], pool.get(f_model).read(cr,uid,ids,[f_use]))
			_cols = pool.get(f_model)._columns
			if (f_name in _cols) and _cols[f_name]._type=='many2many':
				return ids
			f_val = False
			if len(ids):
				f_val=ids[0]
				if isinstance(f_val,tuple):
					f_val=f_val[0]
			return f_val
		a_eval=node.getAttribute('eval')
		if len(a_eval):
			import time
			idref['time'] = time
			return eval(a_eval,idref)
		if t == 'xml':
			txt = '<?xml version="1.0"?>\n'+"".join([i.toxml().encode("utf8") for i in node.childNodes]) % idref
			return txt
		if t in ('char','int','float'):
			d=""
			for n in [i for i in node.childNodes]:
				d+=str(_eval_xml(n,pool,cr,uid,idref))
			if t=='int':
				d=d.strip()
				if d=='None':
					return None
				else:
					d=int(d.strip())
			elif t=='float':
				d=float(d.strip())
			return d
		elif t in ('list','tuple'):
			res=[]
			for n in [i for i in node.childNodes if (i.nodeType == i.ELEMENT_NODE and i.nodeName=='value')]:
				res.append(_eval_xml(n,pool,cr,uid,idref))
			if t=='tuple':
				return tuple(res)
			return res
	elif node.nodeType == node.ELEMENT_NODE and node.nodeName=="getitem":
		for n in [i for i in node.childNodes if (i.nodeType == i.ELEMENT_NODE)]:
			res=_eval_xml(n,pool,cr,uid,idref)
		if not res:
			raise LookupError
		elif node.getAttribute('type') in ("int","list"):
			return res[int(node.getAttribute('index'))]
		else:
			return res[node.getAttribute('index').encode("utf8")]
	elif node.nodeType == node.ELEMENT_NODE and node.nodeName=="function":
		args=[]
		a_eval=node.getAttribute('eval')
		if len(a_eval):
			args = eval(a_eval,idref)
		for n in [i for i in node.childNodes if (i.nodeType == i.ELEMENT_NODE)]:
			args.append(_eval_xml(n, pool, cr, uid, idref))
		model=pool.get(node.getAttribute('model'))
		method=node.getAttribute('name')
		res = getattr(model,method)(cr,uid,*args)
		return res
	elif node.nodeType == node.TEXT_NODE:
		return node.data.encode("utf8")

escape_re = re.compile(r'(?<!\\)/')
def escape(x):
	return x.replace('\\/', '/')

class xml_import(object):
	def _tag_delete(self, cr, rec, data_node=None):
		d_model = rec.getAttribute("model")
		d_search = rec.getAttribute("search")
		ids = self.pool.get(d_model).search(cr,self.uid,eval(d_search))
		if len(ids):
			self.pool.get(d_model).unlink(cr, self.uid, ids)
			#self.pool.get('ir.model.data')._unlink(cr, self.uid, d_model, ids, direct=True)
		return False

	def _tag_report(self, cr, rec, data_node=None):
		res = {}
		for dest,f in (('name','string'),('model','model'),('report_name','name')):
			res[dest] = rec.getAttribute(f).encode('utf8')
			assert res[dest], "Attribute %s of report is empty !" % (f,)
		for field,dest in (('rml','report_rml'),('xml','report_xml'),('xsl','report_xsl')):
			if rec.hasAttribute(field):
				res[dest] = rec.getAttribute(field).encode('utf8')
		if rec.hasAttribute('auto'):
			res['auto'] = eval(rec.getAttribute('auto'))
		xml_id = rec.getAttribute('id').encode('utf8')
		id = self.pool.get('ir.model.data')._update(cr, self.uid, "ir.actions.report.xml", self.module, res, xml_id, mode=self.mode)
		self.idref[xml_id] = id
		if not rec.hasAttribute('menu') or eval(rec.getAttribute('menu')):
			keyword = str(rec.getAttribute('keyword') or 'client_print_multi')
			keys = [('action',keyword),('res_model',res['model'])]
			value = 'ir.actions.report.xml,'+str(id)
			replace = rec.hasAttribute('replace') and rec.getAttribute("replace")
			ir.ir_set(cr, self.uid, 'action', keyword, res['name'], [res['model']], value, replace=replace, isobject=True)
		return False

	def _tag_function(self,cr,rec, data_node=None):
		_eval_xml(rec, self.pool, cr, self.uid, self.idref)
		return False

	def _tag_wizard(self,cr, rec, data_node=None):
		string = rec.getAttribute("string").encode('utf8')
		model = rec.getAttribute("model").encode('utf8')
		name = rec.getAttribute("name").encode('utf8')
		xml_id = rec.getAttribute('id').encode('utf8')
		res = {'name': string, 'wiz_name': name}

		id = self.pool.get('ir.model.data')._update(cr, self.uid, "ir.actions.wizard", self.module, res, xml_id, mode=self.mode)
		self.idref[xml_id] = id
		# ir_set
		if not rec.hasAttribute('menu') or eval(rec.getAttribute('menu')):
			keyword = str(rec.getAttribute('keyword') or 'client_action_multi')
			keys = [('action',keyword),('res_model',model)]
			value = 'ir.actions.wizard,'+str(id)
			replace = rec.hasAttribute('replace') and rec.getAttribute("replace")
			ir.ir_set(cr, self.uid, 'action', keyword, string, [model], value, replace=replace, isobject=True)
		return False

	def _tag_ir_set(self, cr, rec, data_node=None):
		res = {}
		for field in  [i for i in rec.childNodes if (i.nodeType == i.ELEMENT_NODE and i.nodeName=="field")]:
			f_name = field.getAttribute("name").encode('ascii')
			f_val = _eval_xml(field,self.pool, cr, self.uid, self.idref)
			res[f_name] = f_val
		ir.ir_set(cr, self.uid, res['key'], res['key2'], res['name'], res['models'], res['value'], replace=res.get('replace',True), isobject=res.get('isobject', False), meta=res.get('meta',None))
		return False

	def _tag_workflow(self, cr, rec, data_node=None):
		import netsvc
		model = str(rec.getAttribute('model'))
		wf_service = netsvc.LocalService("workflow")
		wf_service.trg_validate(self.uid, model,
			self.id_get(cr, model, rec.getAttribute('ref')),
			str(rec.getAttribute('action')), cr)
		return False

	def _tag_menuitem(self, cr, rec, data_node=None):
		rec_id = rec.getAttribute("id").encode('ascii')
		m_l = map(escape, escape_re.split(rec.getAttribute("name").encode('utf8')))
		pid = False
		for i in range(len(m_l)):
			if pid:
				cr.execute('select * from ir_ui_menu where parent_id=%d and name=%s', (pid,m_l[i]))
			else:
				cr.execute('select * from ir_ui_menu where parent_id is null and name=%s', (m_l[i],))
			res = cr.fetchone()
			if res:
				pid = res[0]
				xml_id = i==len(m_l)-1 and rec.getAttribute('id').encode('utf8')
				npid = self.pool.get('ir.model.data')._update_dummy(cr, self.uid, 'ir.ui.menu', self.module, xml_id, i==len(m_l)-1)
			else:
				values = {'parent_id': pid,'name':m_l[i]}

				if rec.hasAttribute('action') and (i==len(m_l)-1):
					a_action = rec.getAttribute('action').encode('utf8')
					a_type = rec.getAttribute('type').encode('utf8') or 'act_window'
					icons = {
						"act_window": 'STOCK_NEW',
						"report.xml": 'STOCK_PASTE',
						"wizard": 'STOCK_EXECUTE',
					}
					values['icon'] = icons.get(a_type,'STOCK_NEW')
					if a_type=='act_window':
						a_id = self.id_get(cr, 'ir.actions.%s'% a_type, a_action)
						cr.execute('select view_type,domain from ir_act_window where id=%d', (int(a_id),))
						action_type,domain = cr.fetchone()
						if action_type=="tree":
							values['icon'] = 'STOCK_INDENT'
							if domain and len(domain)>4:
								values['icon'] = 'STOCK_JUSTIFY_FILL'
				if rec.hasAttribute('sequence') and (i==len(m_l)-1):
					values['sequence'] = int(rec.getAttribute('sequence'))
				if rec.hasAttribute('icon') and (i==len(m_l)-1):
					values['icon'] = str(rec.getAttribute('icon'))
				if rec.hasAttribute('groups'):
					g_groups =  rec.getAttribute('groups').split(',')
					g_ids = []
					for groups in g_groups :
						 g_ids.extend(self.pool.get('res.groups').search(cr, self.uid, [('name', '=', groups)] ))
					values['groups_id'] = [(6,0, g_ids )]
				xml_id = i==len(m_l)-1 and rec.getAttribute('id').encode('utf8')
				pid = self.pool.get('ir.model.data')._update(cr, self.uid, 'ir.ui.menu', self.module, values, xml_id, i==len(m_l)-1, mode=self.mode)
		if rec_id and pid:
			self.idref[rec_id] = pid

		if rec.hasAttribute('action'):
			a_action = rec.getAttribute('action').encode('utf8')
			a_type = rec.getAttribute('type').encode('utf8') or 'act_window'
			a_id = self.id_get(cr, 'ir.actions.%s'% a_type, a_action)
			action = "ir.actions.%s,%d" % (a_type, a_id)
			ir.ir_set(cr, self.uid, 'action', 'tree_but_open', 'Menuitem', [('ir.ui.menu', int(pid))], action, True, True)
		return ('ir.ui.menu', pid)

	def _tag_record(self, cr, rec, data_node=None):
		rec_model = rec.getAttribute("model").encode('ascii')
		model = self.pool.get(rec_model)
		assert model, "The model %s does not exist !" % (rec_model,)
		rec_id = rec.getAttribute("id").encode('ascii')
		if data_node.getAttribute('noupdate') and not self.mode=='init':
			id = self.pool.get('ir.model.data')._update_dummy(cr, self.uid, rec_model, self.module, rec_id or False)
			if rec_id:
				self.idref[rec_id] = id
			return None

		res = {}
		for field in [i for i in rec.childNodes if (i.nodeType == i.ELEMENT_NODE and i.nodeName=="field")]:
			f_name = field.getAttribute("name").encode('ascii')
			f_ref = field.getAttribute("ref").encode('ascii')
			f_search = field.getAttribute("search").encode('ascii')
			f_model = field.getAttribute("model").encode('ascii')
			if not f_model and model._columns.get(f_name,False):
				f_model = model._columns[f_name]._obj
			f_use = field.getAttribute("use").encode('ascii') or 'id'
			f_val = False

			if len(f_search):
				q = eval(f_search,self.idref)
				field = []
				assert f_model, 'Define an attribute model="..." in your .XML file !'
				s = self.pool.get(f_model).browse(cr,self.uid,self.pool.get(f_model).search(cr,self.uid,q))
				_cols = self.pool.get(rec_model)._columns
				if (f_name in _cols) and _cols[f_name]._type=='many2many':
					f_val = [(6,0,map(lambda x: x[f_use], s))]
				elif len(s):
					f_val = s[0][f_use]
			elif len(f_ref):
				if f_ref=="null":
					f_val = False
				else:
					f_val = self.id_get(cr, f_model, f_ref)
			else:
				f_val = _eval_xml(field, self.pool, cr, self.uid, self.idref)
				if model._columns.has_key(f_name):
					if isinstance(model._columns[f_name],osv.fields.integer):
						f_val = int(f_val)
			res[f_name] = f_val
		id = self.pool.get('ir.model.data')._update(cr, self.uid, rec_model, self.module, res,rec_id or False, not data_node.getAttribute('noupdate'), noupdate=data_node.getAttribute('noupdate'), mode=self.mode )
		if rec_id:
			self.idref[rec_id] = id
		return rec_model,id

	def id_get(self, cr, model, id_str):
		if id_str in self.idref:
			return self.idref[id_str]
		return self.pool.get('ir.model.data')._get_id(cr, self.uid, self.module, id_str)

	def parse(self, xmlstr):
		cr = sql_db.db.cursor()
		d = xml.dom.minidom.parseString(xmlstr)
		de = d.documentElement
		for n in [i for i in de.childNodes if (i.nodeType == i.ELEMENT_NODE and i.nodeName=="data")]:
			for rec in n.childNodes:
				if rec.nodeType == rec.ELEMENT_NODE:
					if not rec.nodeName in self._tags:
						continue
					res = self._tags[rec.nodeName](cr, rec, n)
		cr.commit()
		cr.close()
		return True

	def __init__(self, module, idref, mode):
		self.mode = mode
		self.module = module
		self.idref = idref
		self.pool = osv.osv.osv_pools
		self.uid = 1
		self._tags = {
			'menuitem': self._tag_menuitem,
			'record': self._tag_record,
			'report': self._tag_report,
			'wizard': self._tag_wizard,
			'delete': self._tag_delete,
			'ir_set': self._tag_ir_set,
			'function': self._tag_function,
			'workflow': self._tag_workflow,
		}


# xml import/export
def convert_xml_import(module, xmlstr, idref={}, mode='init'):
	obj = xml_import(module, idref,mode)
	obj.parse(xmlstr)
	del obj
	return True

def convert_xml_export(res):
	uid=1
	pool=osv.osv.osv_pools
	cr=sql_db.db.cursor()
	idref = {}
	d = xml.dom.minidom.getDOMImplementation().createDocument(None, "terp", None)
	de = d.documentElement
	data=d.createElement("data")
	de.appendChild(data)
	de.appendChild(d.createTextNode('Some textual content.'))
	cr.commit()
	cr.close()
