##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc

import time
import sql_db
from osv import osv

arch = '''<?xml version="1.0"?>
<form string="Split line">
	<field name="increment"/>"
	<field name="start"/>
	<field name="serial_prefix"/>
	<field name="serial_suffix"/>
	<field name="quantity"/>
</form>'''

fields = {
	'quantity': {'string':'Items per lot', 'type':'float', 'required':True, 'default': lambda x,y,z: 1},
	'start': {'string':'Starting number', 'type':'integer', 'required':True, 'default': lambda x,y,z: 1000},
	'serial_prefix': {'string':'Serial prefix', 'type':'char', 'required':False, 'default': lambda x,y,z: 'SN'},
	'serial_suffix': {'string':'Serial suffix', 'type':'char', 'required':False},
	'increment': {'string':'Increment', 'type':'integer', 'required':True, 'default': lambda x,y,z: 1},
}

def _get_value(self, uid, datas):
	service = netsvc.LocalService("object_proxy")
	start = service.execute(uid, 'ir.sequence', 'get', 'stock.serial.start')
	return {'start':start}

def _split_line(self, uid, datas):
	cr = sql_db.db.cursor()
	move_obj = osv.osv_pools.get('stock.move')
	move = move_obj.browse(cr, uid, [datas['id']])[0]
	i = move.product_qty
	j = datas['form']['start'] or 0
	while i>0:
		qty = (datas['form']['quantity'] or 1)
		if qty>i:
			qty=i
		i-= qty
		name = move.name
		if move.tracking_id:
			name = move.tracking_id.name
		new_tracking = osv.osv_pools.get('stock.tracking').create(cr, uid, {
			'name': name,
			'serial': (datas['form']['serial_prefix'] or '')+ str(j) + (datas['form']['serial_suffix'] or '')
		})
		j+=(datas['form']['increment'] or 1)
		move_obj.create(cr, uid, {
			'name': move.name,
			'priority': move.priority,
			'location_id': move.location_id.id,
			'location_dest_id': move.location_id.id,
			'product_id': move.product_id.id,
			'product_qty': qty,
			'product_uom': move.product_uom.id,
			'tracking_id': new_tracking,
			'picking_id': move.picking_id.id,
			'lot_id': move.lot_id.id,
			'date': time.strftime('%Y-%m-%d %H:%M:%S'),
			'date_planned': move.date_planned,
			'move_history_ids2': [(6,0,[move.id])],
			'state': 'done'
		})
	move_obj.write(cr, uid, [move.id], {'lot_id': False, 'picking_id':False})
	cr.commit()
	cr.close()
	return {}

class wizard_split_move(wizard.interface):
	states = {
		'init': {
			'actions': [_get_value],
			'result': {'type':'form', 'arch':arch, 'fields':fields, 'state':[('split','Split'),('end','Exit')]}
		},
		'split': {
			'actions': [_split_line],
			'result': {'type':'state', 'state':'end'}
		}
	}

wizard_split_move('stock.move.split')

