<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:import href="../../custom/corporate_defaults.xsl"/>
	<xsl:import href="../../base/report/rml_template.xsl"/>
	
	<xsl:template match="/">
		<xsl:call-template name="rml"/>
	</xsl:template>

	<!-- frames (optional template - override corporate defaults) -->

	<xsl:template name="first_page_frames">
		<frame id="address" x1="11cm" y1="21.5cm" width="6cm" height="4cm"/>
		<frame id="main" x1="1cm" y1="3.5cm" width="19.0cm" height="17.5cm"/>
	</xsl:template>
	
	<!-- report specific "graphics" -->
	
	<xsl:template name="first_page_graphics_report">
	</xsl:template>
	
	<!-- stylesheet -->

	<xsl:template name="stylesheet">
		<blockTableStyle id="infos">
			 <blockFont name="Helvetica-Bold" size="10" start="0,0" stop="-1,0"/>
			 <blockBackground colorName="grey" start="0,0" stop="-1,0"/>
			 <blockTextColor colorName="white" start="0,0" stop="-1,0"/>
			 <blockAlignment value="LEFT" start="0,0" stop="-1,-1"/>
			 <lineStyle kind="GRID" colorName="black"/>
		</blockTableStyle>
		<blockTableStyle id="products">
			 <blockFont name="Helvetica-Bold" size="10" start="0,0" stop="-1,0"/>
			 <blockBackground colorName="grey" start="0,0" stop="-1,0"/>
			 <blockTextColor colorName="white" start="0,0" stop="-1,0"/>
			 <blockValign value="TOP"/>
			 <blockAlignment value="CENTER" start="0,0" stop="-1,0"/>
			 <blockAlignment value="RIGHT" start="0,1" stop="-1,-1"/>
			 <lineStyle kind="LINEBELOW" colorName="black"/>
			 <lineStyle kind="LINEABOVE" colorName="black"/>
			 <lineStyle kind="LINEBEFORE" colorName="black"/>
			 <lineStyle kind="LINEAFTER" colorName="black"/>
		</blockTableStyle>
		<paraStyle name="address-title" fontName="Helvetica-Bold" fontSize="8" alignment="left"/>
		<paraStyle name="address" fontName="Helvetica" fontSize="8" alignment="left" leftIndent="1cm"/>
	</xsl:template>
	
	<xsl:template name="story">
		<xsl:apply-templates select="shippinglist"/>
	</xsl:template>
	
	<xsl:template match="shippinglist">
		<xsl:apply-templates select="shipping"/>
	</xsl:template>
	
	<xsl:template match="shipping">
		<xsl:apply-templates select="header"/>
		<xsl:apply-templates select="lines"/>
	</xsl:template>
	
	<xsl:template match="header">
		<!-- start of address frame -->
		
		<para style="address-title" t="1">
			Shipping Address:
		</para>
	
		<xsl:apply-templates select="corporation" mode="shipping"/>
		<xsl:apply-templates select="address" mode="shipping"/>
	
		<!-- end of address frame -->
	
		<nextFrame/>
	
		<!-- start of products frame -->
	
		<para>
			<b t="1">Recipient</b>: <xsl:apply-templates select="address" mode="header"/> 
		</para>
		<para t="1">
			Concerns: <xsl:value-of select="shipping-name"/>
		</para>
	
		<spacer length="1cm" width="1mm"/>
	
		<blockTable colWidths="3.4cm,3.4cm,3.4cm,3.4cm,3.4cm" style="infos">
		<tr>
			<td t="1">Id Client</td>
			<td t="1">Id Shipping</td>
			<td t="1">Warehouse</td>
			<td t="1">Creation Date</td>
			<td t="1">Promised Date</td>
		</tr><tr>
			<td><para><xsl:value-of select="client-id"/></para></td>
			<td><para><xsl:value-of select="shipping-id"/></para></td>
			<td><para><xsl:value-of select="warehouse"/></para></td>
			<td><para><xsl:value-of select="creation-date"/></para></td>
			<td><para><xsl:value-of select="promised-date"/></para></td>
		</tr>
		</blockTable>
		<!-- end of products frame -->
	</xsl:template>
	
	<xsl:template match="corporation" mode="shipping">
		<para style="address">
			<xsl:value-of select="name"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="type"/>
		</para>
	</xsl:template>
	
	<xsl:template match="address" mode="shipping">
		<para style="address">
			<xsl:value-of select="title"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="name"/>
		</para>
		<para style="address">
			<xsl:value-of select="street"/>
		</para>
		<para style="address">
			<xsl:value-of select="zip"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="city"/>
		</para>
		<para style="address">
			<xsl:value-of select="country"/>
		</para>
	</xsl:template>
	
	<xsl:template match="address" mode="header">
		<xsl:value-of select="title"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="name"/>
	</xsl:template>
	
	<xsl:template match="lines">
		<spacer length="0.5cm"/>
	
		<setNextTemplate name="other_pages"/>
		
		<blockTable colWidths="3cm,3cm,1cm,10cm" style="products" repeatRows="1">
			<tr>
				<td t="1">Product Ref</td><td t="1">Tracking Nb</td><td t="1">Qty</td><td t="1">Description</td>
			</tr>
			<xsl:apply-templates select="line"/>
		</blockTable>

		<setNextTemplate name="first_page"/>
		<nextFrame/>
	</xsl:template>
	
	<xsl:template match="line">
		<tr>
			<td><para><xsl:value-of select="ref"/></para></td>
			<td><para><xsl:value-of select="tracking"/></para></td>
			<td><xsl:value-of select="quantity"/></td>
			<td><para><xsl:value-of select="name"/><xsl:text> </xsl:text><xsl:value-of select="variant"/></para></td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
