##############################################################################
#
# Copyright (c) 2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: make_invoice.py 1070 2005-07-29 12:41:24Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from mx.DateTime import now

import wizard
import netsvc
import sql_db
import ir
from osv.osv import osv_pools

invoice_form = """<?xml version="1.0"?>
<form string="Create invoices">
	<separator colspan="4" string="Do you really want to create the invoices ?" />
	<field name="grouped" />
</form>
"""

invoice_fields = {
	'grouped' : {'string':'Group the invoices', 'type':'boolean', 'default': lambda x,y,z: False}
}

ack_form = """<?xml version="1.0"?>
<form string="Create invoices">
	<separator string="Invoices created" />
</form>"""

ack_fields = {}

def _makeInvoices(wizard, uid, datas):
	cr = sql_db.db.cursor()
	order_obj = osv_pools.get('sale.order')
	order_obj.action_invoice_create(cr, uid, datas['ids'], datas['form']['grouped'])
	for id in datas['ids']:
		wf_service = netsvc.LocalService("workflow")
		wf_service.trg_validate(uid, 'sale.order', id, 'manual_invoice', cr)
	cr.commit()
	cr.close()
	return {}

class make_invoice(wizard.interface):
	states = {
		'init' : {
			'actions' : [],
			'result' : {'type' : 'form', 'arch' : invoice_form, 'fields' : invoice_fields, 'state' : [('invoice', 'Create invoices'), ('end', 'Cancel')]}
		},
		'invoice' : {
			'actions' : [_makeInvoices],
			'result' : {'type' : 'form', 'arch' : ack_form, 'fields' : ack_fields, 'state' : [('end', 'Done')]}
		},
	}
make_invoice("sale.order.make_invoice")
