<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">

	<xsl:import href="../../custom/corporate_defaults.xsl"/>
	<xsl:import href="../../base/report/rml_template.xsl"/>
	
	<xsl:template match="/">
		<xsl:call-template name="rml"/>
	</xsl:template>

	<!-- report specific "graphics" -->
	
	<xsl:template name="first_page_graphics_report">
		<setFont name="Helvetica" size="16"/>
		<drawCentredString x="105mm" y="28cm" t="1">SALE ORDER</drawCentredString>
	</xsl:template>


	<!-- stylesheet -->

	<xsl:template name="stylesheet">
		<blockTableStyle id="accounts">
			<blockAlignment value="RIGHT" start="-1,0" stop="-1,-1"/>
			<lineStyle kind="LINEABOVE" start="-1,-2" stop="-1,-2"/>
		</blockTableStyle>

		<paraStyle name="notes" fontName="Helvetica" fontSize="8" alignment="justify"/>
		<paraStyle name="conditions" fontName="Helvetica" fontSize="8" alignment="justify"/>
		<paraStyle name="name" fontName="Helvetica-Bold"/>
		<paraStyle name="title" fontName="Helvetica-Bold" fontSize="22" alignment="center"/>
		
		<blockTableStyle id="products-right">
			 <blockValign value="TOP"/>
			 <blockAlignment value="RIGHT"/>
			 <lineStyle kind="LINEABOVE" colorName="black" start="-1,0" stop="-1,0"/>
			 <lineStyle kind="LINEABOVE" colorName="black" start="-1,-1" stop="-1,-1"/>
			 <lineStyle kind="LINEBELOW" colorName="black" start="-1,-1" stop="-1,-1"/>
			 <lineStyle kind="LINEBEFORE" colorName="black" start="-1,-1" stop="-1,-1"/>
			 <lineStyle kind="LINEAFTER" colorName="black" start="-1,-1" stop="-1,-1"/>
			 <blockBackground colorName="(0.85,0.85,0.85)" start="-1,-1" stop="-1,-1"/>
		</blockTableStyle>
		
		<blockTableStyle id="products">
			 <blockBackground colorName="grey" start="0,0" stop="-1,0"/>
			 <blockTextColor colorName="white" start="0,0" stop="-1,0"/>
			 <blockValign value="TOP"/>
			 <blockAlignment value="RIGHT" start="1,0" stop="-1,-1"/>
			 <lineStyle kind="LINEBELOW" colorName="black" start="0,0" stop="-1,0"/>
		</blockTableStyle>
	</xsl:template>

	<xsl:template name="story">
		<xsl:apply-templates select="order-list"/>
	</xsl:template>
	
	<xsl:template match="order-list">
		<xsl:apply-templates select="order"/>
	</xsl:template>
	
	<xsl:template match="order">
		<xsl:apply-templates select="order_to"/>
		
		<nextFrame/>
		
		<para style="title">
			<xsl:choose>
				<xsl:when test="state='draft'">
					<xsl:text t="1">Quotation </xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text t="1">Order </xsl:text>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:text> ref </xsl:text>
			<xsl:value-of select="id"/>
		</para>
		
		<spacer length="1cm" width="2mm"/>

		<setNextTemplate name="other_pages"/>
		
		<para t="1">Dear customer,</para>
		
		<spacer length="0.3cm" width="1mm"/>
		
		<para t="1">
			Here is the detail of your order "<i><xsl:value-of select="name"/></i>", with the reference "<xsl:value-of select="id"/>", ordered the <xsl:value-of select="date_order"/>.
			Thanks to confirm good reception of the following and contact us in case of any trouble.
		</para>
		
		<spacer length="0.3cm" width="1mm"/>
		<para><xsl:value-of select="$signature"/></para>
		<spacer length="1cm" width="1mm"/>
		
		<xsl:apply-templates select="order-lines"/>
		
		<spacer length="0.5cm" width="1mm"/>
		
		<xpre><b><xsl:value-of select="notes"/></b></xpre>
		
		<setNextTemplate name="first_page"/>
		
		<pageBreak/>
	</xsl:template>

	<xsl:template match="state">
		<para>
			<xsl:text t="1">Status:</xsl:text><xsl:text t="1"> </xsl:text>
			<xsl:choose>
				<xsl:when test=".='draft'">
					<xsl:text t="1">draft</xsl:text>
				</xsl:when>
				<xsl:when test=".='progress'">
					<xsl:text t="1">in progress</xsl:text>
				</xsl:when>
				<xsl:when test=".='shipping_except'">
					<xsl:text t="1">exception in shipping</xsl:text>
				</xsl:when>
				<xsl:when test=".='invoice_expect'">
					<xsl:text t="1">exception in invoice</xsl:text>
				</xsl:when>
				<xsl:when test=".='done'">
					<xsl:text t="1">done</xsl:text>
				</xsl:when>
				<xsl:when test=".='cancel'">
					<xsl:text t="1">cancelled</xsl:text>
				</xsl:when>
				<xsl:otherwise>
				</xsl:otherwise>
			</xsl:choose>
		</para>
	</xsl:template>	
	
	<xsl:template match="order_to">
		<para style="name">
			<xsl:value-of select="contact/title"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="contact/name"/>
		</para>
		<para>
			<xsl:value-of select="corporation/title"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="corporation/name"/>
		</para>
		<para><xsl:value-of select="contact/street"/></para>
		<para>
			<xsl:value-of select="contact/zip"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="contact/city"/>
		</para>
		<para><xsl:value-of select="contact/state"/></para>
		<para><xsl:value-of select="contact/country"/></para>
	</xsl:template>

	<xsl:template match="order-lines">
		<blockTable colWidths="10.5cm,2cm,1cm,2cm,2cm" style="products">
		<tr>
			<td t="1">Description</td>
			<td t="1">Date</td>
			<td t="1">Qty</td>
			<td t="1">Unit Price</td>
			<td t="1">Net Price</td>
		</tr>
		<xsl:apply-templates select="order-line"/>
		</blockTable>
		
		<spacer length="0.4cm" width="1mm"/>

		<blockTable colWidths="10.5cm,2cm,1cm,2cm,2cm" style="products-right">
		<tr>
			<td/>
			<td/>
			<td t="1">TOTAL:</td>
			<td/>
			<td>
				<xsl:value-of select="format-number(sum(order-line/product_total_price), '#,##0.00')"/> 
			</td>
		</tr>
		</blockTable>
	</xsl:template>
	
	<xsl:template match="order-line">
		<tr>
			<td>
				<para><xsl:value-of select="product"/></para>
				<para style="notes"><xsl:value-of select="notes"/></para>
			</td>
			<td><xsl:value-of select="date_promise"/></td>
			<td><xsl:value-of select="quantity"/></td>
			<td><xsl:value-of select="format-number(price_unit, '#,##0.00')"/></td>
			<td><xsl:value-of select="format-number(product_total_price, '#,##0.00')"/></td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
