##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

from osv import fields,osv
import ir
import netsvc

import time

class model(osv.osv):
	_name = 'ir.model'
	_columns = {
		'name': fields.char('Name', size=64, translate=True),
		'model': fields.char('model', size=64, required=True),
		'field_id': fields.one2many('ir.model.fields', 'model_id', 'field ids', required=True),
	}
	_defaults = {
		'name': lambda *a: 'NoName',
	}
#CHECKME: c'est quoi l'interet/la difference par rapport au name_get normal?	
	def name_get(self, cr, user, ids, context={}):
		if not len(ids):
			return []
		
		res = []
		for r in self.read(cr, user, ids, ['model']):
			name = str(r['model'] or '')
			id = int(r['id'])
			res.append((id, name))
		return res 
model()

class ir_model_fields(osv.osv):
	_name = 'ir.model.fields'
	_columns = {
		'name': fields.char('Name', size=64),
		'model': fields.char('Model Name', size=64, required=True),
		'relation': fields.char('Model Relation', size=64),
		'model_id': fields.many2one('ir.model', 'Model id', required=True),
		'field_description': fields.char('Field Description', size=256),
		'ttype': fields.char('Field Type', size=64),
		'relate': fields.boolean('Client and Relate'),
	}
	_defaults = {
		'relate': lambda *a: 1,
		'name': lambda *a: 'NoName',
		'field_description': lambda *a: 'No description available',
	}
	def name_get(self, cr, user, ids, context={}):
		if not len(ids):
			return []
		
		res = []
		for r in self.read(cr, user, ids, ['name']):
			name = str(r['name'] or '')
			id = int(r['id'])
			res.append((id, name))
		return res 
ir_model_fields()

class ir_model_access(osv.osv):
	_name = 'ir.model.access'
	_columns = {
		'name': fields.char('Name',size=64),
		'model_id': fields.many2one('ir.model', 'Model id', required=True),
		'group_id': fields.many2one('res.groups', 'Group'),
		'perm_read': fields.boolean('Read Access'),
		'perm_write': fields.boolean('Write Access'),
		'perm_create': fields.boolean('Create Access'),
	}
	def check(self, cr, uid, model_name, mode='read'):
		assert mode in ['read','write','create'], 'Invalid access mode for security'
		cr.execute('select group_id, perm_'+mode+' from ir_model_access a left join ir_model m on (a.model_id=m.id) where m.model=%s', (model_name,))
		res = cr.fetchall()
		if not res:
			return True
		res2 = map(lambda x: str(x[0]), filter(lambda x: x[1], res))
		if not res2:
			raise osv.except_osv('Access denied !', 'You can not %s this ressource !' %(mode,))
			raise 'Access Denied !'
		ids_str = ','.join(res2)
		cr.execute('select count(*) from res_groups_users_rel where uid=%d and gid in ('+ids_str+')', (uid,))
		if cr.fetchone()[0]:
			return True
		raise osv.except_osv('Access denied !', 'You can not %s this ressource !' %(mode,))
ir_model_access()

class ir_model_data(osv.osv):
	_name = 'ir.model.data'
	_columns = {
		'name': fields.char('XML Identifier', required=True, size=64),
		'model': fields.char('Model', required=True, size=64),
		'module': fields.char('Module', required=True, size=64),
		'res_id': fields.integer('Ressource ID'),
		'noupdate': fields.boolean('Un Updatable'),
		'date_update': fields.datetime('Update Date'),
		'date_init': fields.datetime('Init Date')
	}
	_defaults = {
		'date_init': lambda *a: time.strftime('%Y-%m-%d %H:%M:%S'),
		'date_update': lambda *a: time.strftime('%Y-%m-%d %H:%M:%S'),
		'noupdate': lambda *a: False
	}

	def __init__(self):
		osv.osv.__init__(self)
		self.loads = {}
		self.init = True
		self.unlink_mark = {}

	def _get_id(self,cr, uid, module, xml_id):
		ids = self.search(cr, uid, [('module','=',module),('name','=', xml_id)])
		assert len(ids)==1, '%d reference(s) to %s. You should have only one !' % (len(ids),xml_id)
		return ids[0]

	def _update_dummy(self,cr, uid, model, module, xml_id=False, store=True):
		if not xml_id:
			return False
		id = self.read(cr, uid, [self._get_id(cr, uid, module, xml_id)], ['res_id'])[0]['res_id']
		self.loads[(module,xml_id)] = (model,id)
		return id

	def _update(self,cr, uid, model, module, values, xml_id=False, store=True, noupdate=False, mode='init'):
		warning=True
		if xml_id and ('.' in xml_id):
			assert len(xml_id.split('.'))==2, 'Reference should not contains "." ! Instead for module.reference_id: %s' % (xml_id)
			warning=False
			module, xml_id = xml_id.split('.')
		if (not xml_id) and (not self.init):
			return False
		action_id = False
		res_id = False
		if xml_id:
			cr.execute('select id,res_id from ir_model_data where module=%s and name=%s', (module,xml_id))
			results = cr.fetchall()
			for action_id2,res_id2 in results:
				result3 = self.pool.get(model).search(cr, uid, [('id','=',res_id2)])
				if not result3:
					cr.execute('delete from ir_model_data where id=%d', (action_id2,))
				else:
					res_id,action_id = res_id2,action_id2

		if action_id:
			self.pool.get(model).write(cr, uid, [res_id], values)
			self.write(cr, uid, [action_id], {'date_update': time.strftime('%Y-%m-%d %H:%M:%S')})
		else:
			if mode=='init':
				res_id = self.pool.get(model).create(cr, uid, values)
				if xml_id:
					self.create(cr, uid, {'name':xml_id, 'model':model, 'module':module, 'res_id':res_id, 'noupdate':noupdate})
		if xml_id:
			if warning:
				assert (module,xml_id) not in self.loads, 'Module (%s), id %s is already defined !' % (module, xml_id)
			if res_id:
				self.loads[(module,xml_id)] = (model, res_id)
		return res_id

	def _unlink(self, cr, uid, model, ids, direct=False):
		#self.pool.get(model).unlink(cr, uid, ids)
		for id in ids:
			self.unlink_mark[model,id]=False
			cr.execute('delete from ir_model_data where res_id=%d and model=\'%s\'', (id,model))
		return True

	def _process_end(self, cr, uid, modules):
		if not modules:
			return True
		module_str = map(lambda x: "'"+x+"'", modules)
		cr.execute('select id,name,model,res_id,module from ir_model_data where module in ('+','.join(module_str)+') and not noupdate')
		wkf_todo = []
		for (id, name, model, res_id,module) in cr.fetchall():
			if (module,name) not in self.loads:
				print 'MARK', model, res_id, module, name, id
				self.unlink_mark[(model,res_id)] = id
				if model=='workflow.activity':
					cr.execute('select res_type,res_id from wkf_instance where id in (select inst_id from wkf_workitem where act_id=%d)', (res_id,))
					wkf_todo.extend(cr.fetchall())
					cr.execute("update wkf_transition set condition='True', role_id=NULL, signal=NULL,act_to=act_from,act_from=%d where act_to=%d", (res_id,res_id))
					cr.execute("delete from wkf_transition where act_to=%d", (res_id,))

		for model,id in wkf_todo:
			wf_service = netsvc.LocalService("workflow")
			wf_service.trg_write(uid, model, id, cr)

		for (model,id) in self.unlink_mark.keys():
			self.pool.get(model).unlink(cr, uid, [id])
			if self.unlink_mark[(model,id)]:
				self.unlink(cr, uid, [self.unlink_mark[(model,id)]])
		return True
ir_model_data()

