##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

_transaction_form = '''<?xml version="1.0"?>
<form string="Reconciliation">
	<separator string="Reconciliation transactions" colspan="4"/>
	<field name="trans_nbr"/>
	<newline/>
	<field name="credit"/>
	<field name="debit"/>
	<separator string="Write-Off" colspan="4"/>
	<field name="writeoff"/>
	<newline/>
	<field name="writeoff_acc_id" colspan="3"/>
</form>'''

_transaction_fields = {
	'trans_nbr': {'string':'# of Transaction', 'type':'integer', 'readonly':True},
	'credit': {'string':'Credit amount', 'type':'float', 'readonly':True},
	'debit': {'string':'Debit amount', 'type':'float', 'readonly':True},
	'writeoff': {'string':'Write-Off amount', 'type':'float', 'readonly':True},
	'writeoff_acc_id': {'string':'Write-Off account', 'type':'many2one', 'relation':'account.account'},
}

def _trans_rec_get(self, uid, datas, res_get=False):
	print 'ici'
	service = netsvc.LocalService("object_proxy")
	res = filter(lambda x: not x['reconcile_id'], service.execute(uid, 'account.move.line', 'read', datas['ids']))
	credit = debit = 0
	for trans in res:
		credit += trans['credit']
		debit += trans['debit']
	datas['form']['trans_nbr']=len(res)
	datas['form']['credit']=credit
	datas['form']['debit']=debit
	datas['form']['writeoff']=debit-credit
	print 'la'
	if res_get:
		return datas['form'], res
	return datas['form']

def _trans_rec_reconcile(self, uid, datas):
	service = netsvc.LocalService("object_proxy")
	d,trans = _trans_rec_get(self, uid, datas, True)
	d.update(datas)
	self_acc = trans[0]['account_id'][0]
	ids = [x['id'] for x in trans]
	dt = time.strftime('%Y-%m-%d')
	if d['writeoff']<>0:
		if not d['writeoff_acc_id']:
			raise 'warning','You have to provide a reconciliation account !'

		write_id = service.execute(uid, 'account.move', 'create', {'name':'Reconciliation Write-Off', 'partner_id':False, 'project_id':False, 'date':dt, 'type':'undefined', 'line_id': [(0,0,{'name':'Write-Off', 'amount':-d['writeoff'], 'account_id':self_acc, 'date':dt, 'state':'n'}),(0,0,{'name':'Write-Off', 'amount':d['writeoff'], 'account_id':d['writeoff_acc_id'], 'date':dt, 'state':'n'})]})

		trans_ids = service.execute(uid, 'account.move', 'read', [write_id], ['line_id'])[0]['line_id']
		trans_ids = service.execute(uid, 'account.move.line', 'search', [('account_id','=',self_acc),('id','in',trans_ids)])
		ids+=trans_ids
	service.execute(uid, 'account.move.line', 'reconcile', ids)
	return {}


class wiz_reconcile(wizard.interface):
	states = {
		'init': {
			'actions': [_trans_rec_get],
			'result': {'type': 'form', 'arch':_transaction_form, 'fields':_transaction_fields, 'state':[('reconcile','Reconcile'),('end','Cancel')]}
		},
		'reconcile': {
			'actions': [_trans_rec_reconcile],
			'result': {'type': 'state', 'state':'end'}
		}
	}
wiz_reconcile('account.move.line.reconcile')

