##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

from osv import osv

_journal_form = '''<?xml version="1.0"?>
<form string="%s">
	<field name="journal_id"/>
	<newline/>
	<field name="period_id"/>
</form>''' % ('Saisies des ecritures',)

_journal_fields = {
	'journal_id': {'string':'Journal', 'type':'many2one', 'relation':'account.journal', 'default':lambda x,y,z: time.strftime('%Y-%m-%d'), 'required':True},
	'period_id':  {'string':'Period', 'type':'many2one', 'relation':'account.period', 'default':lambda x,y,z: time.strftime('%Y-%m-%d'), 'required':True}
}

def _action_open_window(uid, datas):
	form = datas['form']
	import sql_db
	cr = sql_db.db.cursor()
	cr.execute('select id,name from ir_ui_view where model=%s and type=%s', ('account.move.line', 'form'))
	view_res = cr.fetchone()
	jp = osv.osv_pools.get('account.journal.period')
	ids = jp.search(cr, uid, [('journal_id','=',form['journal_id']), ('period_id','=',form['period_id'])])
	if not len(ids):
		jp.create(cr, uid, {'name':'Unknown', 'period_id': form['period_id'], 'journal_id':form['journal_id']})
	cr.commit()
	cr.close()
	return {
		'domain': "[('journal_id','=',%d), ('period_id','=',%d)]" % (form['journal_id'],form['period_id']),
		'name': 'Saisie Standard',
		'view_type': 'tree',
		'res_model': 'account.move.line',
		'view_id': view_res,
		'context': "{'journal_id':%d, 'period_id':%d}" % (form['journal_id'],form['period_id']),
		'type': 'ir.actions.act_window'
	}

class wiz_journal(wizard.interface):
	states = {
		'init': {
			'actions': [],
			'result': {'type': 'form', 'arch':_journal_form, 'fields':_journal_fields, 'state':[('open','Open Journal'),('end','Cancel')]}
		},
		'open': {
			'actions': [],
			'result': {'type': 'action', 'action': _action_open_window, 'state':'end'}
		}
	}
wiz_journal('account.move.journal')

