##############################################################################
#
# Copyright (c) 2004-2005 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import sql_db
import time
from report import report_sxw

class partner_balance(report_sxw.report_sxw):
	def __init__(self, name, table, rml):
		super(partner_balance, self).__init__(name, table, rml)
		self.localcontext = {
			'time': time,
			'lines': self.lines,
			'sum_debit': self._sum_debit,
			'sum_credit': self._sum_credit,
			'sum_litige': self._sum_litige,
			'sum_sdebit': self._sum_sdebit,
			'sum_scredit': self._sum_scredit,
			'solde_debit': self._solde_balance_debit,
			'solde_credit': self._solde_balance_credit,
		}
		
	def create(self, uid, ids, data, context):
		cr = sql_db.db.cursor()
		cr.execute('select distinct partner_id from account_move_line where partner_id is not null and date>=%s and date<=%s', (data['form']['date1'], data['form']['date2']))
		new_ids = map(lambda x: x[0], cr.fetchall())
		cr.execute("SELECT a.id FROM account_account a LEFT JOIN account_account_type t ON (a.type=t.code) WHERE t.partner_account=TRUE")
		self.account_ids = ','.join(map(lambda a: str(a[0]), cr.fetchall()))
		self.partner_ids = ','.join(map(str, new_ids))
		cr.close()
		super(partner_balance, self).create(uid, new_ids, data, context)
		
	def lines(self):
		if not self.partner_ids:
			return []

#TODO: use an SQL CASE to compute sdebit and scredit
		query = "SELECT p.ref, p.name, sum(debit) as debit, sum(credit) as credit, "+\
		        "(SELECT sum(debit-credit) FROM account_move_line WHERE partner_id=p.id AND date>=%s AND date<=%s AND blocked=TRUE) as enlitige "+\
		        "FROM account_move_line l LEFT JOIN res_partner p ON (l.partner_id=p.id) "+\
		        "WHERE partner_id IN (" + self.partner_ids + ") AND account_id IN (" + self.account_ids + ") AND date>=%s AND date<=%s "+\
		        "GROUP BY p.id, p.ref, p.name "+\
		        "ORDER BY p.ref, p.name"
		self.cr.execute(query, (self.datas['form']['date1'], self.datas['form']['date2'], self.datas['form']['date1'], self.datas['form']['date2']))
		res = self.cr.dictfetchall()
		for r in res:
			r['sdebit'] = r['debit'] > r['credit'] and r['debit'] - r['credit']
			r['scredit'] = r['credit'] > r['debit'] and r['credit'] - r['debit']
		return res
		
	def _sum_debit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(debit) from account_move_line where partner_id in (' + self.partner_ids + ') and account_id IN (' + self.account_ids + ') and date>=%s and date<=%s', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_credit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(credit) from account_move_line where partner_id in (' + self.partner_ids + ') and account_id IN (' + self.account_ids + ') and date>=%s and date<=%s', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0

	def _sum_litige(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(debit-credit) from account_move_line where partner_id in (' + self.partner_ids + ') and account_id IN (' + self.account_ids + ') and date>=%s and date<=%s and blocked=TRUE', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
	
	def _sum_sdebit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(debit-credit) from (select sum(debit), sum(credit) from account_move_line where partner_id in (' + self.partner_ids + ') and account_id IN (' + self.account_ids + ') and date>=%s and date<=%s group by partner_id) as dc (debit,credit) where debit>credit', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0
		
	def _sum_scredit(self):
		if not self.ids:
			return 0.0

		self.cr.execute('select sum(credit-debit) from (select sum(debit), sum(credit) from account_move_line where partner_id in (' + self.partner_ids + ') and account_id IN (' + self.account_ids + ') and date>=%s and date<=%s group by partner_id) as dc (debit,credit) where credit>debit', (self.datas['form']['date1'], self.datas['form']['date2']))
		return self.cr.fetchone()[0] or 0.0

	def _solde_balance_debit(self):
		debit, credit = self._sum_debit(), self._sum_credit()
		return debit > credit and debit - credit
		
	def _solde_balance_credit(self):
		debit, credit = self._sum_debit(), self._sum_credit()
		return credit > debit and credit - debit
	
partner_balance('report.account.partner.balance', 'res.partner', 'addons/account/report/partner_balance.rml')

