##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

_transaction_form = '''<?xml version="1.0"?>
<form string="Reconciliation">
	<separator string="Mark Transactions" colspan="4"/>
	<field name="mode"/>
</form>'''

_transaction_fields = {
	'mode': {'string':'Mark Transactions As', 'type':'selection', 'selection':[('n','Unverified'),('c','Verified')], 'default':lambda x,y,z:'c'},
}


def _trans_check(self, uid, datas):
	service = netsvc.LocalService("object_proxy")
	write_id = service.execute(uid, 'account.move.line', 'write', datas['ids'], {'state':datas['form']['mode']})
	return {}

class wiz_check(wizard.interface):
	states = {
		'init': {
			'actions': [],
			'result': {'type': 'form', 'arch':_transaction_form, 'fields':_transaction_fields, 'state':[('mark','Mark'),('end','Cancel')]}
		},
		'mark': {
			'actions': [_trans_check],
			'result': {'type': 'state', 'state':'init'}
		}
	}
wiz_check('account.move.line.check')

