##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

_transaction_form = '''<?xml version="1.0"?>
<form string="%s">
	<field name="name"/>
	<field name="date"/>
	<field name="partner_id"/>
	<field name="proj_id"/>
	<field name="type"/>
	<separator string="%s" colspan="4"/>
	<field name="amount"/>
	<newline/>
	<field name="acc_from"/>
	<field name="acc_to"/>
</form>''' % ('Transaction', 'Transaction')

_transaction_fields = {
	'name': {'string':'Name', 'type':'char', 'required':True},
	'date': {'string':'Date', 'type':'date', 'required':True, 'default':lambda x,y,z: time.strftime('%Y-%m-%d')},
	'partner_id': {'string':'Partner', 'type':'many2one', 'relation':'res.partner'},
	'proj_id': {'string':'Project', 'type':'many2one', 'relation':'account.project'},
	'type': {'string':'Transaction Type', 'type':'char'},
	'acc_from': {'string':'Source Account', 'type':'many2one', 'relation':'res.acc.account', 'required':True},
	'acc_to': {'string':'Destination Account', 'type':'many2one', 'relation':'res.acc.account', 'required':True},
	'amount': {'string':'Amount', 'type':'float', 'required':True},
}

def _trans_create(self, uid, datas):
	form = datas['form']
	service = netsvc.LocalService("object_proxy")
	res = service.execute(uid, 'res.acc.transaction.group', 'create', {'name':form['name'], 'date':form['date'], 'type':form['type'], 'partner_id':form['partner_id'], 'proj_id':form['proj_id'], 'trans_id':[(0,0,{'name':form['name'], 'date':form['date'],'amount':-form['amount'], 'acc_id':form['acc_from'], 'state':'n'}), (0,0,{'name':form['name'], 'date':form['date'],'amount':form['amount'], 'acc_id':form['acc_to'], 'state':'n'})]})
	print res
	return {'name':'', 'date':time.strftime('%Y-%m-%d'), 'partner_id':False, 'proj_id':False, 'type':False, 'amount':0.0}

class wiz_transaction_add(wizard.interface):
	states = {
		'init': {
			'actions': [],
			'result': {'type': 'form', 'arch':_transaction_form, 'fields':_transaction_fields, 'state':[('create','Create'),('end','Cancel')]}
		},
		'create': {
			'actions': [_trans_create],
			'result': {'type': 'state', 'state':'init'}
		}
	}
wiz_transaction_add('res.acc.transaction.add')


