<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="../../custom/corporate_defaults.xsl"/>
	<xsl:import href="../../base/report/rml_template.xsl"/>

<xsl:template match="/">
	<xsl:call-template name="rml"/>
</xsl:template>

<xsl:template name="stylesheet">
		<blockTableStyle id="accounts">
			<blockAlignment value="RIGHT" start="-1,0" stop="-1,-1"/>
			<lineStyle kind="LINEABOVE" start="-1,-2" stop="-1,-2"/>
		</blockTableStyle>

		<paraStyle name="conditions" fontName="Helvetica" fontSize="8" alignment="justify"/>
		<paraStyle name="name" fontName="Helvetica-Bold"/>
		<paraStyle name="title" fontName="Helvetica-Bold" fontSize="12" alignment="center"/>
		<paraStyle name="subtitle" fontName="Helvetica" fontSize="12" alignment="left"/>
		<blockTableStyle id="products">
			 <blockFont name="Helvetica-BoldOblique" size="14" start="0,0" stop="-1,0"/>
			 <lineStyle kind="LINEBELOW" colorName="black" start="0,0" stop="-1,0"/>
			 <blockValign value="TOP"/>
			 <blockAlignment value="RIGHT" start="-3,0" stop="-1,-1"/>
		</blockTableStyle>
</xsl:template>

<xsl:template name="story">
	<xsl:apply-templates select="accounting-journal"/>
</xsl:template>

<xsl:template match="accounting-journal">
	<para style="title" t="1">Livre de caisse, <xsl:value-of select="data/init-date"/><xsl:text> - </xsl:text><xsl:value-of select="data/end-date"/></para>
	<spacer length="0.5cm" width="3mm"/>
	<xsl:apply-templates select="account"/>
</xsl:template>

<xsl:template match="account">
	<spacer length="1.5cm" width="3mm"/>
	<para style="subtitle">
		<b t="1">Account:</b><xsl:text> </xsl:text> <xsl:value-of select="name"/>
	</para>
	<spacer length="1cm" width="3mm"/>
	<blockTable style="products" colWidths="2.3cm,5cm,4cm,2.5cm,2.5cm,2.5cm">
	<tr>
		<td t="1">Date</td>
		<td t="1">Transaction</td>
		<td t="1">Partner</td>
		<td t="1">Balance</td>
		<td t="1">Debit</td>
		<td t="1">Credit</td>
	</tr>
	<tr>
		<td></td>
		<td><para><b t="1">Starting Balance:</b></para></td>
		<td></td>
		<td><xsl:value-of select="format-number(data/total, '#,##0.00')"/><xsl:text> </xsl:text><xsl:value-of select="data/currency"/></td>
		<td></td>
		<td></td>
	</tr>
	<xsl:apply-templates select="transaction"/>
	<tr>
		<td></td>
		<td><para><b t="1">Ending Balance:</b></para></td>
		<td></td>
		<td><xsl:value-of select="format-number(sum(transaction/amount) + data/total, '#,##0.00')"/><xsl:text> </xsl:text><xsl:value-of select="data/currency"/></td>
		<td></td>
		<td></td>
	</tr>
	</blockTable>
</xsl:template>

<xsl:template match="transaction">
	<tr>
		<td><para><xsl:value-of select="date"/></para></td>
		<td><para><xsl:value-of select="name"/></para></td>
		<td><para><xsl:value-of select="partner"/></para></td>
		<td><xsl:value-of select="format-number(amount, '#,##0.00')"/></td>
		<td>
			<xsl:if test="amount&gt;0">
				<xsl:value-of select="format-number(amount, '#,##0.00')"/>
			</xsl:if>
		</td>
		<td>
			<xsl:if test="amount&lt;0">
				<xsl:value-of select="format-number(-amount, '#,##0.00')"/>
			</xsl:if>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
