# -*- encoding: utf-8 -*-
##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: account.py 1005 2005-07-25 08:41:42Z nicoe $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################
import time
import netsvc
from osv import fields, osv
import ir

#----------------------------------------------------------
# Currency
#----------------------------------------------------------
class account_currency(osv.osv):
	_name = "account.currency"
	_description = "Currency"
	_columns = {
		'name': fields.char('Currency', size=3),
		'date': fields.date('Last rate update', readonly=True),
		'rate' : fields.float('Relative Change rate',digits=(12,6)),
		'digits' : fields.integer('Displayed Digits'),
		'accuracy' : fields.integer('Computational Accuracy'),
		'priority' : fields.integer('Usage priority'),
		'active': fields.boolean('Active'),
	}
	_defaults = {
		'date': lambda *a: time.strftime('%Y-%m-%d'),
		'active': lambda *a: 1,
	}
#TODO: onchange sur le rate qui met a jour date
	_order = "priority,name"
account_currency()

#----------------------------------------------------------
# Accounts
#----------------------------------------------------------
class account_account(osv.osv):
	_order = "code"
	_name = "account.account"
	_description = "Account"

#	def _debit_rec(self,cr,id,rate,res):
#		if not res.has_key(id):
#			bal=0.0
#			cr.execute("SELECT child_id FROM account_account_rel WHERE parent_id=%d"%id)
#			for (child_id,) in cr.fetchall():
#				bal+=self._debit_rec(cr,child_id,rate,res)*(rate[id]/rate[child_id])
#			res[id]=round(bal,2)
#		return round(res[id],2)
	def _credit(self, cr, uid, ids, prop, unknow_none,context={}):
		project_id = int(context.get('project_id', 0))
		project_rate = osv.osv_pools.get('account.project').read(cr, uid, [project_id], ['project_rate'])
		if project_id == 0:
			default_rate = 1.0
		else:
			default_rate = 0.0
		if project_rate:
			project_rate = project_rate[0]['project_rate']
		else:
			project_rate = {}
		ids = self.search(cr,uid,[('parent_id','child_of',ids)])
		acc_set=",".join( map(str, ids ) )
		rate={}
		view={}
		cr.execute("SELECT a.id,a.type,c.rate FROM account_account a LEFT JOIN account_currency c ON (a.currency_id=c.id) WHERE a.id IN (%s)"%acc_set)
		for (id,t,r) in cr.fetchall():
			rate[id]=r
			if t=='view':
				view[id]=0

		self.pool.get('account.account').search(cr, uid, [('parent_id', 'child_of', [id])])
		cr.execute("SELECT a.id, m.project_id, -COALESCE(SUM(l.amount*a.sign),0) FROM account_account a LEFT JOIN account_move_line l ON (a.id=l.account_id) LEFT JOIN account_move m ON (m.id=l.move_id) WHERE a.type!='view' AND a.id IN (%s) AND l.amount < 0 GROUP BY a.id,m.project_id"%acc_set)
		res2=cr.fetchall()
		res= {}
		for id in ids:
			res[id]=0.0
		for account_id,project_id,sum in res2:
			res[account_id] += sum * project_rate.get(project_id,default_rate)
		return res

#	def _credit_rec(self,cr,id,rate,res):
#		if not res.has_key(id):
#			bal=0.0
#			cr.execute("SELECT child_id FROM account_account_rel WHERE parent_id=%d"%id)
#			for (child_id,) in cr.fetchall():
#				bal+=self._credit_rec(cr,child_id,rate,res)*(rate[id]/rate[child_id])
#			res[id]=round(bal,2)
#		return round(res[id],2)
	def _debit(self, cr, uid, ids, prop, unknow_none,context, where=''):
		project_id = int(context.get('project_id', 0))
		project_rate = osv.osv_pools.get('account.project').read(cr, uid, [project_id], ['project_rate'])
		if project_rate:
			project_rate = project_rate[0]['project_rate']
		else:
			project_rate = {}
		if project_id == 0:
			default_rate = 1.0
		else:
			default_rate = 0.0
		ids = self.search(cr,uid,[('parent_id','child_of',ids)])
		acc_set=",".join( map(str, ids ) )
		rate={}
		view={}
		cr.execute("SELECT a.id,a.type,c.rate FROM account_account a LEFT JOIN account_currency c ON (a.currency_id=c.id) WHERE a.id IN (%s)"%acc_set)
		for (id,t,r) in cr.fetchall():
			rate[id]=r
			if t=='view':
				view[id]=0
		cr.execute("SELECT a.id, m.project_id, COALESCE(SUM(l.amount*a.sign),0) FROM account_account a LEFT JOIN account_move_line l ON (a.id=l.accounT_ID) LEFT JOIN account_move m ON (m.id=l.move_id) WHERE a.type!='view' AND a.id IN (%s) AND l.amount>0 GROUP BY a.id,m.project_id"%acc_set)
		res2=cr.fetchall()
		res= {}
		for id in ids:
			res[id]=0.0
		for account_id,project_id,sum in res2:
			res[account_id] += sum * project_rate.get(project_id,default_rate)
		return res

	def _balance_rec(self,cr,id,rate,res):
		if not res.has_key(id):
			bal=0.0
			cr.execute("SELECT child_id FROM account_account_rel WHERE parent_id=%d"%id)
			for (child_id,) in cr.fetchall():
				bal+=self._balance_rec(cr,child_id,rate,res)*(rate[id]/rate[child_id])
			res[id]=round(bal,2)
		return round(res[id],2)
		
	def _balance(self, cr, uid, ids, prop, unknow_none,context):
		project_id = int(context.get('project_id', 0))
		project_rate = osv.osv_pools.get('account.project').read(cr, uid, [project_id], ['project_rate'])
		
		if project_rate:
			project_rate = project_rate[0]['project_rate']
		else:
			project_rate = {}
		if project_id == 0:
			default_rate = 1.0
		else:
			default_rate = 0.0
		ids = self.search(cr,uid,[('parent_id','child_of',ids)])
		acc_set=",".join( map(str, ids ) )
		rate={}
		view={}
		cr.execute("SELECT a.id,a.type,c.rate FROM account_account a LEFT JOIN account_currency c ON (a.currency_id=c.id) WHERE a.id IN (%s)"%acc_set)
		for (id,t,r) in cr.fetchall():
			rate[id]=r
			if t=='view':
				view[id]=0
		cr.execute("SELECT a.id, m.project_id, COALESCE(SUM(l.amount*a.sign),0) FROM account_account a LEFT JOIN account_move_line l ON (a.id=l.account_id) LEFT JOIN account_move m On (m.id=l.move_id) WHERE a.type!='view' AND a.id IN (%s) GROUP BY a.id,m.project_id"%acc_set)
		#res= dict(cr.fetchall())
		res2=cr.fetchall()
		res= {}
		for id in ids:
			res[id]=0.0
		for account_id,project_id,sum in res2:
			res[account_id] += sum * project_rate.get(project_id,default_rate)
		for id in view:
			self._balance_rec(cr,id,rate,res)
		return res

	_columns = {
		'name': fields.char('Name', size=128, required=True, translate=True),
		'sign': fields.integer('Signe', required=True),
		'currency_id': fields.many2one('account.currency', 'Currency', required=True),
		'code': fields.char('Code', size=64 ),
		'type': fields.selection([
			('view','View'),
			('payable','Account Payable'),
			('receivable','Account Receivable'),
			('tax','Tax'), ('income','Income'),
			('expense','Expense'),
			('test','Capital'),
			('cash','Cash'),
			('asset','Asset'),
			('stock_inventory','Stock Inventory'),
			('stock_expense','Stock Expense'),
			('stock_income','Stock Income'),
			('equity','Equity')
		],'Account Type', required=True),
		'parent_id': fields.many2many('account.account', 'account_account_rel', 'child_id', 'parent_id', 'Parents'),
		'child_id': fields.many2many('account.account', 'account_account_rel', 'parent_id', 'child_id', 'Children'),
		'balance': fields.function(_balance, method=True, string='Balance'),
		'credit': fields.function(_credit, method=True, string='Credit'),
		'debit': fields.function(_debit, method=True, string='Debit'),
		'protected': fields.boolean('Protected'),
		'active': fields.boolean('Active'),
	}
	_defaults = {
		'sign': lambda *a: 1,
		'type': lambda *a: 'view',
		'active': lambda *a: 1,
		'protected': lambda *a: False,
	}
	def name_search(self, cr, user, name, args=[], operator='ilike', context={}):
		ids = []
		if name:
			ids = self.search(cr, user, [('code','=',name)]+ args)
		if not ids:
			ids = self.search(cr, user, [('name',operator,name)]+ args)
		return self.name_get(cr, user, ids, context=context)
	def name_get(self, cr, uid, ids, context={}):
		if not len(ids):
			return []
		reads = self.read(cr, uid, ids, ['name','code'], context)
		res = []
		for record in reads:
			name = record['name']
			if record['code']:
				name = record['code']+' - '+name
			res.append((record['id'],name ))
		return res
account_account()

#----------------------------------------------------------
# Movements
#----------------------------------------------------------
class account_move(osv.osv):
	_name = "account.move"
	_description = "Account Move"
	_columns = {
		'name': fields.char('Move Name', size=64, required=True),
		'date': fields.date('Date'),
		'type': fields.selection([
			('in_payment','Incoming Customer Payment'),
			('out_payment','Outgoing Supplier Payment'),
			('expense', 'Direct Expense'),
			('transfer','Money Transfer'),
			('change','Currency Change'),
			('refund','Customer Refund'),
			('sale','Manual Sale'),
			('undefined','Undefined'),
			('out_invoice','Customer Invoice'),
			('in_invoice','Supplier Invoice'),
			('out_refund','Customer Refund'),
			('in_refund','Supplier Refund'),
		], 'Transaction Type', required=True ),
		'state': fields.selection((('n','Unconfirmed'),('c','Confirmed')),'State', required=True),
		'partner_id': fields.many2one('res.partner', 'Partner', relate=True),
		'project_id': fields.many2one('account.project', 'Profit/Cost center'),
		'line_id': fields.one2many('account.move.line', 'move_id', 'Transactions'),
		'change' : fields.boolean('Change transaction'),
	}
	_defaults = {
		'date': lambda *a: time.strftime('%Y-%m-%d'),
		'state': lambda *a: 'n'
	}
	def _constraint_sum(self, cr, uid, ids):
		cr.execute('SELECT a.currency_id FROM account_move m, account_move_line l, account_account a WHERE m.id=l.move_id AND l.account_id=a.id AND m.id IN ('+','.join(map(str, ids))+') GROUP BY a.currency_id')
		if len(cr.fetchall())>=2:
			return True
		cr.execute('SELECT abs(SUM(l.amount)) FROM account_move m LEFT JOIN account_move_line l ON (m.id=l.move_id) WHERE m.id IN ('+','.join(map(str, ids))+')')
		res = cr.fetchone()[0]
		return res<0.01
	_constraints = [
		(_constraint_sum, 'Error: the sum of all amounts should be zero.', ['name'])
	]
account_move()

class account_move_reconcile(osv.osv):
	_name = "account.move.reconcile"
	_description = "Account Reconciliation"
	_columns = {
		'name': fields.char('Name', size=64, required=True),
		'type': fields.char('Type', size=16, required=True),
		'line_id': fields.one2many('account.move.line', 'reconcile_id', 'Move lines'),
	}
	_defaults = {
		'name': lambda *a: 'reconcile '+time.strftime('%Y-%m-%d')
	}
account_move_reconcile()

class account_move_line(osv.osv):
	_name = "account.move.line"
	_description = "Account Move Entries"

	def _balance(self, cr, uid, ids, prop, unknow_none, unknow_dict):
		res={}
		# TODO group the foreach in sql
		for id in ids:
			cr.execute('SELECT date,account_id FROM account_move_line WHERE id=%d', (id,))
			dt,acc = cr.fetchone()
			cr.execute('SELECT SUM(amount) FROM account_move_line WHERE account_id=%d AND (date<%s OR (date=%s AND id<=%d))', (acc,dt,dt,id))
			res[id] = cr.fetchone()[0]
		return res

	_columns = {
		'name': fields.char('Name', size=64, required=True),
		'date': fields.date('Date'),
		'amount': fields.float('Amount', digits=(16,2), required=True),
		'account_id': fields.many2one('account.account', 'Account', required=True, ondelete="cascade"),
		'move_id': fields.many2one('account.move', 'Move', required=True, ondelete="cascade"),
		'reconcile_id': fields.many2one('account.move.reconcile', 'Reconcile'),
		'state': fields.selection((('n','Unconfirmed'),('c','Confirmed')),'State', required=True),
		# en trop mais on garde
		'partner_id': fields.many2one('res.partner', 'Partner Ref.'),
		'balance': fields.function(_balance, method=True, string='Balance')
	}
	_defaults = {
		'currency': lambda *a: 'EUR',
		'state': lambda *a: 'n',
		'date': lambda *a: time.strftime('%Y-%m-%d')
	}
	_order = "date desc,id desc"
	# cascade delete account_moves and account_move_reconciles when account_move_lines are deleted
	_sql = """
		create or replace rule "_account_move_reconcile" as on delete to account_move_line do delete from account_move_reconcile where id=OLD.reconcile_id;
		create or replace rule "_account_move_line" as on delete to account_move_line do delete from account_move where id=OLD.move_id;
	"""

	def reconcile(self, cr, uid, ids, type='auto'):
		id_set=','.join(map(str,ids))
		date = time.strftime('%Y-%m-%d')
		cr.execute('SELECT account_id,reconcile_id FROM account_move_line WHERE id IN ('+id_set+') GROUP BY account_id,reconcile_id')
		r=cr.fetchall()
#TODO: move this check to a constraint in the account_move_reconcile object
		if len(r)!=1:
			raise 'Transactions are not of the same account !'
		if r[0][1]!=None:
			raise 'Some transactions are already reconciled !'
		account_id=r[0][0]
		id = self.pool.get('account.move.reconcile').create(cr, uid, {'name':date, 'type':type, 'line_id':map(lambda x: (4,x,False), ids)})
		# the id of the move.reconcile is written in the move.line (self) by the create method above 
		# because of the way the line_id are defined: (4, x, False)
		self.write(cr,uid,ids,{'state':'c'})
		return id

account_move_line()


#----------------------------------------------------------
# Tax
#----------------------------------------------------------
"""
a documenter 
child_depend: la taxe depend des taxes filles
"""

class account_tax(osv.osv):
	"""
	A tax object.

	Type: percent, fixed, none, code
		PERCENT: tax = price * amount
		FIXED: tax = price + amount
		NONE: no tax line
		CODE: execute python code. localcontext = {'price_unit':pu, 'address':address_object}
			return result in the context
			Ex: result=round(price_unit*0.21,4)
	"""
	_name = 'account.tax'
	_description = 'Tax'
	_columns = {
		'name': fields.char('Tax Name', size=64, required=True),
		'amount': fields.float('Amount', required=True, digits=(14,4)),
		'active': fields.boolean('Active'),
		'type': fields.selection( [('percent','Percent'), ('fixed','Fixed'), ('none','None'), ('code','Python Code')], 'Tax Type', required=True),
		'applicable_type': fields.selection( [('true','True'), ('code','Python Code')], 'Applicable Type', required=True),
		'domain':fields.char('Domain', size=32),
		'account_collected_id':fields.many2one('account.account', 'Collected Tax Account', required=True),
		'account_paid_id':fields.many2one('account.account', 'Paid Tax Account', required=True),
		'parent_id':fields.many2one('account.tax', 'Parent Tax Account'),
		'child_ids':fields.one2many('account.tax', 'parent_id', 'Childs Tax Account'),
		'child_depend':fields.boolean('Tax depends on its children'),
		'python_compute':fields.text('Python Code'),
		'python_applicable':fields.text('Python Code'),
	}
	_defaults = {
		'python_compute': lambda *a: '''# price_unit\n# address : res.partner.address object or False\n\nresult = price_unit * 0.10''',
		'applicable_type': lambda *a: 1,
		'active': lambda *a: 1,
	}
	
	def applicable(self, cr, uid, ids, price_unit, address_id=None):
		if not ids:
			return []
		res = []
		for tax in self.read(cr, uid, ids):
			if tax['applicable_type']=='code':
				localdict = {'price_unit':price_unit, 'address':self.pool.get('res.partner.address').browse(cr, uid, address_id)[0]}
				exec tax['python_applicable'] in localdict
				if localdict.get('result', False):
					res.append(tax['id'])
			else:
				res.append(tax['id'])
		return res

	def _unit_compute(self, cr, uid, ids, price_unit, address_id=None):
		ids = self.applicable(cr, uid, ids, price_unit, address_id)
		if not len(ids):
			return []

		# fetches the objects with the given ids
		taxes = self.read(cr, uid, ids)
		res = []
		for tax in taxes:
			childs = self._unit_compute(cr, uid, tax['child_ids'], price_unit, address_id)
			amount_child_taxes = reduce(lambda x,y: x + y['amount'], childs, 0.0)

			# then we calculate the amount for the current tax object and append it to the result
			if tax['type']=='percent':
				amount = round((price_unit+amount_child_taxes)*tax['amount'],4)
				res.append({'id':tax['id'],'name':tax['name'], 'amount':amount, 'account_collected_id':tax['account_collected_id'], 'account_paid_id':tax['account_paid_id']})
			elif tax['type']=='fixed':
				res.append({'id':tax['id'],'name':tax['name'], 'amount':tax['amount'], 'account_collected_id':tax['account_collected_id'], 'account_paid_id':tax['account_paid_id']})
			elif tax['type']=='code':
				if address_id:
					localdict = {'price_unit':price_unit, 'address':self.pool.get('res.partner.address').browse(cr, uid, address_id)[0]}
				else:
					localdict = {'price_unit':price_unit, 'address':None}
				exec tax['python_compute'] in localdict
				amount = localdict['result']
				res.append({'id':tax['id'],'name':tax['name'], 'amount':amount, 'account_collected_id':tax['account_collected_id'], 'account_paid_id':tax['account_paid_id']})

			res.extend(childs)
		return res

	def compute(self, cr, uid, ids, price_unit, quantity, address_id=None):
		"""
		Compute tax values for given PRICE_UNIT, QUANTITY and a buyer/seller ADDRESS_ID.

		RETURN:
			[ tax ]
			tax = {'name':'', 'amount':0.0, 'account_collected_id':1, 'account_paid_id':2}
			one tax for each IDS tax and their childs
		"""
		res = self._unit_compute(cr, uid, ids, price_unit, address_id)
		for r in res:
			r['amount'] *= quantity
		return res
		
account_tax()

#----------------------------------------------------------
# Invoice
#----------------------------------------------------------
class account_invoice(osv.osv):
	def _amount_untaxed(self, cr, uid, ids, prop, unknow_none,unknow_dict):
		id_set=",".join(map(str,ids))
		cr.execute("SELECT s.id,COALESCE(SUM(l.price_unit*l.quantity),0) AS amount FROM account_invoice s LEFT OUTER JOIN account_invoice_line l ON (s.id=l.invoice_id) WHERE s.id IN ("+id_set+") GROUP BY s.id ")
		res=dict(cr.fetchall())
		return res

	def _amount_tax(self, cr, uid, ids, prop, unknow_none,unknow_dict):
#FIXME:	c'est n'importe quoi ce truc
		res={}
		for id in ids:
			res[id]=1.0
		return res

	def _amount_total(self, cr, uid, ids, prop, unknow_none,unknow_dict):
#FIXME:	c'est n'importe quoi ce truc
		return self._amount_untaxed(cr, uid, ids, prop, unknow_none,unknow_dict)

	_name = "account.invoice"
	_description = 'Invoices'
	_order = "number"
	_columns = {
		'name': fields.char('Invoice Description', size=128, required=True),
		'origin': fields.char('Origin', size=64),
		'type': fields.selection([
			('out_invoice','Customer Invoice'),
			('in_invoice','Supplier Invoice'),
			('out_refund','Customer Refund'),
			('in_refund','Supplier Refund'),
		],'Type', readonly=True, states={'draft':[('readonly',False)]}),

		'number': fields.char('Invoice Number', size=32, readonly=True),
		'reference': fields.char('Invoice Reference', size=64),
		'project_id':fields.many2one('account.project', 'Profit/Cost Ctr', readonly=True, states={'draft':[('readonly',False)]}),
		'comment': fields.text('Additionnal Information'),

		'state': fields.selection([
			('draft','Draft'),
			('proforma','Pro-forma'),
			('open','Open'),
			('paid','Paid'),
			('cancel','Canceled')
		],'State', readonly=True),
		
		'date_invoice':fields.date('Date Invoiced', required=True, readonly=True, states={'draft':[('readonly',False)]}),
		'date_due':fields.date('Due Date', readonly=True, states={'draft':[('readonly',False)]}),

		'partner_id':fields.many2one('res.partner', 'Partner', change_default=True, readonly=True, states={'draft':[('readonly',False)]}, relate=True),
		'address_contact_id':fields.many2one('res.partner.address', 'Contact Address', readonly=True, states={'draft':[('readonly',False)]}),
		'address_invoice_id':fields.many2one('res.partner.address', 'Invoice Address', readonly=True, states={'draft':[('readonly',False)]}),

		'partner_contact': fields.char('Partner Contact', size=64),
		'partner_ref': fields.char('Partner Reference', size=64),

		'payment_term': fields.selection((('no','No'), ('month','2% 10 Net 30')), 'Payment Term'),

		'account_id':fields.many2one('account.account', 'Dest Account', required=True),
		'invoice_line': fields.one2many('account.invoice.line', 'invoice_id', 'Invoice Lines', readonly=True, states={'draft':[('readonly',False)]}),
		'tax_line': fields.one2many('account.invoice.tax', 'invoice_id', 'Tax Lines', readonly=True, states={'draft':[('readonly',False)]}),

		'move_id': fields.many2one('account.move', 'Invoice Movement', readonly=True),
		'amount_untaxed': fields.function(_amount_untaxed, method=True, string='Untaxed Amount'),
		'amount_tax': fields.function(_amount_tax, method=True, string='Tax Amount'),
		'amount_total': fields.function(_amount_total, method=True, string='Total Amount'),
	}
	_defaults = {
		'type': lambda *a: 'out_invoice',
		'date_invoice': lambda *a: time.strftime('%Y-%m-%d'),
		'state': lambda *a: 'draft',
	}
	
	def unlink(self, cr, uid, ids):
		invoices = self.read(cr, uid, ids, ['state'])
		unlink_ids = []
		for t in invoices:
			if t['state'] in ('draft', 'cancel'):
				unlink_ids.append(t['id'])
			else:
				raise osv.except_osv('Invalid action !', 'Cannot delete invoice(s) which are already opened or paid !')
		osv.osv.unlink(self, cr, uid, unlink_ids)
		return True

#	def get_invoice_address(self, cr, uid, ids):
#		res = self.pool.get('res.partner').address_get(cr, uid, [part], ['invoice'])
#		return [{}]

	def onchange_partner_id(self, cr, uid, ids, type, part):
		invoice_addr_id = False
		contact_addr_id = False
		opt=[('uid',str(uid))]
		if part:
			opt.insert(0,('id',part))
			res = self.pool.get('res.partner').address_get(cr, uid, [part], ['contact','invoice'])
			contact_addr_id = res['contact']
			invoice_addr_id = res['invoice']
		if type in ('out_invoice','out_refund'):
			acc_id=ir.ir_get(cr,uid,'meta','account.receivable', [('res.partner',part)])[0][2]
		else:
			acc_id=ir.ir_get(cr,uid,'meta','account.payable', [('res.partner',part)])[0][2]
		return {'value':{'address_contact_id': contact_addr_id, 'address_invoice_id': invoice_addr_id, 'account_id':acc_id }}


	def refund(self, cr, uid, ids):
		invoices = self.read(cr, uid, ids, ['name', 'type', 'number', 'reference', 'project_id', 'comment', 'date_due', 'partner_id', 'address_contact_id', 'address_invoice_id', 'partner_contact', 'partner_insite', 'partner_ref', 'payment_term', 'account_id','invoice_line','tax_line'])

		new_ids = []
		for invoice in invoices:
			del invoice['id']
			
			type_dict = {
				'out_invoice': 'out_refund', # Customer Invoice
				'in_invoice': 'in_refund',   # Supplier Invoice
				'out_refund': 'out_invoice', # Customer Refund
				'in_refund': 'in_invoice',   # Supplier Refund
			}
			
			def cleanup_lines(lines):
				for line in lines:
					del line['id']
					del line['invoice_id']
					line['account_id'] = line['account_id'] and line['account_id'][0]
				return map(lambda x: (0,0,x), lines)
				
			invoice_lines = self.pool.get('account.invoice.line').read(cr, uid, invoice['invoice_line'])
			invoice_lines = cleanup_lines(invoice_lines)
			
			tax_lines = self.pool.get('account.invoice.tax').read(cr, uid, invoice['tax_line'])
			tax_lines = filter(lambda l: l['manual'], tax_lines)
			tax_lines = cleanup_lines(tax_lines)
			
			invoice.update({
				'type': type_dict[invoice['type']],
				'date_invoice': time.strftime('%Y-%m-%d'),
				'state': 'draft',
				'number': False,
				'invoice_line': invoice_lines,
				'tax_line': tax_lines
			})
			
			for field in ('address_contact_id','address_invoice_id','partner_id','project_id','account_id'):
				invoice[field] = invoice[field] and invoice[field][0]

			# create the new invoice
			new_ids.append(self.create(cr, uid, invoice))
		return new_ids
		
	# go from canceled state to draft state
	def action_cancel_draft(self, cr, uid, ids, *args):
		self.write(cr, uid, ids, {'state':'draft'})
		wf_service = netsvc.LocalService("workflow")
		for inv_id in ids:
			wf_service.trg_create(uid, 'account.invoice', inv_id, cr)
		return True

	# Workflow stuff
	#################

	# return the id of the first move line which has the same account than the invoice
	# whose id is in ids
	def move_line_id_payment_get(self, cr, uid, ids, *args):
		ml = self.pool.get('account.move.line')
		for inv in self.read(cr, uid, ids, ['move_id','account_id']):
			if inv['move_id']:
				move_line_id = ml.search(cr, uid, [('move_id','=',inv['move_id'][0])])
				for line in ml.read(cr, uid, move_line_id, ['account_id']):
					if line['account_id']==inv['account_id']:
						return (line['id'],)
		return False

#
# TODO: copy, with state='draft', number=''
#	def copy():
#		pass
#

	def test_paid(self, cr, uid, ids, *args):
		res = self.move_line_id_payment_get(cr, uid, ids)
		if not res:
			return False
		cr.execute('select reconcile_id from account_move_line where id=%d', (res[0],))
		return bool(cr.fetchone()[0])

	def action_move_create(self, cr, uid, ids, *args):
		id_set = ','.join([str(i) for i in ids])
		cr.execute('SELECT * FROM account_invoice WHERE move_id IS NULL AND id IN ('+id_set+')')
		for inv in cr.dictfetchall():
			# one move line per invoice line
			iml = self.pool.get('account.invoice.line').move_line_get(cr, uid, inv['id'])
			
			# one move line per tax line
			iml += self.pool.get('account.invoice.tax').move_line_get(cr, uid, inv['id'])
			
			# create one move line for the total and possibly adjust the other lines amount
			total = 0
			for i in iml:
				if inv['type'] in ('out_invoice','in_refund'):
					total += i['price']
					i['price'] = -i['price']
				else:
					total -= i['price']
			acc_id = inv['account_id']
			iml.append({ 'type':'dest', 'name':'Total', 'price': total, 'account_id':acc_id })

			date = inv['date_invoice']
			part = inv['partner_id']
			line = map(lambda x:(0,0,{ 'date':date, 'partner_id':part, 'name':x['name'], 'amount':x['price'], 'account_id':x['account_id'] }) ,iml)
			
			# create the move and all its lines
			invtype = dict(self._columns['type'].selection)[inv['type']]
			name = '%s, %s' % (invtype, inv['name'])
#FIXME: truncate name			
			move = { 'type': inv['type'], 'name': name, 'date': date, 'partner_id': part, 'project_id': inv['project_id'], 'line_id': line }
			move_id = self.pool.get('account.move').create(cr, uid, move)

			# make the invoice point to that move
			self.write(cr, uid, [inv['id']], {'move_id':move_id})
		self._log_event(cr, uid, ids)
		return True

	def action_number(self, cr, uid, ids, *args):
		cr.execute('SELECT id,type,move_id,number,name FROM account_invoice WHERE id IN ('+','.join(map(str,ids))+')')
		for (id,type,move_id,number,name) in cr.fetchall():
			if not number:
				number = self.pool.get('ir.sequence').get(cr, uid, 'account.invoice.'+type)
				cr.execute('UPDATE account_invoice SET number=%s WHERE id=%d', (number,id))

			if move_id:
				invtype = dict(self._columns['type'].selection)[type]
#TODO: faire le [:60] en python, pas sql
				name = '%s %s, %s' % (invtype, number or '', name)
				cr.execute('UPDATE account_move SET name=substring(%s,1,60) WHERE id=%d', (name,move_id))
		return True

	def action_cancel(self, cr, uid, ids, *args):
		invoices = self.read(cr, uid, ids, ['move_id'])
		for i in invoices:
			if i['move_id']:
				# delete the move this invoice was pointing to
				# Note that the corresponding move_lines and move_reconciles will be automatically deleted too
				self.pool.get('account.move').unlink(cr, uid, [i['move_id'][0]])
		self.write(cr, uid, ids, {'state':'cancel', 'move_id':False})
		self._log_event(cr, uid, ids,-1.0, 'Cancel Invoice')
		return True

	###################

	def list_distinct_taxes(self, cr, uid, ids):
		invoices = self.browse(cr, uid, ids)
		taxes = {}
		for inv in invoices:
			for tax in inv.tax_line:
				if not tax['name'] in taxes:
					taxes[tax['name']] = {'name':tax['name']}
		return taxes.values()

	def _log_event(self, cr, uid, ids, factor=1.0, name='Open Invoice'):
		invs = self.read(cr, uid, ids, ['type','partner_id'])
		for inv in invs:
			part=inv['partner_id'] and inv['partner_id'][0]
			pc = pr = 0.0
			cr.execute('select sum(quantity*price_unit) from account_invoice_line where invoice_id=%d', (inv['id'],))
			total = cr.fetchone()[0] or 0
			if inv['type'] in ('in_invoice','in_refund'):
				partnertype='supplier'
				eventtype = 'purchase'
				pc = total*factor
			else:
				partnertype = 'customer'
				eventtype = 'sale'
				pr = total*factor
			if self.pool.get('res.partner.event.type').check(cr, uid, 'account_invoice_open'):
				self.pool.get('res.partner.event').create(cr, uid, {'name':'Invoice: '+name, 'som':False, 'description':name+' '+str(inv['id']), 'document':name, 'partner_id':part, 'date':time.strftime('%Y-%m-%d %H:%M:%S'), 'canal_id':False, 'user_id':uid, 'partner_type':partnertype, 'probability':1.0, 'planned_revenue':pr, 'planned_cost':pc, 'type':eventtype})
		return len(invs)

#	def name_search(self, cr, user, name, args=[], operator='ilike'):
#		ids = self.search(cr, user, [('number','=',name)]+ args)
#		if not ids:
#			ids = self.search(cr, user, [('name',operator,name)]+ args)
#		return self.name_get(cr, user, ids)
account_invoice()

class account_invoice_line(osv.osv):
	def _amount_line(self, cr, uid, ids, prop, unknow_none,unknow_dict):
		res = {}
		for line in self.browse(cr, uid, ids):
			res[line.id] = line.price_unit * line.quantity
		return res
	_name = "account.invoice.line"
	_description = "Invoice line"
	_columns = {
		'name': fields.char('Description', size=128, required=True),
		'invoice_id': fields.many2one('account.invoice', 'Invoice Ref'),
		# TODO DOMAIN income or expense depending of invoice_id.type
		'account_id':fields.many2one('account.account', 'Source Account', required=True, domain=[('type','<>','view')]),
		'price_unit': fields.float('Unit Price', required=True),
		'price_subtotal': fields.function(_amount_line, method=True, string='Subtotal'),
		'quantity': fields.float('Quantity', required=True),
		'invoice_line_tax_id': fields.many2many('account.tax', 'account_invoice_line_tax', 'invoice_line_id', 'tax_id', 'Taxes'),
	}
	_defaults = {
		'quantity': lambda *a: 1
	}

	def move_line_get(self, cr, uid, invoice_id):
		type = self.pool.get('account.invoice').read(cr, uid, [invoice_id],['type'])[0]['type']
		res = []
		tax_grouped = {}
		cr.execute('SELECT * FROM account_invoice_line WHERE invoice_id=%d', (invoice_id,))
		for line in cr.dictfetchall():
			res.append({ 'type':'src', 'name':line['name'], 'price_unit':line['price_unit'], 'quantity':line['quantity'], 'price':round(line['quantity']*line['price_unit'],2), 'account_id':line['account_id'], })
			cr.execute('SELECT tax_id FROM account_invoice_line_tax WHERE invoice_line_id=%d', (line['id'],))
			for (tax_id,) in cr.fetchall():
				for c in self.pool.get('account.tax').compute(cr, uid, [tax_id], line['price_unit'],line['quantity']):
					if type in ('out_invoice','in_refund'):
						c['account_id']=c['account_collected_id']
					else:
						c['account_id']=c['account_paid_id']
					t=(c['id'],c['account_id'])
					if not t in tax_grouped:
						tax_grouped[t]=c
					else:
						tax_grouped[t]['amount']+=c['amount']
		# delete automatic tax lines for this invoice
		cr.execute("DELETE FROM account_invoice_tax WHERE NOT manual AND invoice_id=%d",(invoice_id,))
		# (re)create them
		ait = self.pool.get('account.invoice.tax')
		for t in tax_grouped.values():
			ait.create(cr, uid, {'invoice_id':invoice_id, 'name':t['name'], 'account_id':t['account_id'][0], 'amount':t['amount'], 'manual':False })
		return res
account_invoice_line()

class account_invoice_tax(osv.osv):
	_name = "account.invoice.tax"
	_description = "Invoice Tax"
	_columns = {
		'invoice_id': fields.many2one('account.invoice', 'Invoice Line', ondelete='cascade'),
		'name': fields.char('Tax Description', size=64, required=True),
		'account_id': fields.many2one('account.account', 'Taxe Account', required=True, domain=[('type','<>','view'),('type','<>','income')]),
		'amount': fields.float('Amount', digits=(16,2)),
		'manual': fields.boolean('Manual'),
	}
	_defaults = {
		'manual': lambda *a: 1,
	}
	def move_line_get(self, cr, uid, invoice_id):
		res = []
		cr.execute('SELECT * FROM account_invoice_tax WHERE invoice_id=%d', (invoice_id,))
		for t in cr.dictfetchall():
			res.append({'type':'tax','name':t['name'],'price_unit': t['amount'],'quantity': 1,'price': t['amount'] or 0.0,'account_id': t['account_id'], })
		return res

account_invoice_tax()

#----------------------------------------------------------
# Transfer
#----------------------------------------------------------
class account_transfer(osv.osv):
	_name = "account.transfer"
	_description = "Money Transfer"
	_columns = {
		'name': fields.char('Description', size=64, required=True),
		'state': fields.selection( (('draft','draft'),('posted','posted')),'State', readonly=True),
		'partner_id': fields.many2one('res.partner', 'Partner', states={'posted':[('readonly',True)]}),
		'project_id': fields.many2one('account.project', 'Profit/Cost Ctr', states={'posted':[('readonly',True)]}),
		'date': fields.date('Payment Date', required=True, states={'posted':[('readonly',True)]}),
		'type': fields.selection([
			('undefined','Undefined'),
			('in_payment','Incoming Customer Payment'),
			('out_payment','Outgoing Supplier Payment'),
			('expense', 'Direct Expense'),
			('transfer','Money Transfer'),
			('change','Currency Change'),
			('refund','Customer Refund'),
			('sale','Manual Sale'),
#			('expense reimburse','Remboursement Depense')
		], 'Transaction Type', required=True, states={'posted':[('readonly',True)]} ),
		'reference': fields.char('Reference',size=64),
		'account_src_id': fields.many2one('account.account', 'Source Account', required=True, states={'posted':[('readonly',True)]}),
		'account_dest_id': fields.many2one('account.account', 'Destination Account', required=True, states={'posted':[('readonly',True)]}),
		'amount': fields.float('Amount', digits=(16,2), required=True, states={'posted':[('readonly',True)]}),
		'change': fields.float('Amount Changed', digits=(16,2), states={'posted':[('readonly',True)]}, readonly=True),
		'move_id': fields.many2one('account.move', 'Transactions', readonly=True),
		'adjust_amount': fields.float('Adjustement amount', states={'posted':[('readonly',True)]}),
		'adjust_account_id': fields.many2one('account.account', 'Adjustement Account', states={'posted':[('readonly',True)]}),
		'invoice_id': fields.many2many('account.invoice','account_transfer_invoice','transfer_id','invoice_id','Invoices', states={'posted':[('readonly',True)]}, relate=True),
	}
	_defaults = {
		'date': lambda *a: time.strftime('%Y-%m-%d'),
		'state': lambda *a: 'draft',
	}

	def unlink(self, cr, uid, ids):
		transfers = self.read(cr, uid, ids, ['state'])
		unlink_ids = []
		for t in transfers:
			if t['state']=='draft':
				unlink_ids.append(t['id'])
			else:
				raise osv.except_osv('Invalid action !', 'Cannot delete transfer(s) which are already posted !')
		osv.osv.unlink(self, cr, uid, unlink_ids)
		return True

	def _onchange_type_domain(self,cr,uid,ids,type):
		type_acc={
			'in_payment': ('receivable','cash'),
			'out_payment': ('cash','payable'),
			'expense':  ('cash','expense'),
			'transfer': ('cash','cash'),
			'change':   ('cash','cash'),
			'refund':   ('receivable','income'),
			'sale':     ('income','cash'),
		}
		d={'account_src_id': [('type','<>','view'),('protected','<>',1)], 'account_dest_id': [('type','<>','view'),('protected','<>',1)]}
		if type_acc.has_key(type):
			d['account_src_id'].append(('type','=',type_acc[type][0]))
			d['account_dest_id'].append(('type','=',type_acc[type][1]))
		return d

	def onchange_type(self, cr, uid, ids, type):
		ro = {'change':type!='change',
			'adjust_amount': type not in ('in_payment','out_payment'),
			'adjust_account_id': type not in ('in_payment','out_payment')}
		d=self._onchange_type_domain(cr,uid,ids,type)
		return {'domain': d, 'value': {'account_src_id': False, 'account_dest_id': False}, 'readonly':ro  }

	def _onchange_account_domain(self,cr,uid,ids,type, account_src, account_dest):
		d=self._onchange_type_domain(cr,uid,ids,type)
		if type != 'change':
			if account_src and not account_dest:
				cr.execute("SELECT currency_id FROM account_account WHERE id=%d",(account_src,))
				d['account_dest_id'].append(('currency_id','=',cr.fetchall()[0][0]))
			if account_dest and not account_src:
				cr.execute("SELECT currency_id FROM account_account WHERE id=%d",(account_dest,))
				d['account_src_id'].append(('currency_id','=',cr.fetchall()[0][0]))
		return d

	def onchange_account(self, cr, uid, ids, type, account_src, account_dest):
		d=self._onchange_account_domain(cr,uid,ids,type,account_src,account_dest)
		return {'domain': d}

	def onchange_partner(self, cr, uid, ids, type, partner_id):
		if partner_id:
			value={}
			
			if type=='in_payment':
				a = ir.ir_get(cr,uid,'meta','account.receivable', [('res.partner',partner_id)])[0][2]
				value['account_src_id'] = a
				value['account_dest_id'] = False
				
				# compute the amount this partner owe us (the sum of all move lines which have not been matched)
				cr.execute("SELECT COALESCE(SUM(amount),0) from account_move_line where account_id=%d and partner_id=%d and reconcile_id is null", (a, partner_id))
				value['amount'] = cr.fetchone()[0]
				
				# get the new domain
				d = self._onchange_account_domain(cr,uid,ids,type, value['account_src_id'], value['account_dest_id'])
				
#CHECKME: faudrait decommenter ce code mais vu que je sais pas pq il a ete mis en commentaire a la base...
#faudrait aussi un onchange sur le invoice_id pour changer le montant si on retire des factures
# 
#				cr.execute("SELECT id from account_invoice where partner_id=%d and state IN ('open','proforma')", (partner_id,))
#				inv_ids=[i[0] for i in cr.fetchall()]
#				value['invoice_id']=inv_ids
				return {'domain': d, 'value': value}
				
			elif type=='out_payment':
				a = ir.ir_get(cr,uid,'meta','account.payable', [('res.partner',partner_id)])[0][2]
				value['account_src_id'] = False
				value['account_dest_id'] = a
				
				# compute the amount we owe this partner (the sum of all move lines which have not been matched)
				cr.execute("SELECT COALESCE(SUM(amount),0) from account_move_line where account_id=%d and partner_id=%d and reconcile_id is null", (a,partner_id))
				value['amount'] = -cr.fetchone()[0]

				# get the new domain
				d = self._onchange_account_domain(cr,uid,ids,type, value['account_src_id'], value['account_dest_id'])
				return {'domain': d, 'value': value}
				
		return self.onchange_type(cr,uid,ids, type)

	def pay_validate(self, cr, uid, ids, *args):
		transfers = self.read(cr, uid, ids)
		for pay in transfers:
			if pay['state']!='draft':
				continue
			name = pay['name']
			partner_id = (pay['partner_id'] or None) and pay['partner_id'][0]
			project_id = (pay['project_id'] or None) and pay['project_id'][0]

			# create two move lines (one for the source account and one for the destination account)
			l = {'name':name, 'date':pay['date'], 'state':'n', 'partner_id':partner_id }
			l1=l.copy()
			l2=l.copy()
			l1.update({'amount':-pay['amount'], 'account_id': pay['account_src_id'][0]})
			if pay['type']=='change':
				l2.update({'amount': pay['change'], 'account_id': pay['account_dest_id'][0]})
			else:
				l2.update({'amount': pay['amount'], 'account_id': pay['account_dest_id'][0]})
			line_id=[(0,0,l1), (0,0,l2)]

			# possibly create two more lines if there is an adjustment
			if pay['adjust_amount']:
				if pay['adjust_account_id']:
					la = l.copy()
					la.update({'name': name+' adjustment', 'amount': pay['adjust_amount'], 'account_id': pay['adjust_account_id'][0],})
					line_id.append((0,0,la))
					la = l.copy()
					la.update({'name': name+' adjustment', 'amount':-pay['adjust_amount'], 'account_id': pay['account_src_id'][0],})
					line_id.append((0,0,la))
				else:
					raise Exception('No Adjust Account !', 'missing adjust account')
					
			# create a new move and its 2 lines
			move=l.copy()
			move.update({'type': pay['type'], 'state': 'n', 'project_id': project_id, 'line_id': line_id})
			move_id = self.pool.get('account.move').create(cr, uid, move)
			
			# get account_id depending on the type of transfer
			tmp = {'in_payment':pay['account_src_id'][0], 'out_payment':pay['account_dest_id'][0]}
			account_id = tmp.get(pay['type'], None)
			
			if account_id and len(pay['invoice_id']):
				# get the ids of all moves lines which 1) use account_id 2) are not matched 3) correspond to the selected invoices
				inv_set = ",".join(map(str, pay["invoice_id"]))
				query  = "SELECT id FROM account_move_line "+\
				         "WHERE account_id=%d "+\
				         "AND reconcile_id is nuLL "+\
				         "AND move_id IN (SELECT move_id FROM account_invoice WHERE id IN ("+inv_set+"))"
				cr.execute(query, (account_id,))
				l_ids = [i[0] for i in cr.fetchall()]
				if not l_ids:
					print 'Error: no unmatched move line found for account %d and invoices %s while confirming transfer %d' % (account_id, pay['invoice_id'], pay['id'])
					continue
				
				# compute the sum of those lines
				l_set = ",".join(map(str, l_ids))
				cr.execute("SELECT SUM(amount) FROM account_move_line WHERE id IN (" + l_set + ")")
				s = cr.fetchone()[0]
				
				# if that amount = the amount paid, match those lines (from the selected invoices) with the current transfer
				types = {'out_payment': -1, 'in_payment': 1}
				sign = types.get(pay['type'], 1)
				if (s-(pay['adjust_amount'] or 0.0))==sign*pay['amount']:
					# get the id of the move_line for the current transfer
					cr.execute("SELECT id FROM account_move_line WHERE account_id=%d AND move_id=%d", (account_id,move_id))
					l_ids.append(cr.fetchall()[0][0])
					self.pool.get('account.move.line').reconcile(cr, uid, l_ids)
				else:
					raise osv.except_osv('Warning !', 'Could not confirm payment because its amount (%.2f) is different from the selected invoice(s) amount (%.2f) !' % (pay['amount'],s))
					
			elif account_id and partner_id:
				# compute the sum of all move lines for this account and partner which were not matched
				cr.execute("SELECT SUM(amount) FROM account_move_line WHERE account_id=%d AND partner_id=%d AND reconcile_id is null", (account_id, partner_id))
				s = cr.fetchone()[0]
				
				# if that amount is 0, we match those move lines together
				if s==0.0:
					cr.execute("select id from account_move_line where account_id=%d and partner_id=%d and reconcile_id is null", (account_id, partner_id))
					ids2 = [i[0] for i in cr.fetchall()]
					if len(ids2):
						self.pool.get('account.move.line').reconcile(cr, uid, ids2)

			# change transfer state and assign it its move
			self.write(cr, uid, [pay['id']], {'state':'posted', 'move_id': move_id})
		return True

	def pay_cancel(self, cr, uid, ids, *args):
		pays = self.read(cr, uid, ids)
		self.pool.get('account.move').unlink(cr, uid, [ x['move_id'][0] for x in pays if x['move_id']] )
		self.write(cr, uid, ids, {'state':'draft'})
		return True
account_transfer()

