##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#
# $Id: binary.py 2699 2006-04-11 12:13:58Z pinky $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import base64
import gtk
from gtk import glade

import interface
import os

import common

class wid_binary(interface.widget_interface):
	def __init__(self, window, parent, model, attrs={}):
		interface.widget_interface.__init__(self, window, parent, model, attrs)
		self.win_gl = glade.XML(common.terp_path("terp.glade"),"widget_binary")
		self.win_gl.signal_connect('on_but_new_clicked', self.sig_new)
		self.win_gl.signal_connect('on_but_open_clicked', self.sig_open)
		self.win_gl.signal_connect('on_but_remove_clicked', self.sig_remove)
		self.win_gl.signal_connect('on_but_save_as_clicked', self.sig_save_as)
		self.widget = self.win_gl.get_widget('widget_binary')

		self.wid_text = self.win_gl.get_widget('ent_binary')
		self.value=False

	def sig_new(self, widget=None):
		try:
			filename = common.file_selection(_('Select the file to attach'))
			self.value = base64.encodestring(file(filename).read())
			fname = self.attrs.get('fname_widget', False)
			if fname:
				self.parent.value = {fname:os.path.basename(filename)}
		except:
			common.message(_('Error reading the file'))

	def sig_save_as(self, widget=None):
		try:
			filename = common.file_selection(_('Save attachment as...'))
			fp = file(filename,'wb+')
			fp.write(base64.decodestring(self._value))
			fp.close()
		except:
			common.message(_('Error writing the file!'))

	def sig_open(self, widget=None):
		fname = self.attrs.get('fname_widget', False)
		common.start_content(base64.decodestring(self._value), fname)

	def sig_remove(self, widget=None):
		self.value = False
		fname = self.attrs.get('fname_widget', False)
		if fname:
			self.parent.value = {fname:False}

	def display(self, model_field):
		return True

	def _size_get(self, l):
		return str(l)+' octets'

	def set_value(self, model_field):
		return True
