##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# $Id: parse.py 1935 2005-12-23 13:52:39Z pinky $
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
import gobject
from xml.parsers import expat

import gettext

class parse(object):
	def __init__(self, fields):
		self.fields = fields
		self.fields_order = []
		self.on_change = {}

	def _psr_start(self, name, attrs):
		if name == 'tree':
			self.title = attrs.get('string', 'Tree')
			self.colors = attrs.get('colors', '')
			self.editable = attrs.get('editable', False)
			self.refresh = int(attrs.get('refresh', 0))
			if self.editable and self.editable in ('top', 'bottom'):
				self.create_new = self.editable
			elif self.editable in ('0', 0):
				self.editable = False
				self.create_new = False
			else:
				self.editable = True
				self.create_new = False
		elif name == 'field':
			if attrs.get('required', 'False') in ('False', '0', 'false', 'off'):
				self.fields[attrs['name']]['required'] = False
			self.fields_order.append(str(attrs['name']))
			self.on_change[attrs['name']] = attrs.get('on_change', None)
			if attrs.get('readonly', False) in ('1', 'True'):
				self.fields[attrs['name']]['readonly'] = True
		else:
			import logging
			logging.basicConfig()
			log = logging.getLogger('view')
			log.error(_('unknown tag: -%s-%s-') % (name,type(name)))
	
	def build_widget(self, tree):
		# Building the first column (reason for idx+1)
		cell = gtk.CellRendererText()
		cell.set_fixed_height_from_font(True)
		column = gtk.TreeViewColumn('ID', cell)
		column.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
		column.set_fixed_width(60)
		tree.append_column(column)
		
		#Building the other columns
		for idx, field in enumerate(self.fields_order):
			ftype= self.fields[field]['type']
			cell = gtk.CellRendererText()
			cell.set_fixed_height_from_font(True)
			if ftype == 'float':
				cell.set_property('xalign', 1.0)
			column = gtk.TreeViewColumn(self.fields[field]['string'], cell, text=idx+1)
			column.set_resizable(True)
			tree.append_column(column)
		
	def _psr_end(self, name):
		pass
	
	def _psr_char(self, char):
		pass
	
	def parse(self, xml_data):
		psr = expat.ParserCreate()
		psr.StartElementHandler = self._psr_start
		psr.EndElementHandler = self._psr_end
		psr.CharacterDataHandler = self._psr_char
		psr.Parse(xml_data)

# vim:noexpandtab:
