##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade

import rpc

class wid_int(object):
	def __init__(self, name, parent, attrs={}):
		self._value = None
		self._triggers = {}
		self.parent = parent
		self.name = name
		self.model = attrs.get('model', None)
		self.attrs = attrs

	def trigger_add(self, field, name, fnc, args=None):
		if field==[]:
			if name in self._triggers:
				self._triggers[name].append( (fnc, args) )
			else:
				self._triggers[name] = [ (fnc, args) ]

	def trigger(self, name, args):
		if name in self._triggers:
			res = None
			for x in self._triggers[name]:
				res = x[0](x[1], args)
			return res
		else:
			if self.parent:
				return self.parent.trigger(name, args)
			else:
				return None

	def clear(self):
		self.value = ''
		
	def _value_get(self):
		return self._value
		
	def _value_set(self, value):
		self._value = value
		
	value = property(_value_get, _value_set, None,
	  'The content of the widget or excpetion if not valid')

