##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import gtk
from gtk import glade

import common
import wid_common
import rpc
import re
import tools
import service

class wid_int(object):
	def __init__(self, parent, attrs={}):
		self._value = None
		self._triggers = {}
		for key in ('readonly','required'):
			if attrs.get(key):
				attrs[key] = attrs[key] not in ('False', '0')
		self.constraint = {'required':attrs.get('required',False), 'readonly':attrs.get('readonly',False), 'states':attrs.get('states', {})}
		self.parent = parent
		self._required_set(self.constraint['required'])
		self.state = 'draft'

		self.readonly = False
		self.window = None
		self.name = attrs.get('name', 'unknown')
		self.domain = attrs.get('domain', '')
		self.context = attrs.get('context', '')
		self.model = attrs.get('model', None)
		self.change_default = attrs.get('change_default', None)
		self.attrs = attrs
		self._menu_entries = [
			(_('Set to default value'), lambda x: self._menu_sig_default_get(), 1),
			(_('Set default'), lambda x: self._menu_sig_default_set(), 1),
			(None, None, None),
			(gtk.STOCK_CLEAR, lambda x: self.clear(),1),
		]

	def _value_get(self):
		return self._value

	def _value_set(self, value):
		self._value = value

	value2 = property(_value_get, _value_set, None,
	  'The content of the widget or exception if not valid')

	value = property(_value_get, _value_set, None,
	  'The content of the widget or exception if not valid')
	  
	def _window_get(self):
		if self.window:
			return self.window
		else:
			if self.parent:
				return self.parent._window_get()
			else:
				return None

	def _readonly_set(self, value):
		self.readonly = value

	def _required_set(self, value):
		self.required = value

	def clear(self):
		self.value = ''

	def _color_widget(self):
		return self.widget

	def color_set(self, name):
		colors = {'invalid':'#ffdddd', 'readonly':'grey', 'required':'#ddddff', 'normal':'white'}
		widget = self._color_widget()
		map = widget.get_colormap()
		colour = map.alloc_color(colors.get(name,'white'))
		style = widget.get_style().copy()
		style.base[gtk.STATE_NORMAL] = colour
		#style.base[gtk.STATE_ACTIVE] = colour
		style.bg[gtk.STATE_ACTIVE] = colour
		#style.text[gtk.STATE_ACTIVE] = gtk.gdk.color_parse("black")
		style.text[gtk.STATE_NORMAL] = gtk.gdk.color_parse("black")
		#style.fg[gtk.STATE_ACTIVE] = gtk.gdk.color_parse("black")
		style.fg[gtk.STATE_NORMAL] = gtk.gdk.color_parse("black")
		widget.set_style(style)

	def state_get(self, objstate=None):
		if not objstate:
			objstate = self.state
		else:
			self.state = objstate
		objst = self.constraint.copy()
		for st in self.constraint['states'].get(objstate,[]):
			objst[st[0]] = st[1]
		return objst

	def state_set(self, dynstate, objstate=None):
		objst = self.state_get(objstate)
		self._readonly_set( objst['readonly'] )
		self._required_set( objst['required'] )
		if dynstate=='invalid':
			self.color_set('invalid')
		elif objst['readonly']:
			self.color_set('readonly')
		elif objst['required']:
			self.color_set('required')
		else:
			self.color_set('normal')

	def validate(self):
		if self.constraint['required'] and not self.value:
			self.state_set('invalid')
			return False
		self.state_set('valid')
		return True

	def trigger_add(self, field, name, fnc, args=None):
		if field==[]:
			if name in self._triggers:
				self._triggers[name].append( (fnc, args) )
			else:
				self._triggers[name] = [ (fnc, args) ]

	def trigger(self, name, args):
		# name is the type of trigger (workflow_execute, object_execute, ...)
		# What does this return ?
		try:
			if name in self._triggers:
				res = None
				for x in self._triggers[name]:
					res = x[0](x[1], args)
				return res
			else:
				if self.parent:
					return self.parent.trigger(name, args)
				else:
					return None
		except rpc.rpc_exception, e:
			common.error(_('Error: ')+str(e.type), e.message, e.data)

	def _menu_sig_default_set(self):
		deps = []
		wid = self.parent.widgets
		for w in wid:
			if wid[w].change_default:
				deps.append((wid[w].attrs['string'], wid[w].attrs['name'], wid[w].value2, wid[w].value2))
		wid_common.field_pref_set(self.attrs['name'], self.attrs['string'], self.attrs['model'], self.value2, deps)

	def _menu_sig_default_get(self):
		res = rpc.session.rpc_exec_auth('/object', 'execute', self.attrs['model'], 'default_get', [self.attrs['name']])
		self.value = res.get(self.attrs['name'], False)

	def _menu_open(self, obj, event):
		obj = service.LocalService('gui.window')
		if event.button == 3:
			menu = gtk.Menu()
			for stock_id,callback,sensitivity in self._menu_entries:
				if stock_id:
					item = gtk.ImageMenuItem(stock_id)
					if callback:
						item.connect("activate",callback)
					item.set_sensitive(sensitivity)
				else:
					item=gtk.SeparatorMenuItem()
				item.show()
				menu.append(item)
			menu.popup(None,None,None,event.button,event.time)
			return True

	def _context_get(self, parent):
		arg = {}
		if self.context:
			for argument in self.context.split(','):
				(key,value) = argument.split('=')
				arg[str(key)]=self._expr_get(parent,value)
		return arg

	# this returns the domain for the field (widget)
	def _domain_get(self, parent):
		if not self.domain:
			return []
		d = parent.value2
		if parent.parent:
			d['parent'] = parent.parent.parent.value2
		return tools.expr_eval(self.domain, d)
		#FIXME: the preceding 'return' statement prevents the 5 last lines of this method to be executed
		if self.domain:
			for argument in self.domain.split(','):
				(key,value) = argument.split('=')
				arg.append((key,'=',self._expr_get(parent,value)))
		return arg

	def _expr_get(self, parent, expr):
		if expr[0]=="'":
			return expr
		return self._arg_get(parent, expr.split('.'))

	def _arg_get(self, parent, arg):
		if arg[0]=='parent':
			return self._arg_get(parent.parent.parent, arg[1:])
		elif arg[0]=='id':
			return parent.id
		elif arg[0]=='domain':
			return False
		else:
			if arg[0] in parent.value and parent.fields[arg[0]]['type'] == 'many2one':
				val = parent.value[arg[0]]
				if val:
					return val[0]
				return False
			else:
				return parent.value.get(arg[0], False)

	def _arg_set(self, widget, value, arg='value'):
		if len(widget):
			if widget[0]=='parent':
				self.parent.parent._arg_set(widget[1:], value, arg)
			else:
				self.parent._arg_set(widget, value, arg)
		else:
			if arg=='value':
				self.value = value
			elif arg=='domain':
				self.domain = value
			elif arg=='readonly':
				self._readonly_set(value)

	def _focus_in(self):
		self.focus = self.value

	def _focus_out(self):
		if self.value != self.focus:
			self.sig_changed()

	def sig_changed(self):
		if self.change_default:
			res = rpc.session.rpc_exec_auth('/object', 'execute', 'ir.values', 'get', 'default', self.name+'='+str(self.value2), [(self.attrs['model'],False)], False, rpc.session.context)
			processed = {}
			for (id,name,value) in res:
				if not name in processed:
					self._arg_set(name.split('.'), value)
					processed[name] = 1
		if self.attrs.get('on_change',False):
			self.on_change(self.attrs['on_change'])

	def on_change(self, query):
		try:
			# split the query in two parts: the function name and the arguments
			res = re.compile('(.*)\((.*)\)').match(query)
			if not res:
				raise 'ERROR: Wrong on_change trigger: fnc(*args)'
			func_name = res.group(1)
			arg_names = [n.strip() for n in res.group(2).split(',')]

			# for each argument, get its value
			args = map(lambda x: self._arg_get(self.parent, x.split('.')), arg_names)
			# execute the onchange method on the server
			res2 = rpc.session.rpc_exec_auth('/object', 'execute', self.attrs['model'], func_name, False, *args)
			for key in res2.keys():
				for wid in res2[key].keys():
					self._arg_set(wid.split('.'), res2[key][wid], key)
		except rpc.rpc_exception, e:
			pass

