##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#					Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import common
import wid_int
import gtk
import gobject
from gtk import glade


# Can be improved !!!

class selection(wid_int.wid_int):
	def __init__(self, parent, attrs={}):
		wid_int.wid_int.__init__(self, parent, attrs)

		win_gl = glade.XML(common.terp_path("terp.glade"),"widget_combobox")
		self.widget = win_gl.get_widget('widget_combobox')

		#self.widget = gtk.combo_box_entry_new_text()
		self.widget.child.connect('changed', self.sig_changed)
		self.widget.child.set_editable(False)
		self.widget.child.set_has_frame(False)
		self.widget.child.connect('button_press_event', self._menu_open)
		#self.widget.set_has_frame(False)

		self.ok = True
		self._selection={}
		self.set_popdown(attrs.get('selection',[]))

	def set_popdown(self, selection):
		model = gtk.ListStore(gobject.TYPE_STRING)
		self._selection={}
		lst = []
		for (i,j) in selection:
			name = str(j)
			if type(i)==type(1):
				name+=' ('+str(i)+')'
			lst.append(name)
			self._selection[name]=i
		for l in lst:
			i = model.append()
			model.set(i, 0, l)
		self.widget.set_model(model)
		self.widget.set_text_column(0)
		return lst

	def _readonly_set(self, value):
		wid_int.wid_int._readonly_set(self, value)
		self.widget.set_sensitive(not value)

	def _value_get(self):
		res = self.widget.child.get_text()
		return self._selection.get(res, False)

	def _value_set(self, value):
		self.ok = False
		if type(value)==type([]):
			pass # TODO
		else:
			if not value:
				self.widget.child.set_text('')
			else:
				for s in self._selection:
					if self._selection[s]==value:
						self.widget.child.set_text(s)
		self.ok = True

	def sig_changed(self, *args):
		if self.attrs.get('on_change',False) and self.value:
			if self.ok:
				self.on_change(self.attrs['on_change'])

	def _color_widget(self):
		return self.widget.child

	def clear(self):
		self.value = ''

	value2 = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')
	value = property(_value_get, _value_set, None,
	  'The content of the widget or ValueError if not valid')
