##############################################################################
#
# Copyright (c) 2004 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import logging
import pygtk
pygtk.require('2.0')

import gtk
from gtk import glade
from xml.parsers import expat

import sys
import wid_int
import gettext
import service
import common
import gobject
import rpc

class _container(object):
	def __init__(self, model):
		self.cont = []
		self.col = []
		self.sg = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
		self.model = model
		self.trans_box = []
	def new(self, col=4):
		table = gtk.Table(1, col)
		table.set_homogeneous(False)
		table.set_col_spacings(3)
		table.set_row_spacings(3)
		table.set_border_width(1)
		self.cont.append( (table, 0, 0) )
		self.col.append( col )

	def get(self):
		return self.cont[-1][0]
	def pop(self):
		(table, x, y) = self.cont.pop()
		self.col.pop()
		return table
	def newline(self):
		(table, x, y) = self.cont[-1]
		if x>0:
			self.cont[-1] = (table, 0, y+1)
		table.resize(y+1,self.col[-1])
	def wid_add(self, widget, l=1, name=None, expand=False, ypadding=2, rowspan=1, translate=False, fname=None):
		(table, x, y) = self.cont[-1]
		if l>self.col[-1]:
			l=self.col[-1]
		a = name and 1 or 0
		if l+x+a>self.col[-1]:
			self.newline()
			(table, x, y) = self.cont[-1]
		if expand:
			yopt = gtk.EXPAND | gtk.FILL
		else:
			yopt = False
		if name:
			label = gtk.Label(name)
			label.set_alignment(1.0, 0.5)
			if (self.col[-1]==4) and (x in (0,2)):
				label.set_size_request(120,-1)
				label.width_chars = 16
			table.attach(label, x, x+1, y, y+rowspan, yoptions=yopt, xoptions=0, ypadding=ypadding, xpadding=5)
			x=x+1
		hbox = widget
		hbox.show_all()
		if translate:
			hbox = gtk.HBox(spacing=3)
			hbox.pack_start(widget)
			img = gtk.Image()
			img.set_from_stock('terp-translate', gtk.ICON_SIZE_MENU)
			ebox = gtk.EventBox()
			ebox.set_events(gtk.gdk.BUTTON_PRESS_MASK)
			self.trans_box.append((ebox, name, fname, widget))
			
			ebox.add(img)
			hbox.pack_start(ebox, fill=False, expand=False)
			hbox.show_all()
		table.attach(hbox, x, x+l, y, y+rowspan, yoptions=yopt, ypadding=ypadding, xpadding=5)
		self.cont[-1] = (table, x+l, y)
		wid_list = table.get_children()
		wid_list.reverse()
		table.set_focus_chain(wid_list)

def hello_world(*args):
	pass

class parse_simple(object):
	def __init__(self, parent, fields, state='draft', model=''):
		self.state = state
		self.fields = fields
		self.parent = parent
		self.model = model
		self.buttons = []
	def _psr_start(self, name, attrs):
		if name=='form':
			self.title = attrs.get('string','Form')
			self.container.new(4)
		elif name=='field':
			if attrs.get('select', False):
				type = attrs.get('widget', self.fields[attrs['name']]['type'])
				self.fields[attrs['name']].update(attrs)
				self.fields[attrs['name']]['model']=self.model
				widget_act = widgets_type[ type ][0](self.parent, self.fields[attrs['name']])
				if ('string' in self.fields[attrs['name']]) and (type!='one2many'):
					label = self.fields[attrs['name']]['string']+' :'
				else:
					label = None
				if attrs.get('nolabel', False):
					label=None
				self.dict_widget[str(attrs['name'])] = widget_act
				size = int(attrs.get('colspan', widgets_type[ type ][1]))
				self.container.wid_add(widget_act.widget, size, label, int(self.fields[attrs['name']].get('expand',0)), translate=self.fields[attrs['name']].get('translate',False))

	def _psr_end(self, name):
		pass
	def _psr_char(self, char):
		pass
	def parse(self, xml_data, model):
		psr = expat.ParserCreate()
		psr.StartElementHandler = self._psr_start
		psr.EndElementHandler = self._psr_end
		psr.CharacterDataHandler = self._psr_char
		self.notebooks=[]
		self.container=_container(model)
		self.dict_widget={}
		psr.Parse(xml_data)
		self.widget = self.container.pop()
		self.widget.show_all()
		return self.dict_widget

class parse(object):
	def __init__(self, parent, fields, state='draft', model=''):
		self.state = state
		self.fields = fields
		self.parent = parent
		self.model = model
		self.buttons = []
		self.skip = []
		self.lst = []
		self.lst2 = []
		self.container = None
		self.first = None
		self.current_notebook=-1
		self.current_parent_notebook=-1
	def _psr_start(self, name, attrs):
		if (len(self.skip)) or (('state' in attrs) and (not self.state in attrs['state'].split(','))):
			self.skip.append(name)
			return
		if name=='form':
			self.title = attrs.get('string','Form')
			self.container.new(int(attrs.get('col',4)))
		elif name=='separator':
			vbox = gtk.VBox()
			if 'string' in attrs:
				l = gtk.Label(attrs['string'])
				l.set_alignment(0.0, 0.5)
				#l.set_padding(0.5, 0.5)
				vbox.pack_start(l)
			vbox.pack_start(gtk.HSeparator())
			self.container.wid_add(vbox,attrs.get('colspan',1),expand=int(attrs.get('expand',0)), ypadding=10)
		elif name=='label':
			l = gtk.Label(attrs['string'])
			self.container.wid_add(l,expand=int(attrs.get('expand',0)))
		elif name=='page':
			l = gtk.Label(attrs.get('string','Unknown'))
			self.container.new(int(attrs.get('col',4)))
			self.notebooks[self.current_notebook].append_page(self.container.get(), l)
#			self.container.newline()
			pass
		elif name=='newline':
			self.container.newline()
		elif name=='field':
			type = attrs.get('widget', self.fields[attrs['name']]['type'])
			self.fields[attrs['name']].update(attrs)
			self.fields[attrs['name']]['model']=self.model
			widget_act = widgets_type[ type ][0](self.parent, self.fields[attrs['name']])
			if self.fields[attrs['name']].get('string',False):
				label = self.fields[attrs['name']]['string']+' :'
			else:
				label = None
			if int(attrs.get('nolabel', 0)):
				label=None
			if not attrs['name'] in self.dict_widget:
#				self.dict_widget[str(attrs['name'])+"#1"] = widget_act
#			else:
				self.dict_widget[str(attrs['name'])] = widget_act
			size = int(attrs.get('colspan', widgets_type[ type ][1]))
			expand = widgets_type[ type ][2]
#			XML attribute to override expand ?
#			int(self.fields[attrs['name']].get('expand',0)) ?
			if type=='char':
				self.lst.append(widget_act.widget)
				self.lst2.append(attrs['name'])
			if not self.first:
				self.first = widget_act._color_widget()
			self.container.wid_add(widget_act.widget, size, label, expand, translate=self.fields[attrs['name']].get('translate',False), fname=attrs['name'])

		elif name=='button':
			button = gtk.Button(attrs.get('string', 'unknown'))
			button.set_use_stock(True)
			self.container.wid_add(button, attrs.get('colspan', 1), expand=int(attrs.get('expand',False)))
			button.show()
			states = attrs.get('states', '')
			if not len(states):
				states = None
			else:
				states = states.split(',')
			self.lst.append(button)
			self.lst2.append(attrs['name'])
			self.buttons.append({'widget':button, 'states':states, 'function':attrs['name'], 'state':'draft', 'type':attrs.get('type','workflow'), 'confirm':attrs.get('confirm', False)})

		elif name=='group':
			frame = gtk.Frame(attrs.get('string', None))
			frame.set_border_width(0)
#TODO: the rowspan attribute seem buggy... we should either fix it or remove it
# expand is a boolean?
			self.container.wid_add(frame, int(attrs.get('colspan', 1)), expand=int(attrs.get('expand',0)), rowspan=int(attrs.get('rowspan', 1)))
			self.container.new(int(attrs.get('col',4)))
			frame.add(self.container.get())
			if not attrs.get('string', None):
				frame.set_shadow_type(gtk.SHADOW_NONE)
				self.container.get().set_border_width(0)
		elif name=='notebook':
			self.current_parent_notebook = self.current_notebook
			self.current_notebook=len(self.notebooks)
			nb = gtk.Notebook()
			if attrs and 'tabpos' in attrs:
				pos = {'up':gtk.POS_TOP, 'down':gtk.POS_BOTTOM, 'left':gtk.POS_LEFT, 'right':gtk.POS_RIGHT}[attrs['tabpos']]
			else:
				pos = gtk.POS_LEFT
			nb.set_tab_pos(pos)
#TODO: a virer
			nb.connect('switch-page', hello_world)
			nb.set_border_width(3)
			self.notebooks.append(nb)
			self.container.wid_add(nb, attrs.get('colspan', 3), expand=True )#,expand=int(attrs.get('expand',0)))
			pass
		else:
			pass
	def _psr_end(self, name):
		if len(self.skip):
			self.skip.pop()
			return
		if name=='group':
			self.container.pop()
		if name=='page':
			self.container.pop()
		if name=='notebook':
			self.current_notebook = self.current_parent_notebook
	def _psr_char(self, char):
		pass
	def parse(self, xml_data):
		psr = expat.ParserCreate()
		psr.StartElementHandler = self._psr_start
		psr.EndElementHandler = self._psr_end
		psr.CharacterDataHandler = self._psr_char
		self.notebooks=[]
		self.container=_container(self.model)
		self.dict_widget={}
		psr.Parse(xml_data)
		self.widget = self.container.pop()
		self.widget.show_all()
		return self.dict_widget

class form(wid_int.wid_int):
	def __init__(self, xml, fields, model=None, triggers=[], parent=None, state="draft", window=None):
		self.widgets = {}
		wid_int.wid_int.__init__(self, parent)
		self.window = window
		for x in triggers:
			self.trigger_add([], x[0], x[1], x[2])
		parser = parse(self, fields, state=state, model=model)
		self.fields = fields
		self.model = model
		self.widgets = parser.parse(xml)
		for (ebox,src,name,widget) in parser.container.trans_box:
			ebox.connect('button_press_event',self.translate,  self.model, name, src, widget)
		self.widget = parser.widget
		self.buttons = parser.buttons
		self.first = parser.first
		self.id=None
		self.name=parser.title
		for button in self.buttons:
			button['widget'].connect("clicked", self._button_sig, button)

	def translate(self, widget, event, model, name, src, widget_entry):
		self.trigger('translate_signal', [self.id, model, name,src, widget_entry])
		return True
		
	def _button_sig(self, widget, button):
		if not button['confirm'] or common.sur(button['confirm']):
			if button['type']=='workflow':
				self.trigger('workflow_execute', (button['function'],self.model,self.id))
			elif button['type']=='object':
				self.trigger('object_execute', (button['function'],self.model,self.id))
			elif button['type']=='action':
				self.trigger('action_execute', (button['function'],self.model,self.id))
			else:
				raise 'Unallowed button type'

	def state_propagate(self, lst, state='invalid'):
		for name in lst:
			if name in self.widgets:
				self.widgets[name].state_set(state)

	#
	# Afficher button si pas de state
	#
	def state_set(self, dynstate, objstate=None):
		wid_int.wid_int.state_set(self, dynstate, objstate)
		for w in self.widgets.values():
			w.state_set(dynstate, objstate)
		for b in self.buttons:
#			b['widget'].show()
			if objstate:
				b['state']=objstate
				if (not b['states']) or (objstate in b['states']):
					b['widget'].show()
				else:
					b['widget'].hide()
			else:
				pass

	def validate(self):
		res= True
		for x in self.widgets:
			if not self.widgets[x].validate():
				logging.getLogger('view.form').info('Form not valid due to widget: '+str(x))
				res = False
		return res

	def clear(self):
		self.id=None
		for x in self.widgets.values():
			x.clear()
		self.state_set('normal', 'draft')

	def trigger_add(self, field, name, fnc, args=None):
		if field==[]:
			wid_int.wid_int.trigger_add(self, field, name, fnc, args)
		else:
			f = field.pop(0)
			self.widgets[f].trigger_add(field, name, fnc, args)

	def _value_get(self):
		res = {}
		for x in self.widgets:
			if not self.widgets[x].readonly:
				res[x]=self.widgets[x].value
		return res

	def _arg_set(self, widget, value, arg):
		if widget[0] in self.widgets:
			self.widgets[widget[0]]._arg_set([], value, arg)

	def _value_set(self, value):
		if 'id' in value:
			self.id = value['id']
		for x in value:
			if x!='id':
				if x in self.widgets:
					self.widgets[x].value = value[x]
		self.state_set('normal', value.get('state','draft')) #TODO: pinky why ?

	value = property(_value_get, _value_set, None, 'The content of the form or excpetion if not valid')

	def _value_get2(self):
		res = {}
		for x in self.widgets:
			if not self.widgets[x].readonly:
				res[x]=self.widgets[x].value2
		return res
	
	value2 = property(_value_get2)

import calendar
import spinbutton
import spinint
import char
import checkbox
import button
import reference
import binary
import textbox
import textbox_tag
import one2many
import many2many
import many2one, many2one_selection
import selection
import one2one
import one2many_list
import picture

widgets_type = {
	'date': (calendar.calendar, 1, False),
	'time': (calendar.stime, 1, False),
	'datetime': (calendar.datetime, 1, False),
	'float': (spinbutton.spinbutton, 1, False),
	'integer': (spinint.spinint, 1, False),
	'selection': (selection.selection, 1, False),
	'char': (char.char, 1, False),
	'boolean': (checkbox.checkbox, 1, False),
	'button': (button.button, 1, False),
	'reference': (reference.reference, 1, False),
	'binary': (binary.wid_binary, 1, False),
	'picture': (picture.wid_picture, 1, False),
	'text': (textbox.textbox, 1, True),
	'text_tag': (textbox_tag.textbox_tag, 1, True),
	'one2one': (one2one.one2one, 1, False),
	'one2many': (one2many_list.one2many_list, 1, True),
	'one2many_form': (one2many.one2many, 1, False),
	'one2many_list': (one2many_list.one2many_list, 1, True),
	'many2many': (many2many.many2many, 1, True),
	'many2one_selection': (many2one_selection.many2one_selection, 1, False),
	'many2one': (many2one.many2one, 1, False),
}

# vim:noexpandtab:tw=0
