/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GLOO_PULSE_BUTTON_H
#define GLOO_PULSE_BUTTON_H

#include <glib-object.h>
#include <gtk/gtkbutton.h>

G_BEGIN_DECLS

#define GLOO_TYPE_PULSE_BUTTON              (gloo_pulse_button_get_type ())
#define GLOO_PULSE_BUTTON(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), GLOO_TYPE_PULSE_BUTTON, GlooPulseButton))
#define GLOO_PULSE_BUTTON_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), GLOO_TYPE_PULSE_BUTTON, GlooPulseButtonClass))
#define GLOO_IS_PULSE_BUTTON(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GLOO_TYPE_PULSE_BUTTON))
#define GLOO_IS_PULSE_BUTTON_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GLOO_TYPE_PULSE_BUTTON))
#define GLOO_PULSE_BUTTON_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), GLOO_TYPE_PULSE_BUTTON, GlooPulseButtonClass))

typedef struct _GlooPulseButton GlooPulseButton;
typedef struct _GlooPulseButtonClass GlooPulseButtonClass;
typedef struct _GlooPulseButtonPrivate GlooPulseButtonPrivate;

struct _GlooPulseButton
{
	GtkButton parent;
	
	GlooPulseButtonPrivate *priv;
};

struct _GlooPulseButtonClass
{
	GtkButtonClass parent;
};

GType gloo_pulse_button_get_type (void);

void
gloo_pulse_button_start_pulsing (GlooPulseButton *self);
void
gloo_pulse_button_stop_pulsing (GlooPulseButton *self);
gboolean
gloo_pulse_button_is_pulsing (GlooPulseButton *self);

G_END_DECLS

#endif /* GLOO_PULSE_BUTTON_H */
