/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GLOO_PRESETS_H
#define GLOO_PRESETS_H

#include <glib-object.h>
#include <gtk/gtkliststore.h>

G_BEGIN_DECLS

#define GLOO_TYPE_PRESETS               (gloo_presets_get_type ())
#define GLOO_PRESETS(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), GLOO_TYPE_PRESETS, GlooPresets))
#define GLOO_PRESETS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), GLOO_TYPE_PRESETS, GlooPresetsClass))
#define GLOO_IS_PRESETS(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GLOO_TYPE_PRESETS))
#define GLOO_IS_PRESETS_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), GLOO_TYPE_PRESETS))
#define GLOO_PRESETS_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), GLOO_TYPE_PRESETS, GlooPresetsClass))

enum
{
	GLOO_PRESETS_NAME_COL,
	GLOO_PRESETS_DURATION_COL,
	GLOO_PRESETS_NUM_COLS
};

typedef struct _GlooPresets GlooPresets;
typedef struct _GlooPresetsClass GlooPresetsClass;
typedef struct _GlooPresetsPrivate GlooPresetsPrivate;

struct _GlooPresets
{
	GtkListStore parent;

	GlooPresetsPrivate *priv;
};

struct _GlooPresetsClass
{
	GtkListStoreClass parent;

	guint presets_changed_signal_id;
};

GType gloo_presets_get_type (void);

/**
 * Caller should free name when done.
 */
void
gloo_presets_get_name_and_duration (GlooPresets *self, GtkTreeRowReference *row_ref, gchar **name, guint *duration);

GtkTreeRowReference *
gloo_presets_add_preset (GlooPresets *self, const gchar *name, guint duration);

void
gloo_presets_update_preset (GlooPresets *self, GtkTreeRowReference *row_ref, const gchar *name, guint duration);

void
gloo_presets_remove_preset (GlooPresets *self, GtkTreeRowReference *row_ref);

G_END_DECLS

#endif /* GLOO_PRESETS_H */
