# Author:: Nathaniel Talbott.
# Copyright:: Copyright (c) 2000-2002 Nathaniel Talbott. All rights reserved.
# License:: Ruby license.

require 'test/unit/testcase'
require 'test/unit/testsuite'

module Test
  module Unit
    class TC_TestSuite < TestCase
      class TC_Suite1 < TestCase
        def test_succeed1
          assert_block { true }
        end
        def test_fail
          assert_block { false }
        end
      end
      
      class TC_Suite2 < TestCase
        def test_succeed2
          assert_block { true }
        end
        def test_error
          raise
        end
      end
      
      def test_size
        assert_block("The count should be correct") do
          suite = TestSuite.new
          suite2 = TestSuite.new
          suite2 << self.class.new("test_size")
          suite << suite2
          suite << self.class.new("test_size")
          suite.size == 2
        end
      end
      
      def test_run
        progress = []
        suite = TC_Suite1.suite
        result = TestResult.new
        suite.run(result) { |values| progress << values }
  
        assert_equal(2, result.run_count, "Should have had four test runs")
        assert_equal(1, result.failure_count, "Should have had one test failure")
        assert_equal(0, result.error_count, "Should have had one test error")
        assert_equal([[TestSuite::STARTED, suite.name],
                [TestCase::STARTED, "test_fail(#{suite.name})"],
                [TestCase::FINISHED, "test_fail(#{suite.name})"],
                [TestCase::STARTED, "test_succeed1(#{suite.name})"],
                [TestCase::FINISHED, "test_succeed1(#{suite.name})"],
                [TestSuite::FINISHED, suite.name]],
                progress, "Should have had the correct progress")
        
        suite = TestSuite.new
        suite << TC_Suite1.suite
        suite << TC_Suite2.suite
        result = TestResult.new
        progress = []
        suite.run(result) { |values| progress << values }
  
        assert_equal(4, result.run_count, "Should have had four test runs")
        assert_equal(1, result.failure_count, "Should have had one test failure")
        assert_equal(1, result.error_count, "Should have had one test error")
        assert_equal(14, progress.size, "Should have had the correct number of progress calls")
      end
      
      def test_empty?
        assert(TestSuite.new.empty?, "A new test suite should be empty?")
        assert(!TC_Suite2.suite.empty?, "A test suite with tests should not be empty")
      end
    end
  end
end
