/*

    File: file_itu.c

    Copyright (C) 2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "photorec.h"

static const char* header_check_itunes(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
static int data_check_itunes(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
static void file_check_itunes(t_file_recovery *file_recovery);

const t_file_hint file_hint_itunes= {
  .extension="itu",
  .description="iTunes",
  .min_header_distance=0,
  .min_filesize=0x68,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_itunes,
  .data_check=&data_check_itunes,
  .file_check=&file_check_itunes
};

static uint64_t itunes_file_size=0;

static const char* header_check_itunes(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  /* mhbd */
  if(buffer[0]=='m' && buffer[1]=='h' && buffer[2]=='b' && buffer[3]=='d' && buffer[4]==0x68 && buffer[5]==0x00 && buffer[6]==0x00 && buffer[7]==0x00)
  {
    itunes_file_size=(uint64_t)buffer[8]+(((uint64_t)buffer[9])<<8)+(((uint64_t)buffer[10])<<16)+(((uint64_t)buffer[11])<<24);
    return file_hint_itunes.extension;
  }
  return NULL;
}

static int data_check_itunes(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  if(file_recovery->file_size>=itunes_file_size)
  {
    file_recovery->file_size=itunes_file_size;
    return 2;
  }
  return 1;
}

static void file_check_itunes(t_file_recovery *file_recovery)
{
  if(file_recovery->file_size<itunes_file_size)
    file_recovery->file_size=0;
  else
    file_recovery->file_size=itunes_file_size;
}
