typedef struct dir_data t_dir_data;
typedef struct file_data t_file_data;
#define INTER_DIR 16
#define DIR_NAME_LEN 255
struct dir_data
{
  WINDOW *window;
  t_file_data *(*get_dir)(t_param_disk *disk_car, const t_partition *partition, t_dir_data *dir_data, const unsigned long int first_inode);
  int debug;
  void *private_dir_data;
  char current_directory[DIR_NAME_LEN];
};

struct file_data
{
  t_file_data *prev;
  t_file_data *next;
  char	name[DIR_NAME_LEN];
  struct stat filestat;
};

int dir_aff_log(const t_param_disk *disk_car, const t_partition *partition, const t_dir_data *dir_data, const t_file_data*dir_list);
void delete_list_file(t_file_data *file_list);
int dir_partition(t_param_disk *disk_car, const t_partition *partition, t_dir_data *dir_data, const unsigned long int inode);
void mode_string (const unsigned int mode, char *str);

#define LINUX_S_IFMT  00170000
#define LINUX_S_IFSOCK 0140000
#define LINUX_S_IFLNK    0120000
#define LINUX_S_IFREG  0100000
#define LINUX_S_IFBLK  0060000
#define LINUX_S_IFDIR  0040000
#define LINUX_S_IFCHR  0020000
#define LINUX_S_IFIFO  0010000
#define LINUX_S_ISUID  0004000
#define LINUX_S_ISGID  0002000
#define LINUX_S_ISVTX  0001000


#define LINUX_S_IRWXU 00700
#define LINUX_S_IRUSR 00400
#define LINUX_S_IWUSR 00200
#define LINUX_S_IXUSR 00100

#define LINUX_S_IRWXG 00070
#define LINUX_S_IRGRP 00040
#define LINUX_S_IWGRP 00020
#define LINUX_S_IXGRP 00010

#define LINUX_S_IRWXO 00007
#define LINUX_S_IROTH 00004
#define LINUX_S_IWOTH 00002
#define LINUX_S_IXOTH 00001

#define LINUX_S_IRWXUGO       (LINUX_S_IRWXU|LINUX_S_IRWXG|LINUX_S_IRWXO)
#define LINUX_S_IALLUGO       (LINUX_S_ISUID|LINUX_S_ISGID|LINUX_S_ISVTX|LINUX_S_IRWXUGO)
#define LINUX_S_IRUGO         (LINUX_S_IRUSR|LINUX_S_IRGRP|LINUX_S_IROTH)
#define LINUX_S_IWUGO         (LINUX_S_IWUSR|LINUX_S_IWGRP|LINUX_S_IWOTH)
#define LINUX_S_IXUGO         (LINUX_S_IXUSR|LINUX_S_IXGRP|LINUX_S_IXOTH)

#define LINUX_S_ISLNK(m)        (((m) & LINUX_S_IFMT) == LINUX_S_IFLNK)
#define LINUX_S_ISREG(m)        (((m) & LINUX_S_IFMT) == LINUX_S_IFREG)
#define LINUX_S_ISDIR(m)        (((m) & LINUX_S_IFMT) == LINUX_S_IFDIR)
#define LINUX_S_ISCHR(m)        (((m) & LINUX_S_IFMT) == LINUX_S_IFCHR)
#define LINUX_S_ISBLK(m)        (((m) & LINUX_S_IFMT) == LINUX_S_IFBLK)
#define LINUX_S_ISFIFO(m)       (((m) & LINUX_S_IFMT) == LINUX_S_IFIFO)
#define LINUX_S_ISSOCK(m)       (((m) & LINUX_S_IFMT) == LINUX_S_IFSOCK)


