/*
 * taken from ReiserFS v0.91. Reiserfs Copyright 1996, 1997, 1998 Hans Reiser
 */

#define REISERFS_SUPER_MAGIC		"ReIsErFs"
#define REISERFS2_SUPER_MAGIC		"ReIsEr2Fs"
#define REISERFS3_SUPER_MAGIC		"ReIsEr3Fs"
#define REISERFS_FIRST_BLOCK		8
#define REISERFS_VALID_FS		1
#define REISERFS_ERROR_FS		2
#define REISERFS_MIN_BLOCK_AMOUNT	100

struct reiserfs_super_block
{
	__u32 s_block_count;		/* blocks count         */
	__u32 s_free_blocks;		/* free blocks count    */
	__u32 s_root_block;		/* root block number    */
	__u32 s_journal_block;		/* journal block number    */
	__u32 s_journal_dev;		/* journal device number  */
	__u32 s_orig_journal_size;	/* size of the journal on FS creation.  used to make sure they don't overflow it */
	__u32 s_journal_trans_max;	/* max number of blocks in a transaction.  */
	__u32 s_journal_block_count;	/* total size of the journal. can change over time  */
	__u32 s_journal_max_batch;	/* max number of blocks to batch into a trans */
	__u32 s_journal_max_commit_age;	/* in seconds, how old can an async commit be */
	__u32 s_journal_max_trans_age;	/* in seconds, how old can a transaction be */
	__u16 s_blocksize;		/* block size           */
	__u16 s_oid_maxsize;		/* max size of object id array, see get_objectid() commentary  */
	__u16 s_oid_cursize;		/* current size of object id array */
	__u16 s_state;			/* valid or error       */
	char s_magic[10];		/* reiserfs magic string indicates that file system is reiserfs */
	__u16 sb_fs_state; 		/* 62 it is set to used by fsck to mark which phase of
				   rebuilding is done (used for fsck debugging) */
	__u32 s_hash_function_code;	/* indicate, what hash fuction is being use to sort names in a directory*/
	__u16 s_tree_height;		/* height of disk tree */
	__u16 s_bmap_nr;		/* amount of bitmap blocks needed to address each block of file system */
	__u16 sb_version; 		/* 72 this field is only reliable on
					   filesystem with non-standard journal */
	__u16 sb_reserved_for_journal;  /* 74 size in blocks of journal area on
					   main device, we need to keep after
					   non-standard journal relocation */
/* 76 */     __u32 sb_inode_generation; 
/* 80 */     __u32 s_flags;                /* Right now used only by inode-attributes, if enabled */
/* 84 */    unsigned char s_uuid[16];      /* filesystem unique identifier */
/*100 */    unsigned char s_label[16];     /* filesystem volume label */
/*116 */    char s_unused[88] ;            /* zero filled by mkreiserfs and reiserfs_convert_objectid_map_v1()
                                            * so any additions must be updated there as well. */ 
/*204*/
} __attribute__ ((__packed__));

#define SB_SIZE (sizeof(struct reiserfs_super_block))

int check_rfs(t_param_disk *disk_car,t_diskext *partition,const int debug);
int recover_rfs(t_param_disk *disk_car, const struct reiserfs_super_block *sb,t_diskext *partition,const int debug, const int dump_ind);
int dir_partition_reiser(WINDOW *window,t_param_disk *disk_car,t_diskext *partition, const int debug);

