/*

    File: common.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdlib.h>
#include <stdio.h>
#include <stdlib.h>	/* malloc */
#include <stdarg.h>
#include "types.h"
#include "common.h"
#include "lang.h"
#include <ctype.h>      /* toupper, tolower */
#include <string.h>	/* memset */

static unsigned int up2power_aux(const unsigned int number);

void *MALLOC(size_t size)
{
  void *res;
  if(size==0)
  {
    ecrit_rapport("Try to allocate 0 byte of memory\n");
    exit(EXIT_FAILURE);
  }
  if((res=malloc(size))==NULL)
  {
    ecrit_rapport(msg_MALLOC_ERROR);
    exit(EXIT_FAILURE);
  }
  memset(res,0,size);
  return res;
}

void FREE(void *ptr)
{
  if(ptr==NULL)
  {
    wdoprintf(stdscr,msg_FREE_ERROR);
    exit(EXIT_FAILURE);
  }
  free(ptr);
}

#ifndef HAVE_SNPRINTF
int snprintf(char *str, size_t size, const char *format, ...)
{
  int res;
  va_list ap;
  va_start(ap,format);
  res=vsnprintf(str, size, format, ap);
  va_end(ap);
  return res;
}
#endif

#ifndef HAVE_VSNPRINTF
int vsnprintf(char *str, size_t size, const char *format, va_list ap)
{
  return vsprintf(str,format,ap);
}
#endif

unsigned int up2power(const unsigned int number)
{
/*  ecrit_rapport("up2power(%u)=>%u\n",number, (1<<up2power_aux(number-1))); */
  return (1<<up2power_aux(number-1));
}

static unsigned int up2power_aux(const unsigned int number)
{
  if(number==0)
	return 0;
  else
	return(1+up2power_aux(number/2));
}

int check_volume_name(const char *name,const unsigned int max_size)
{
  unsigned int i;
  for(i=0;name[i]!='\0' && i<max_size;i++)
  {
    if((name[i]>=0x6 && name[i]<=0x1f)||
	(name[i]>=0x3A && name[i]<=0x3f))
      return 1;
    switch(name[i])
    {
      case 0x1:
      case 0x2:
      case 0x3:
      case 0x4:
      case 0x22:
      case 0x2A:
      case 0x2B:
      case 0x2C:
/*     case 0x2E: Pas sur */
      case 0x2F:
      case 0x5B:
      case 0x5C:
      case 0x5D:
      case 0x7C:
/*     case 'a' ... 'z': */
	return 1;
    }
  }
  return 0; /* Ok */
}

void set_part_name(t_diskext *partition,const char *src,const int max_size)
{
  int i;
  for(i=0;(i<max_size) && (src[i]!=(char)0);i++)
    partition->name[i]=src[i];
  partition->name[i--]='\0';
  for(;(i>=0) && (src[i]==' ');i--);
  partition->name[i+1]='\0';
}

