Summary: A simple template system
Name: new
Version: 1.3.5
Release: 1
License: GPL
Group: Development/Tools
Source: http://www.flyn.org/projects/%name/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
URL: http://www.flyn.org
Requires: zlib
BuildRequires: glib2-devel, zlib-devel

%description
New is a template system, especially useful in conjunction with a 
simple text editor such as vi. The user maintains templates which 
may contain format strings. At run time, new replaces the format 
strings in a template with appropriate values to create a new file.

For example, given the following template:


//   FILE: %%(FILE)
// AUTHOR: %%(FULLNAME)
//   DATE: %%(DATE)

// Copyright (C) 1999 %(FULLNAME) %(EMAIL)
// All rights reserved.
new will create:


//   FILE: foo.cpp
// AUTHOR: W. Michael Petullo
//   DATE: 11 September 1999

// Copyright (C) 1999 W. Michael Petullo new@flyn.org
// All rights reserved.
on my computer.

The program understands plaintext or gziped template files.

Building new also creates a shared library, libnewtemplate, which 
allows the programmer access to new's functionality.



%prep


%setup


%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-, root, root)
%{_bindir}/new
%{_bindir}/new_proj
%{_libdir}/pkgconfig/new.pc
%{_libdir}/libnewfmt_ptrn.so
%{_libdir}/libnewfmt_ptrn.so.1
%{_libdir}/libnewfmt_ptrn.so.%{PACKAGE_VERSION}
%{_libdir}/libnewtemplate.so
%{_libdir}/libnewtemplate.so.1
%{_libdir}/libnewtemplate.so.%{PACKAGE_VERSION}
%{_includedir}/new
%{_includedir}/new/fmt_ptrn.h
%{_includedir}/new/modifiers.h
%{_includedir}/new/buffer.h
%{_includedir}/new/template.h
%{_includedir}/new/common.h
%{_includedir}/new/pair.h
%{_datadir}/new
%{_datadir}/new/templates
%{_datadir}/new/templates/header_doc
%{_datadir}/new/templates/header_gpl
%{_datadir}/new/templates/AUTHORS
%{_datadir}/new/templates/AUTHORS/default
%{_datadir}/new/templates/COPYING
%{_datadir}/new/templates/COPYING/default
%{_datadir}/new/templates/ChangeLog
%{_datadir}/new/templates/ChangeLog/default
%{_datadir}/new/templates/INSTALL
%{_datadir}/new/templates/INSTALL/default
%{_datadir}/new/templates/NEWS
%{_datadir}/new/templates/NEWS/default
%{_datadir}/new/templates/README
%{_datadir}/new/templates/README/default
%{_datadir}/new/templates/c
%{_datadir}/new/templates/c/default
%{_datadir}/new/templates/c/gnome_applet
%{_datadir}/new/templates/c/lib
%{_datadir}/new/templates/cld
%{_datadir}/new/templates/cld/default
%{_datadir}/new/templates/cpp
%{_datadir}/new/templates/cpp/default
%{_datadir}/new/templates/java
%{_datadir}/new/templates/java/default
%{_datadir}/new/templates/h
%{_datadir}/new/templates/h/default
%{_datadir}/new/templates/h/lib
%{_datadir}/new/templates/html
%{_datadir}/new/templates/html/default
%{_datadir}/new/templates/html/slide
%{_datadir}/new/templates/inv
%{_datadir}/new/templates/inv/default
%{_datadir}/new/templates/lsp
%{_datadir}/new/templates/lsp/default
%{_datadir}/new/templates/missing
%{_datadir}/new/templates/missing/default
%{_datadir}/new/templates/pl
%{_datadir}/new/templates/pl/default
%{_datadir}/new/templates/py
%{_datadir}/new/templates/py/default
%{_datadir}/new/templates/scm
%{_datadir}/new/templates/scm/default
%{_datadir}/new/templates/sh
%{_datadir}/new/templates/sh/default
%{_datadir}/new/templates/tex
%{_datadir}/new/templates/tex/default
%{_datadir}/new/templates/tex/jewel_map
%{_datadir}/new/templates/tex/letter
%{_datadir}/new/templates/tex/resume
%{_datadir}/new/templates/tex/slideshow
%{_datadir}/new/templates/txt
%{_datadir}/new/templates/txt/default
%doc %{_mandir}


%doc	AUTHORS COPYING ChangeLog INSTALL NEWS README FAQ


%changelog
* Sun Dec 11 2005 W. Michael Petullo <mike[@]flyn.org> - 1.3.5-1
   - Updated to new 1.3.5.




