using System;
using System.Collections;
using System.Collections.Generic;
using NDesk.DBus;
using org.freedesktop.DBus;
using org.freedesktop.Telepathy;

public class Test
{
	static IConnection iconn;
	static ConnectionInfo conn;
  	static Bus bus = Bus.Session;
	static bool running = true;

	public static void OnConnectionStateChanged (ConnectionStatus status, ConnectionStatusReason reason)
	{
		Console.WriteLine ("Connection state changed, Status: {0}, Reason: {1}", status, reason);

		if (status == ConnectionStatus.Connected)
		{
			string[] args = {"subscribe"};
			uint[] handles = iconn.RequestHandles (HandleType.List, args);
			ObjectPath object_path = iconn.RequestChannel (ChannelType.ContactList, HandleType.List, handles[0], true);
			IChannelGroup contact_list = bus.GetObject<IChannelGroup> (conn.BusName, object_path);
			uint[] members = contact_list.Members;
			string[] members_str = iconn.InspectHandles (HandleType.Contact, members);

			foreach (string member in members_str)
				Console.WriteLine ("Member: {0}", member);

			iconn.Disconnect ();
		}

    if (status == ConnectionStatus.Disconnected)
      running = false;
	}

	public static void Main (string [] args)
	{
		if (args.Length < 2) {
			Console.WriteLine ("Invalid Args");
			return;
		}


		//get connection manager from dbus
		IConnectionManager conn_manager = bus.GetObject<IConnectionManager> ("org.freedesktop.Telepathy.ConnectionManager.gabble",
			new ObjectPath ("/org/freedesktop/Telepathy/ConnectionManager/gabble"));

	    if (conn_manager == null) {
    	  	Console.WriteLine ("Erro on get cm");
			return;
		}

		Console.WriteLine ("Account: {0}\nPassowrd: ?\nServer: {1}\nPort: {2}", args[0], args[2],  UInt32.Parse (args[3]));
		Dictionary<string, object> option_list = new Dictionary<string, object>();
		option_list.Add ("account", args[0]);
		option_list.Add ("password", args[1]);
		option_list.Add ("server", args[2]);
		option_list.Add ("port", (uint) UInt32.Parse (args[3]));
		option_list.Add ("old-ssl", true);
		option_list.Add ("ignore-ssl-errors", true);

		conn = conn_manager.RequestConnection ("jabber", option_list);

		Console.WriteLine ("Bus Name: " + conn.BusName + ", " + conn.ObjectPath);
		iconn = bus.GetObject<IConnection> (conn.BusName, conn.ObjectPath);

		iconn.StatusChanged += OnConnectionStateChanged;
		iconn.Connect ();

		while (running)
			bus.Iterate ();
	}
}
