/*
 * time.c -- manages timestamps
 * Part of the tcpick project
 *
 * Author: Francesco Stablum <duskdruid @ despammed.com>
 *
 * Copyright (C) 2003, 2004  Francesco Stablum
 * Licensed under the GPL
 *
 */

/* 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at you option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111,
 * USA.
 */
#include "tcpick.h"
#include "extern.h"

char * get_actual_time()
{
  struct timeval *tp=(struct timeval *)S_calloc(1,sizeof(struct timeval));
  struct timezone *tzp=(struct timezone *)S_calloc(1,sizeof(struct timezone));
  struct tm * brokentime;
  if(gettimeofday(tp, tzp))
    {
      perror("gettimeofday returned not 0!");
      return(NULL);
    }
  else
    {
      brokentime=localtime(&(tp->tv_sec));
      return asctime(brokentime);
    }
}

char * get_numbered_time(char * ret)
{

  struct timeval *tp=(struct timeval *)S_calloc(1,sizeof(struct timeval));
  struct timezone *tzp=(struct timezone *)S_calloc(1,sizeof(struct timezone));
  struct tm * brokentime;
  if(gettimeofday(tp, tzp))
    {
      perror("gettimeofday returned not 0!");
      return(NULL);
    }
  else
    {
      brokentime=localtime(&(tp->tv_sec));
      sprintf(ret,"%2.2d:%2.2d:%2.2d.%6.6d",
	      brokentime->tm_hour,
	      brokentime->tm_min,
	      brokentime->tm_sec,
	      tp->tv_usec
	      );
      return ret;
    }
}
