/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.AtomicEvent;
import edu.uoregon.tau.dms.dss.AtomicLocationProfile;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.IntervalEvent;
import edu.uoregon.tau.dms.dss.IntervalLocationProfile;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.NCT;
import edu.uoregon.tau.dms.dss.Trial;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;

public abstract class DataSession {
    protected Application application = null;
    protected Experiment experiment = null;
    protected Trial trial = null;
    protected Vector nodes = null;
    protected Vector contexts = null;
    protected Vector threads = null;
    protected Vector intervalEvents = null;
    protected Vector metrics = null;
    protected Vector intervalEventData = null;
    protected Vector atomicEvents = null;
    protected Vector atomicEventData = null;
    public static int PERFDMF_NONE = -1;
    private GlobalMapping globalMapping = null;
    private NCT nct = null;

    public abstract void initialize(Object var1);

    public abstract void terminate();

    public abstract ListIterator getApplicationList();

    public Application getApplication() {
        return this.application;
    }

    public abstract ListIterator getExperimentList();

    public Experiment getExperiment() {
        return this.experiment;
    }

    public abstract ListIterator getTrialList();

    public Trial getTrial() {
        return this.trial;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public abstract Application setApplication(int var1);

    public abstract Application setApplication(String var1, String var2);

    public void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    public abstract Experiment setExperiment(int var1);

    public void setTrial(Trial trial) {
        this.trial = trial;
    }

    public abstract Trial setTrial(int var1);

    public void setNode(int n) {
        if (n == PERFDMF_NONE) {
            this.nodes = null;
        } else {
            Integer n2 = new Integer(n);
            this.nodes = new Vector();
            this.nodes.addElement(n2);
        }
    }

    public void setNode(Vector vector) {
        this.nodes = vector;
    }

    public void setContext(int n) {
        if (n == PERFDMF_NONE) {
            this.contexts = null;
        } else {
            Integer n2 = new Integer(n);
            this.contexts = new Vector();
            this.contexts.addElement(n2);
        }
    }

    public void setContext(Vector vector) {
        this.contexts = vector;
    }

    public void setThread(int n) {
        if (n == PERFDMF_NONE) {
            this.threads = null;
        } else {
            Integer n2 = new Integer(n);
            this.threads = new Vector();
            this.threads.addElement(n2);
        }
    }

    public void setThread(Vector vector) {
        this.threads = vector;
    }

    public void setMetric(Metric metric) {
        if (metric == null) {
            this.metrics = null;
        } else {
            this.metrics = new Vector();
            this.metrics.addElement(metric);
        }
    }

    public void setMetrics(Vector vector) {
        this.metrics = vector;
    }

    public int addMetric(Metric metric) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null) {
            int n = -1;
            Enumeration enumeration = this.metrics.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Metric metric2 = (Metric)enumeration.nextElement();
                if (metric2.equals(metric)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == -1) {
                metric.setID(this.getNumberOfMetrics());
                this.metrics.add(metric);
            } else {
                metric.setID(((Metric)this.metrics.elementAt(n)).getID());
            }
            return metric.getID();
        }
        return -1;
    }

    public Vector getMetrics() {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        return this.metrics;
    }

    public Metric getMetric(int n) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null && n < this.metrics.size()) {
            return (Metric)this.metrics.elementAt(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null && n < this.metrics.size()) {
            return ((Metric)this.metrics.elementAt(n)).getName();
        }
        return null;
    }

    public int getMetricID(String string) {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null) {
            Enumeration enumeration = this.metrics.elements();
            while (enumeration.hasMoreElements()) {
                Metric metric = (Metric)enumeration.nextElement();
                if (!metric.getName().equals(string)) continue;
                return metric.getID();
            }
        }
        return -1;
    }

    public int getNumberOfMetrics() {
        if (this.metrics == null && this.trial != null) {
            this.metrics = this.trial.getMetrics();
        }
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return -1;
    }

    public abstract ListIterator getIntervalEvents();

    public void setIntervalEvent(IntervalEvent intervalEvent) {
        if (intervalEvent == null) {
            this.intervalEvents = null;
        } else {
            this.intervalEvents = new Vector();
            this.intervalEvents.addElement(intervalEvent);
        }
    }

    public abstract IntervalEvent setIntervalEvent(int var1);

    public void setIntervalEvent(Vector vector) {
        this.intervalEvents = vector;
    }

    public abstract IntervalEvent getIntervalEvent(int var1);

    public abstract ListIterator getAtomicEvents();

    public void setAtomicEvent(AtomicEvent atomicEvent) {
        if (atomicEvent == null) {
            this.atomicEvents = null;
        } else {
            this.atomicEvents = new Vector();
            this.atomicEvents.addElement(atomicEvent);
        }
    }

    public abstract AtomicEvent setAtomicEvent(int var1);

    public void setAtomicEvent(Vector vector) {
        this.atomicEvents = vector;
    }

    public abstract AtomicEvent getAtomicEvent(int var1);

    public abstract ListIterator getIntervalEventData();

    public abstract ListIterator getAtomicEventData();

    public abstract void getIntervalEventDetail(IntervalEvent var1);

    public abstract void getAtomicEventDetail(AtomicEvent var1);

    public abstract int saveTrial();

    public abstract int saveTrial(Trial var1);

    public abstract int saveIntervalEvent(IntervalEvent var1, int var2, Hashtable var3);

    public abstract void saveIntervalEventData(IntervalLocationProfile var1, int var2, Hashtable var3);

    public abstract int saveAtomicEvent(AtomicEvent var1, int var2);

    public abstract void saveAtomicEventData(AtomicLocationProfile var1, int var2);

    public void setNCT(NCT nCT) {
        this.nct = nCT;
    }

    public NCT getNCT() {
        return this.nct;
    }

    public void setGlobalMapping(GlobalMapping globalMapping) {
        this.globalMapping = globalMapping;
    }

    public GlobalMapping getGlobalMapping() {
        return this.globalMapping;
    }

    public void reset() {
        this.application = null;
        this.experiment = null;
        this.trial = null;
        this.nodes = null;
        this.contexts = null;
        this.threads = null;
        this.intervalEvents = null;
        this.metrics = null;
        this.intervalEventData = null;
        this.atomicEvents = null;
        this.atomicEventData = null;
    }

    public void deleteTrial(int n) {
    }

    public void deleteApplication(int n) {
    }

    public void deleteExperiment(int n) {
    }

    public int saveExperiment(Experiment experiment) {
        return -1;
    }
}

