/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.BinWindowPanel;
import edu.uoregon.tau.paraprof.MappingLedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.StaticMainWindowData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class BinWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private ParaProfTrial trial = null;
    private StaticMainWindowData sMWData = null;
    private int mappingID = -1;
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private JMenu windowsMenu = null;
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane sp = null;
    private BinWindowPanel panel = null;
    private Vector list = null;
    private boolean debug = false;

    public BinWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW01");
        }
    }

    public BinWindow(ParaProfTrial paraProfTrial, StaticMainWindowData staticMainWindowData, boolean bl, int n, boolean bl2) {
        try {
            this.trial = paraProfTrial;
            this.sMWData = staticMainWindowData;
            this.mappingID = n;
            this.debug = bl2;
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(700, 450));
            this.setTitle("ParaProf: " + paraProfTrial.getTrialIdentifier(true));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    BinWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (ParaProf.helpWindow.isVisible()) {
                this.help(false);
            }
            this.sortLocalData();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = null;
            JMenuItem jMenuItem = null;
            JMenu jMenu2 = new JMenu("File");
            jMenu = new JMenu("Open ...");
            jMenuItem = new JMenuItem("ParaProf Manager");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Bin Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu2.add(jMenu);
            jMenu = new JMenu("Save ...");
            jMenuItem = new JMenuItem("ParaProf Preferrences");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Save Image");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu2.add(jMenu);
            jMenuItem = new JMenuItem("Edit ParaProf Preferences!");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Print");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenuItem = new JMenuItem("Exit ParaProf!");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            jMenu2.addMenuListener(this);
            this.windowsMenu = new JMenu("Windows");
            jMenuItem = new JMenuItem("Show Function Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Group Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show User Event Ledger");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Call Path Relations");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Close All Sub-Windows");
            jMenuItem.addActionListener(this);
            this.windowsMenu.add(jMenuItem);
            this.windowsMenu.addMenuListener(this);
            JMenu jMenu3 = new JMenu("Help");
            jMenuItem = new JMenuItem("Show Help Window");
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
            jMenuItem = new JMenuItem("About ParaProf");
            jMenuItem.addActionListener(this);
            jMenu3.add(jMenuItem);
            jMenu3.addMenuListener(this);
            jMenuBar.add(jMenu2);
            jMenuBar.add(this.windowsMenu);
            jMenuBar.add(jMenu3);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            this.panel = new BinWindowPanel(paraProfTrial, this, bl, n, this.debug());
            this.sp = new JScrollPane(this.panel);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    PageFormat pageFormat = printerJob.defaultPage();
                    PageFormat pageFormat2 = printerJob.pageDialog(pageFormat);
                    printerJob.setPrintable(this.panel, pageFormat2);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                } else if (string.equals("Edit ParaProf Preferences!")) {
                    this.trial.getPreferences().showPreferencesWindow();
                } else if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else if (string.equals("Show Function Ledger")) {
                    new MappingLedgerWindow(this.trial, 0, this.debug()).show();
                } else if (string.equals("Show Group Ledger")) {
                    new MappingLedgerWindow(this.trial, 1, this.debug()).show();
                } else if (string.equals("Show User Event Ledger")) {
                    new MappingLedgerWindow(this.trial, 2, this.debug()).show();
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About ParaProf")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    this.help(true);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW03");
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.trial.groupNamesPresent()) {
                this.windowsMenu.getItem(1).setEnabled(true);
            } else {
                this.windowsMenu.getItem(1).setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.panel.repaint();
            } else if (string.equals("colorEvent")) {
                this.panel.repaint();
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
                this.panel.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW05");
        }
    }

    private void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the thread data window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you the values for all mappings on this thread.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right click on any mapping within this window to bring up a popup");
        ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
        ParaProf.helpWindow.writeText("for the mapping, or to show more details about the mapping.");
        ParaProf.helpWindow.writeText("You can also left click any mapping to hightlight it in the system.");
    }

    private void sortLocalData() {
        try {
            this.list = null;
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW06");
        }
    }

    public Vector getData() {
        return this.list;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW09");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (UtilFncs.debug) {
                System.out.println("------------------------");
                System.out.println("A thread window for: \"n,c,t, " + this.nodeID + "," + this.contextID + "," + this.threadID + "\" is closing");
                System.out.println("Clearing resourses for that window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"TDW10");
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

