/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProfImageFormatFileFilter;
import edu.uoregon.tau.paraprof.ParaProfImageOptionsPanel;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class ParaProfImageOutput {
    private ParaProfImageOutput() {
    }

    public static void saveImage(ImageExport imageExport) throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Image File");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.PNG));
        jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.JPG));
        jFileChooser.setFileSelectionMode(0);
        ParaProfImageOptionsPanel paraProfImageOptionsPanel = new ParaProfImageOptionsPanel((Component)((Object)imageExport), true);
        jFileChooser.setAccessory(paraProfImageOptionsPanel);
        jFileChooser.addPropertyChangeListener(paraProfImageOptionsPanel);
        int n = jFileChooser.showSaveDialog((Component)((Object)imageExport));
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        String string = file.getCanonicalPath();
        ParaProfImageFormatFileFilter paraProfImageFormatFileFilter = null;
        if (fileFilter instanceof ParaProfImageFormatFileFilter) {
            int n2;
            paraProfImageFormatFileFilter = (ParaProfImageFormatFileFilter)fileFilter;
            String string2 = ParaProfImageFormatFileFilter.getExtension(file);
            if (string2 == null) {
                string = string + "." + paraProfImageFormatFileFilter.getExtension();
                file = new File(string);
            } else if (!string2.equals("png") && !string2.equals("jpg")) {
                string = string + "." + paraProfImageFormatFileFilter.getExtension();
                file = new File(string);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog((Component)((Object)imageExport), file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                return;
            }
            Dimension dimension = imageExport.getImageSize(paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            BufferedImage bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            imageExport.export(graphics2D, false, paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            dimension = imageExport.getImageSize(paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            bufferedImage = new BufferedImage((int)dimension.getWidth(), (int)dimension.getHeight(), 1);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight());
            graphics2D.setColor(Color.black);
            imageExport.export(graphics2D, false, paraProfImageOptionsPanel.isFullScreen(), paraProfImageOptionsPanel.isPrependHeader());
            ImageWriter imageWriter = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(paraProfImageFormatFileFilter.getExtension().toUpperCase());
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            if (paraProfImageOptionsPanel.imageQualityEnabled()) {
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(paraProfImageOptionsPanel.getImageQuality());
                imageWriter.write(null, iIOImage, imageWriteParam);
            } else {
                imageWriter.write(iIOImage);
            }
        }
    }

    public static void save3dImage(ThreeDeeWindow threeDeeWindow) throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Image File");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.PNG));
        jFileChooser.addChoosableFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.JPG));
        jFileChooser.setFileSelectionMode(0);
        ParaProfImageOptionsPanel paraProfImageOptionsPanel = new ParaProfImageOptionsPanel(threeDeeWindow, false);
        jFileChooser.setAccessory(paraProfImageOptionsPanel);
        jFileChooser.addPropertyChangeListener(paraProfImageOptionsPanel);
        int n = jFileChooser.showSaveDialog(threeDeeWindow);
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        FileFilter fileFilter = jFileChooser.getFileFilter();
        String string = file.getCanonicalPath();
        ParaProfImageFormatFileFilter paraProfImageFormatFileFilter = null;
        if (fileFilter instanceof ParaProfImageFormatFileFilter) {
            paraProfImageFormatFileFilter = (ParaProfImageFormatFileFilter)fileFilter;
            String string2 = ParaProfImageFormatFileFilter.getExtension(file);
            if (string2 == null) {
                string = string + "." + paraProfImageFormatFileFilter.getExtension();
                file = new File(string);
            } else if (!string2.equals("png") && !string2.equals("jpg")) {
                string = string + "." + paraProfImageFormatFileFilter.getExtension();
                file = new File(string);
            }
            String string3 = paraProfImageFormatFileFilter.getExtension().toUpperCase();
            File file2 = file;
            jFileChooser.setVisible(false);
            BufferedImage bufferedImage = threeDeeWindow.getImage();
            ImageWriter imageWriter = null;
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string3);
            if (iterator.hasNext()) {
                imageWriter = iterator.next();
            }
            ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            if (paraProfImageOptionsPanel.imageQualityEnabled()) {
                ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                imageWriteParam.setCompressionMode(2);
                imageWriteParam.setCompressionQuality(paraProfImageOptionsPanel.getImageQuality());
                imageWriter.write(null, iIOImage, imageWriteParam);
            } else {
                imageWriter.write(iIOImage);
            }
        }
    }
}

