/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.treetable.CallPathModel;
import edu.uoregon.tau.paraprof.treetable.TreeTableColumn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeTableNode
extends DefaultMutableTreeNode
implements Comparable {
    private List children;
    private FunctionProfile functionProfile;
    private String displayName;
    private boolean expanded;
    private Icon icon;
    private CallPathModel model;
    private String alternateName;

    public TreeTableNode(FunctionProfile functionProfile, CallPathModel callPathModel, String string) {
        this.functionProfile = functionProfile;
        this.model = callPathModel;
        this.alternateName = string;
        if (functionProfile != null) {
            int n;
            this.displayName = functionProfile.getName();
            if (callPathModel.getWindow().getTreeMode() && (n = this.displayName.lastIndexOf("=>")) != -1) {
                this.displayName = this.displayName.substring(n + 2).trim();
            }
        } else {
            this.displayName = string;
        }
    }

    public FunctionProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public List getChildren() {
        this.checkInitChildren();
        return this.children;
    }

    public int getNumChildren() {
        this.checkInitChildren();
        return this.children.size();
    }

    private void checkInitChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            List list = this.model.getThread().getFunctionProfiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                int n;
                int n2;
                FunctionProfile functionProfile = (FunctionProfile)iterator.next();
                if (functionProfile == this.functionProfile || functionProfile == null || !functionProfile.isCallPathFunction()) continue;
                String string2 = functionProfile.getName();
                String string3 = this.alternateName;
                if (this.functionProfile != null) {
                    string3 = this.functionProfile.getName();
                }
                if ((n2 = string2.indexOf(string3)) != 0 || (n = (string = string2.substring(string3.length()).trim()).lastIndexOf("=>")) != 0) continue;
                TreeTableNode treeTableNode = new TreeTableNode(functionProfile, this.model, null);
                this.children.add(treeTableNode);
            }
        }
        Collections.sort(this.children);
    }

    public String toString() {
        return this.displayName;
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        this.expanded = bl;
        this.icon = null;
    }

    public Color getColor(int n) {
        if (!this.model.getWindow().getTreeMode()) {
            return null;
        }
        if (this.functionProfile != null && this.model.getMaxValues()[n] != 0.0) {
            double d = this.expanded ? this.functionProfile.getExclusive(n) : this.functionProfile.getInclusive(n);
            Color color = ColorBar.getColor((float)(d / this.model.getMaxValues()[n]));
            return color;
        }
        return null;
    }

    public void sortChildren() {
        if (this.children != null) {
            Collections.sort(this.children);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
                treeTableNode.sortChildren();
            }
        }
    }

    public int compareTo(Object object) {
        int n;
        if (this.model.getSortColumn() == 0) {
            n = this.toString().compareTo(((TreeTableNode)object).toString());
        } else {
            TreeTableColumn treeTableColumn = (TreeTableColumn)this.model.getWindow().getColumns().get(this.model.getSortColumn() - 1);
            Comparable comparable = (Comparable)treeTableColumn.getValueFor(this, true);
            Comparable comparable2 = (Comparable)treeTableColumn.getValueFor((TreeTableNode)object, true);
            n = comparable.compareTo(comparable2);
        }
        if (this.model.getSortAscending()) {
            return -n;
        }
        return n;
    }

    public CallPathModel getModel() {
        return this.model;
    }
}

