/*
 * Decompiled with CFR 0.152.
 */
package perfdb.util.dbinterface;

import java.io.BufferedReader;
import java.io.FileReader;

public class ParseConfig {
    private String perfdbHome;
    private String jdbcJarFile;
    private String jdbcDriver;
    private String dbType;
    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbUserName;
    private String dbPasswd;
    private String dbSchema;
    private String xmlSAXParser;

    /*
     * WARNING - void declaration
     */
    public ParseConfig(String configLoc) {
        try {
            String inputString;
            BufferedReader reader = new BufferedReader(new FileReader(configLoc));
            while ((inputString = reader.readLine()) != null) {
                void var2_4;
                if (var2_4.startsWith("#") || var2_4.trim().equals("")) continue;
                String name = this.getNameToken((String)var2_4).toLowerCase();
                String value = this.getValueToken((String)var2_4);
                if (name.equals("perfdb_home")) {
                    this.perfdbHome = value;
                    continue;
                }
                if (name.equals("jdbc_db_jarfile")) {
                    this.jdbcJarFile = value;
                    continue;
                }
                if (name.equals("jdbc_db_driver")) {
                    this.jdbcDriver = value;
                    continue;
                }
                if (name.equals("jdbc_db_type")) {
                    this.dbType = value;
                    continue;
                }
                if (name.equals("db_hostname")) {
                    this.dbHost = value;
                    continue;
                }
                if (name.equals("db_portnum")) {
                    this.dbPort = value;
                    continue;
                }
                if (name.equals("db_dbname")) {
                    this.dbName = value;
                    continue;
                }
                if (name.equals("db_username")) {
                    this.dbUserName = value;
                    continue;
                }
                if (name.equals("db_password")) {
                    this.dbPasswd = value;
                    continue;
                }
                if (name.equals("db_schemafile")) {
                    this.dbSchema = value;
                    continue;
                }
                if (name.equals("xml_sax_parser")) {
                    this.xmlSAXParser = value;
                    continue;
                }
                System.out.println(name + " is not a valid configuration item.");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public String getNameToken(String aLine) {
        int i = aLine.indexOf(":");
        if (i > 0) {
            return aLine.substring(0, i).trim();
        }
        System.out.println(aLine);
        System.out.println("This is an abnormal term. The correct form is name:value.");
        return null;
    }

    public String getValueToken(String aLine) {
        int i = aLine.indexOf(":");
        if (i > 0) {
            return aLine.substring(i + 1).trim();
        }
        System.out.println("This is an abnormal term. The correct form is name:value.");
        return null;
    }

    public String getPerfDBHome() {
        return this.perfdbHome;
    }

    public String getJDBCJarFile() {
        return this.jdbcJarFile;
    }

    public String getJDBCDriver() {
        return this.jdbcDriver;
    }

    public String getDBType() {
        return this.dbType;
    }

    public String getDBHost() {
        return this.dbHost;
    }

    public String getDBPort() {
        return this.dbPort;
    }

    public String getDBName() {
        return this.dbName;
    }

    public String getDBUserName() {
        return this.dbUserName;
    }

    public String getDBPasswd() {
        return this.dbPasswd;
    }

    public String getDBSchema() {
        return this.dbSchema;
    }

    public String getXMLSAXParser() {
        return this.xmlSAXParser;
    }
}

